/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;

public class StringObject
extends ScalarObject {
    private static final long serialVersionUID = 2464839775369002455L;
    private static final int MAX_STRING_SIZE = 0x100000;
    private final String _value;

    public StringObject(String val) {
        super(Types.ValueType.STRING);
        this._value = val;
    }

    @Override
    public boolean getBooleanValue() {
        return "TRUE".equals(this._value);
    }

    @Override
    public long getLongValue() {
        return this.getBooleanValue() ? 1L : 0L;
    }

    @Override
    public double getDoubleValue() {
        return this.getBooleanValue() ? 1.0 : 0.0;
    }

    @Override
    public String getStringValue() {
        return this._value;
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public int getSize() {
        return 16 + this._value.length() * 1;
    }

    public static void checkMaxStringLength(long len) {
        if (len > 0x100000L) {
            throw new DMLRuntimeException("Output string length exceeds maximum scalar string length (" + len + " > " + 0x100000 + ").");
        }
    }
}

