/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class TsmmFEDInstruction
extends BinaryFEDInstruction {
    private final MMTSJ.MMTSJType _type;
    private final int _numThreads;

    public TsmmFEDInstruction(CPOperand in, CPOperand out, MMTSJ.MMTSJType type, int k, String opcode, String istr) {
        super(FEDInstruction.FEDType.Tsmm, null, in, null, out, opcode, istr);
        this._type = type;
        this._numThreads = k;
    }

    public static TsmmFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("tsmm")) {
            throw new DMLRuntimeException("TsmmFedInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        InstructionUtils.checkNumFields(parts, 4);
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        MMTSJ.MMTSJType type = MMTSJ.MMTSJType.valueOf(parts[3]);
        int k = Integer.parseInt(parts[4]);
        return new TsmmFEDInstruction(in, out, type, k, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        if (!mo1.isFederated() || !this._type.isLeft()) {
            throw new DMLRuntimeException("Federated Tsmm not supported with the following federated objects: " + mo1.isFederated() + " " + (Object)((Object)this._fedType));
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{mo1.getFedMapping().getID()});
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        FederatedRequest fr3 = mo1.getFedMapping().cleanup(this.getTID(), fr1.getID());
        Future<FederatedResponse>[] tmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2, fr3);
        MatrixBlock ret = FederationUtils.aggAdd(tmp);
        ec.setMatrixOutput(this.output.getName(), ret);
    }
}

