/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.ParForStatement;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.parser.Statement;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.parser.dml.CustomErrorListener;
import org.apache.sysds.runtime.io.IOUtilFunctions;

public abstract class ParserWrapper {
    protected boolean atLeastOneError = false;
    protected boolean atLeastOneWarning = false;
    protected List<CustomErrorListener.ParseIssue> parseIssues;
    private static FileSystem fs = null;

    public abstract DMLProgram parse(String var1, String var2, Map<String, String> var3);

    public static StatementBlock getStatementBlock(Statement current) {
        StatementBlock blk = null;
        if (current instanceof ParForStatement) {
            blk = new ParForStatementBlock();
            blk.addStatement(current);
        } else if (current instanceof ForStatement) {
            blk = new ForStatementBlock();
            blk.addStatement(current);
        } else if (current instanceof IfStatement) {
            blk = new IfStatementBlock();
            blk.addStatement(current);
        } else if (current instanceof WhileStatement) {
            blk = new WhileStatementBlock();
            blk.addStatement(current);
        } else {
            blk = new StatementBlock();
            blk.addStatement(current);
        }
        return blk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String readDMLScript(String script, Log LOG) throws IOException, LanguageException {
        dmlScriptStr = null;
        if (script == null) {
            throw new LanguageException("DML script path was not specified!");
        }
        sb = new StringBuilder();
        in = null;
        try {
            if (script.startsWith("hdfs:") || script.startsWith("gpfs:") || IOUtilFunctions.isObjectStoreFileScheme(new Path(script))) {
                scriptPath = new Path(script);
                scheme = scriptPath.toUri() != null ? scriptPath.toUri().getScheme() : null;
                LOG.debug((Object)("Looking for the following file in " + scheme + ": " + script));
                ParserWrapper.fs = IOUtilFunctions.getFileSystem(scriptPath);
                in = new BufferedReader(new InputStreamReader((InputStream)ParserWrapper.fs.open(scriptPath)));
            } else {
                LOG.debug((Object)("Looking for the following file in the local file system: " + script));
                in = Files.exists(Paths.get(script, new String[0]), new LinkOption[0]) != false ? new BufferedReader(new FileReader(script)) : new BufferedReader(new FileReader("scripts/" + script));
            }
            tmp = null;
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
                sb.append("\n");
            }
            ** if (ParserWrapper.fs == null) goto lbl-1000
        }
        catch (IOException ex) {
            resPath = ParserWrapper.scriptPathToResourcePath(script);
            LOG.debug((Object)("Looking for the following resource from the SystemDS jar file: " + resPath));
            is = null;
            try {
                is = ParserWrapper.class.getResourceAsStream(resPath);
                if (is == null) {
                    if (resPath.startsWith("/scripts")) {
                        LOG.error((Object)("Failed to read from the file system ('" + script + "') or SystemDS jar file ('" + resPath + "')"));
                        throw ex;
                    }
                    scriptsResPath = "/scripts" + resPath;
                    LOG.debug((Object)("Looking for the following resource from the SystemDS jar file: " + scriptsResPath));
                    is = ParserWrapper.class.getResourceAsStream(scriptsResPath);
                    if (is == null) {
                        LOG.error((Object)("Failed to read from the file system ('" + script + "') or SystemDS jar file ('" + resPath + "' or '" + scriptsResPath + "')"));
                        throw ex;
                    }
                }
                var8_10 = IOUtils.toString((InputStream)is);
            }
            catch (Throwable var9_11) {
                IOUtilFunctions.closeSilently(is);
                throw var9_11;
            }
            IOUtilFunctions.closeSilently(is);
            return var8_10;
        }
        finally {
            if (ParserWrapper.fs != null) {
                ParserWrapper.fs.close();
            }
            IOUtilFunctions.closeSilently(in);
        }
lbl-1000:
        // 1 sources

        {
            ParserWrapper.fs.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        IOUtilFunctions.closeSilently(in);
        dmlScriptStr = sb.toString();
        return dmlScriptStr;
    }

    private static String scriptPathToResourcePath(String scriptPath) {
        String resPath = scriptPath;
        if (resPath.startsWith(".")) {
            resPath = resPath.substring(1);
        } else if (!resPath.startsWith("\\") && !resPath.startsWith("/")) {
            resPath = "/" + resPath;
        }
        resPath = resPath.replace("\\", "/");
        return resPath;
    }

    public boolean isAtLeastOneError() {
        return this.atLeastOneError;
    }

    public boolean isAtLeastOneWarning() {
        return this.atLeastOneWarning;
    }

    public List<CustomErrorListener.ParseIssue> getParseIssues() {
        return this.parseIssues;
    }
}

