/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ColumnEncoderRecode
extends ColumnEncoder {
    private static final long serialVersionUID = 8213163881283341874L;
    public static boolean SORT_RECODE_MAP = false;
    private HashMap<String, Long> _rcdMap = new HashMap();
    private HashSet<Object> _rcdMapPart = null;

    public ColumnEncoderRecode(int colID) {
        super(colID);
    }

    public ColumnEncoderRecode() {
        this(-1);
    }

    private ColumnEncoderRecode(int colID, HashMap<String, Long> rcdMap) {
        super(colID);
        this._rcdMap = rcdMap;
    }

    public static String constructRecodeMapEntry(String token, Long code) {
        StringBuilder sb = new StringBuilder(token.length() + 16);
        return ColumnEncoderRecode.constructRecodeMapEntry(token, code, sb);
    }

    private static String constructRecodeMapEntry(String token, Long code, StringBuilder sb) {
        sb.setLength(0);
        return sb.append(token).append("\u00b7").append(code).toString();
    }

    public static String[] splitRecodeMapEntry(String value) {
        int pos = value.lastIndexOf("\u00b7");
        return new String[]{value.substring(0, pos), value.substring(pos + 1)};
    }

    public HashMap<String, Long> getCPRecodeMaps() {
        return this._rcdMap;
    }

    public HashSet<Object> getCPRecodeMapsPartial() {
        return this._rcdMapPart;
    }

    public void sortCPRecodeMaps() {
        ColumnEncoderRecode.sortCPRecodeMaps(this._rcdMap);
    }

    private static void sortCPRecodeMaps(HashMap<String, Long> map) {
        Object[] keys = map.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        map.clear();
        for (Object key : keys) {
            ColumnEncoderRecode.putCode(map, (String)key);
        }
    }

    private static void makeRcdMap(FrameBlock in, HashMap<String, Long> map, int colID, int startRow, int blk) {
        Iterator<String[]> iter = in.getStringRowIterator(startRow, UtilFunctions.getEndIndex(in.getNumRows(), startRow, blk), colID);
        while (iter.hasNext()) {
            String[] row = iter.next();
            String key = row[0];
            if (key == null || key.isEmpty() || map.containsKey(key)) continue;
            ColumnEncoderRecode.putCode(map, key);
        }
        if (SORT_RECODE_MAP) {
            ColumnEncoderRecode.sortCPRecodeMaps(map);
        }
    }

    private long lookupRCDMap(String key) {
        Long tmp = this._rcdMap.get(key);
        return tmp != null ? tmp : -1L;
    }

    @Override
    public void build(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        ColumnEncoderRecode.makeRcdMap(in, this._rcdMap, this._colID, 0, in.getNumRows());
    }

    @Override
    public List<Callable<Object>> getPartialBuildTasks(FrameBlock in, int blockSize) {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (int i = 0; i < in.getNumRows(); i += blockSize) {
            tasks.add(new RecodePartialBuildTask(in, this._colID, i, blockSize));
        }
        if (in.getNumRows() % blockSize != 0) {
            tasks.add(new RecodePartialBuildTask(in, this._colID, in.getNumRows() - in.getNumRows() % blockSize, -1));
        }
        return tasks;
    }

    @Override
    public void mergeBuildPartial(List<Future<Object>> futurePartials, int start, int end) throws ExecutionException, InterruptedException {
        for (int i = start; i < end; ++i) {
            Object partial = futurePartials.get(i).get();
            if (!(partial instanceof HashMap)) {
                throw new DMLRuntimeException("Tried to merge " + partial.getClass() + " object into RecodeEncoder. HashMap was expected.");
            }
            HashMap partialMap = (HashMap)partial;
            partialMap.forEach((k, v) -> {
                if (!this._rcdMap.containsKey((String)k)) {
                    ColumnEncoderRecode.putCode(this._rcdMap, (String)k);
                }
            });
        }
    }

    protected static void putCode(HashMap<String, Long> map, String key) {
        map.put(key, Long.valueOf(map.size() + 1));
    }

    @Override
    public void prepareBuildPartial() {
        if (this._rcdMapPart == null) {
            this._rcdMapPart = new HashSet();
        }
    }

    @Override
    public void buildPartial(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        for (int i = 0; i < in.getNumRows(); ++i) {
            this._rcdMapPart.add(in.get(i, this._colID - 1));
        }
        this._rcdMapPart.remove(null);
        this._rcdMapPart.remove("");
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        for (int i = rowStart; i < UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk); ++i) {
            Object okey = in.get(i, this._colID - 1);
            String key = okey != null ? okey.toString() : null;
            long code = this.lookupRCDMap(key);
            out.quickSetValueThreadSafe(i, outputCol, code >= 0L ? (double)code : Double.NaN);
        }
        return out;
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        throw new DMLRuntimeException("Recode called with MatrixBlock. Should not happen since Recode is the first encoder in the Stack");
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol) {
        throw new DMLRuntimeException("Recode called with MatrixBlock. Should not happen since Recode is the first encoder in the Stack");
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (!(other instanceof ColumnEncoderRecode)) {
            super.mergeAt(other);
            return;
        }
        assert (other._colID == this._colID);
        ColumnEncoderRecode otherRec = (ColumnEncoderRecode)other;
        HashMap<String, Long> otherMap = otherRec._rcdMap;
        if (otherMap != null) {
            for (Map.Entry<String, Long> entry : otherMap.entrySet()) {
                if (this.lookupRCDMap(entry.getKey()) != -1L) continue;
                ColumnEncoderRecode.putCode(this._rcdMap, entry.getKey());
            }
        }
    }

    public int getNumDistinctValues() {
        return this._rcdMap.size();
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        meta.ensureAllocatedColumns(this.getNumDistinctValues());
        StringBuilder sb = new StringBuilder();
        int rowID = 0;
        for (Map.Entry<String, Long> e : this._rcdMap.entrySet()) {
            meta.set(rowID++, this._colID - 1, ColumnEncoderRecode.constructRecodeMapEntry(e.getKey(), e.getValue(), sb));
        }
        meta.getColumnMetadata(this._colID - 1).setNumDistinct(this.getNumDistinctValues());
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        this._rcdMap = meta.getRecodeMap(this._colID - 1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._rcdMap.size());
        for (Map.Entry<String, Long> e : this._rcdMap.entrySet()) {
            out.writeUTF(e.getKey());
            out.writeLong(e.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        int size = in.readInt();
        for (int j = 0; j < size; ++j) {
            String key = in.readUTF();
            Long value = in.readLong();
            this._rcdMap.put(key, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnEncoderRecode that = (ColumnEncoderRecode)o;
        return Objects.equals(this._rcdMap, that._rcdMap);
    }

    public int hashCode() {
        return Objects.hash(this._rcdMap);
    }

    public HashMap<String, Long> getRcdMap() {
        return this._rcdMap;
    }

    private static class RecodePartialBuildTask
    implements Callable<Object> {
        private final FrameBlock _input;
        private final int _blockSize;
        private final int _startRow;
        private final int _colID;

        protected RecodePartialBuildTask(FrameBlock input, int colID, int startRow, int blocksize) {
            this._input = input;
            this._blockSize = blocksize;
            this._colID = colID;
            this._startRow = startRow;
        }

        @Override
        public HashMap<String, Long> call() throws Exception {
            HashMap<String, Long> partialMap = new HashMap<String, Long>();
            ColumnEncoderRecode.makeRcdMap(this._input, partialMap, this._colID, this._startRow, this._blockSize);
            return partialMap;
        }
    }
}

