/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.compile.Dag;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.IntegerDivide;
import org.apache.sysds.runtime.functionobjects.Modulus;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;

public class OptimizerUtils {
    public static double MEM_UTIL_FACTOR = 0.7;
    public static final int DEFAULT_BLOCKSIZE = 1000;
    public static final int DEFAULT_FRAME_BLOCKSIZE = 1000;
    public static final OptimizationLevel DEFAULT_OPTLEVEL = OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT;
    public static double DEFAULT_SIZE;
    public static final long DOUBLE_SIZE = 8L;
    public static final long INT_SIZE = 4L;
    public static final long CHAR_SIZE = 1L;
    public static final long BOOLEAN_SIZE = 1L;
    public static final double INVALID_SIZE = -1.0;
    public static final long MAX_NUMCELLS_CP_DENSE = Integer.MAX_VALUE;
    public static final long MAX_NNZ_CP_SPARSE;
    public static final long SAFE_REP_CHANGE_THRES = 0x800000L;
    public static boolean ALLOW_COMMON_SUBEXPRESSION_ELIMINATION;
    public static boolean ALLOW_CONSTANT_FOLDING;
    public static boolean ALLOW_ALGEBRAIC_SIMPLIFICATION;
    public static boolean ALLOW_OPERATOR_FUSION;
    public static boolean ALLOW_BRANCH_REMOVAL;
    public static boolean ALLOW_FOR_LOOP_REMOVAL;
    public static boolean ALLOW_AUTO_VECTORIZATION;
    public static boolean ALLOW_SIZE_EXPRESSION_EVALUATION;
    public static boolean ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION;
    public static boolean ALLOW_RAND_JOB_RECOMPILE;
    public static boolean ALLOW_RUNTIME_PIGGYBACKING;
    public static boolean ALLOW_INTER_PROCEDURAL_ANALYSIS;
    public static int IPA_NUM_REPETITIONS;
    public static boolean ALLOW_SUM_PRODUCT_REWRITES;
    public static boolean ALLOW_SPLIT_HOP_DAGS;
    public static boolean ALLOW_LOOP_UPDATE_IN_PLACE;
    public static boolean ALLOW_EVAL_FCALL_REPLACEMENT;
    public static boolean ALLOW_CODE_MOTION;
    public static boolean FEDERATED_COMPILATION;
    public static final double PARALLEL_CP_READ_PARALLELISM_MULTIPLIER = 1.0;
    public static final double PARALLEL_CP_WRITE_PARALLELISM_MULTIPLIER = 1.0;
    public static final boolean ALLOW_COMBINE_FILE_INPUT_FORMAT = true;
    public static final boolean ALLOW_SCRIPT_LEVEL_COMPRESS_COMMAND = true;
    public static boolean ALLOW_COMPRESSION_REWRITE;
    public static boolean ALLOW_TRANSITIVE_SPARK_EXEC_TYPE;
    public static boolean ASYNC_TRIGGER_RDD_OPERATIONS;

    public static OptimizationLevel getOptLevel() {
        int optlevel = ConfigurationManager.getCompilerConfig().getInt(CompilerConfig.ConfigType.OPT_LEVEL);
        return OptimizationLevel.values()[optlevel];
    }

    public static boolean isMemoryBasedOptLevel() {
        return OptimizerUtils.getOptLevel() != OptimizationLevel.O0_LOCAL_STATIC;
    }

    public static boolean isOptLevel(OptimizationLevel level) {
        return OptimizerUtils.getOptLevel() == level;
    }

    public static CompilerConfig constructCompilerConfig(DMLConfig dmlconf) {
        return OptimizerUtils.constructCompilerConfig(new CompilerConfig(), dmlconf);
    }

    public static CompilerConfig constructCompilerConfig(CompilerConfig cconf, DMLConfig dmlconf) {
        cconf.set(CompilerConfig.ConfigType.BLOCK_SIZE, dmlconf.getIntValue("sysds.defaultblocksize"));
        int optlevel = dmlconf.getIntValue("sysds.optlevel");
        if (optlevel < 0 || optlevel > 7) {
            throw new DMLRuntimeException("Error: invalid optimization level '" + optlevel + "' (valid values: 0-5).");
        }
        switch (optlevel) {
            case 0: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O0_LOCAL_STATIC.ordinal());
                ALLOW_CONSTANT_FOLDING = false;
                ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = false;
                ALLOW_ALGEBRAIC_SIMPLIFICATION = false;
                ALLOW_AUTO_VECTORIZATION = false;
                ALLOW_INTER_PROCEDURAL_ANALYSIS = false;
                IPA_NUM_REPETITIONS = 1;
                ALLOW_BRANCH_REMOVAL = false;
                ALLOW_FOR_LOOP_REMOVAL = false;
                ALLOW_SUM_PRODUCT_REWRITES = false;
                break;
            }
            case 1: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O1_LOCAL_MEMORY_MIN.ordinal());
                ALLOW_CONSTANT_FOLDING = false;
                ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = false;
                ALLOW_ALGEBRAIC_SIMPLIFICATION = false;
                ALLOW_AUTO_VECTORIZATION = false;
                ALLOW_INTER_PROCEDURAL_ANALYSIS = false;
                IPA_NUM_REPETITIONS = 1;
                ALLOW_BRANCH_REMOVAL = false;
                ALLOW_FOR_LOOP_REMOVAL = false;
                ALLOW_SUM_PRODUCT_REWRITES = false;
                ALLOW_LOOP_UPDATE_IN_PLACE = false;
                break;
            }
            case 2: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT.ordinal());
                break;
            }
            case 3: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O3_LOCAL_RESOURCE_TIME_MEMORY.ordinal());
                break;
            }
            case 4: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O4_GLOBAL_TIME_MEMORY.ordinal());
                break;
            }
            case 6: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT.ordinal());
                ALLOW_AUTO_VECTORIZATION = false;
                break;
            }
            case 7: {
                cconf.set(CompilerConfig.ConfigType.OPT_LEVEL, OptimizationLevel.O2_LOCAL_MEMORY_DEFAULT.ordinal());
                ALLOW_OPERATOR_FUSION = false;
                ALLOW_AUTO_VECTORIZATION = false;
                ALLOW_SUM_PRODUCT_REWRITES = false;
            }
        }
        if (!dmlconf.getBooleanValue("sysds.cp.parallel.io")) {
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS, false);
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS, false);
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS, false);
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS, false);
        }
        if (!dmlconf.getBooleanValue("sysds.cp.parallel.ops")) {
            cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_MATRIX_OPERATIONS, false);
        }
        return cconf;
    }

    public static void resetStaticCompilerFlags() {
        ALLOW_ALGEBRAIC_SIMPLIFICATION = true;
        ALLOW_AUTO_VECTORIZATION = true;
        ALLOW_BRANCH_REMOVAL = true;
        ALLOW_FOR_LOOP_REMOVAL = true;
        ALLOW_CONSTANT_FOLDING = true;
        ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = true;
        ALLOW_INTER_PROCEDURAL_ANALYSIS = true;
        ALLOW_LOOP_UPDATE_IN_PLACE = true;
        ALLOW_OPERATOR_FUSION = true;
        ALLOW_RAND_JOB_RECOMPILE = true;
        ALLOW_SIZE_EXPRESSION_EVALUATION = true;
        ALLOW_SPLIT_HOP_DAGS = true;
        ALLOW_SUM_PRODUCT_REWRITES = true;
        ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION = true;
        IPA_NUM_REPETITIONS = 3;
    }

    public static long getDefaultSize() {
        return InfrastructureAnalyzer.getLocalMaxMemory();
    }

    public static void resetDefaultSize() {
        DEFAULT_SIZE = OptimizerUtils.getDefaultSize();
    }

    public static int getDefaultFrameSize() {
        return 1000;
    }

    public static double getLocalMemBudget() {
        double ret = InfrastructureAnalyzer.getLocalMaxMemory();
        return ret * MEM_UTIL_FACTOR;
    }

    public static boolean isMaxLocalParallelism(int k) {
        return InfrastructureAnalyzer.getLocalParallelism() == k;
    }

    public static boolean isTopLevelParFor() {
        return InfrastructureAnalyzer.getLocalMaxMemoryFraction() >= 0.99;
    }

    public static boolean checkSparkBroadcastMemoryBudget(double size) {
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        return size < memBudgetExec && 2.0 * size < memBudgetLocal;
    }

    public static boolean checkSparkBroadcastMemoryBudget(long rlen, long clen, long blen, long nnz) {
        double memBudgetExec = SparkExecutionContext.getBroadcastMemoryBudget();
        double memBudgetLocal = OptimizerUtils.getLocalMemBudget();
        double sp = OptimizerUtils.getSparsity(rlen, clen, nnz);
        double size = OptimizerUtils.estimateSizeExactSparsity(rlen, clen, sp);
        double sizeP = OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, blen, sp);
        return OptimizerUtils.isValidCPDimensions(rlen, clen) && sizeP < memBudgetExec && size + sizeP < memBudgetLocal;
    }

    public static boolean checkSparkCollectMemoryBudget(DataCharacteristics dc, long memPinned) {
        if (dc instanceof MatrixCharacteristics) {
            return OptimizerUtils.checkSparkCollectMemoryBudget(dc.getRows(), dc.getCols(), dc.getBlocksize(), dc.getNonZerosBound(), memPinned, false);
        }
        long[] dims = dc.getDims();
        return OptimizerUtils.checkSparkCollectMemoryBudget(dims, dc.getNonZeros(), memPinned, false);
    }

    public static boolean checkSparkCollectMemoryBudget(DataCharacteristics dc, long memPinned, boolean checkBP) {
        if (dc instanceof MatrixCharacteristics) {
            return OptimizerUtils.checkSparkCollectMemoryBudget(dc.getRows(), dc.getCols(), dc.getBlocksize(), dc.getNonZerosBound(), memPinned, checkBP);
        }
        long[] dims = dc.getDims();
        return OptimizerUtils.checkSparkCollectMemoryBudget(dims, dc.getNonZeros(), memPinned, checkBP);
    }

    private static boolean checkSparkCollectMemoryBudget(long rlen, long clen, int blen, long nnz, long memPinned, boolean checkBP) {
        double memPMatrix;
        double sp = OptimizerUtils.getSparsity(rlen, clen, nnz);
        double memMatrix = OptimizerUtils.estimateSizeExactSparsity(rlen, clen, sp);
        return (double)memPinned + memMatrix + (memPMatrix = (double)OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, (long)blen, sp)) < OptimizerUtils.getLocalMemBudget() && (!checkBP || memMatrix < (double)LazyWriteBuffer.getWriteBufferLimit());
    }

    private static boolean checkSparkCollectMemoryBudget(long[] dims, long nnz, long memPinned, boolean checkBP) {
        double memPTensor;
        long doubleSize = UtilFunctions.prod(dims) * 8L;
        double memTensor = doubleSize;
        return (double)memPinned + memTensor + (memPTensor = (double)doubleSize) < OptimizerUtils.getLocalMemBudget() && (!checkBP || memTensor < (double)LazyWriteBuffer.getWriteBufferLimit());
    }

    public static boolean checkSparseBlockCSRConversion(DataCharacteristics dcIn) {
        double sp = OptimizerUtils.getSparsity(dcIn.getRows(), dcIn.getCols(), dcIn.getNonZerosBound());
        return sp < 0.4;
    }

    public static int getNumReducers(boolean configOnly) {
        if (OptimizerUtils.isSparkExecutionMode()) {
            return SparkExecutionContext.getDefaultParallelism(false);
        }
        return InfrastructureAnalyzer.getLocalParallelism();
    }

    public static int getNumMappers() {
        if (OptimizerUtils.isSparkExecutionMode()) {
            return SparkExecutionContext.getDefaultParallelism(false);
        }
        return InfrastructureAnalyzer.getLocalParallelism();
    }

    public static Types.ExecMode getDefaultExecutionMode() {
        Types.ExecMode ret = Types.ExecMode.HYBRID;
        String sparkenv = System.getenv().get("SPARK_ENV_LOADED");
        if (sparkenv != null && sparkenv.equals("1")) {
            ret = Types.ExecMode.HYBRID;
        }
        return ret;
    }

    public static boolean isSparkExecutionMode() {
        return DMLScript.getGlobalExecMode() == Types.ExecMode.SPARK || DMLScript.getGlobalExecMode() == Types.ExecMode.HYBRID;
    }

    public static boolean isHybridExecutionMode() {
        return DMLScript.getGlobalExecMode() == Types.ExecMode.HYBRID;
    }

    public static int getParallelTextReadParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static int getParallelBinaryReadParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static int getParallelTextWriteParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static int getParallelBinaryWriteParallelism() {
        if (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS)) {
            return 1;
        }
        double dop = (double)InfrastructureAnalyzer.getLocalParallelism() * 1.0;
        return (int)Math.round(dop);
    }

    public static long estimateSize(DataCharacteristics dc) {
        return OptimizerUtils.estimateSizeExactSparsity(dc);
    }

    public static long estimateSizeExactSparsity(DataCharacteristics dc) {
        return OptimizerUtils.estimateSizeExactSparsity(dc.getRows(), dc.getCols(), dc.getNonZeros());
    }

    public static long estimateSizeExactSparsity(long nrows, long ncols, long nnz) {
        double sp = OptimizerUtils.getSparsity(nrows, ncols, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(nrows, ncols, sp);
    }

    public static long estimateSizeExactSparsity(long nrows, long ncols, double sp) {
        return MatrixBlock.estimateSizeInMemory(nrows, ncols, sp);
    }

    public static long estimatePartitionedSizeExactSparsity(DataCharacteristics dc) {
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(dc, true);
    }

    public static long estimatePartitionedSizeExactSparsity(DataCharacteristics dc, boolean outputEmptyBlocks) {
        if (dc instanceof MatrixCharacteristics) {
            return OptimizerUtils.estimatePartitionedSizeExactSparsity(dc.getRows(), dc.getCols(), (long)dc.getBlocksize(), dc.getNonZerosBound(), outputEmptyBlocks);
        }
        long inaccurateSize = 8L;
        for (int i = 0; i < dc.getNumDims(); ++i) {
            inaccurateSize *= dc.getDim(i);
        }
        return inaccurateSize;
    }

    public static long estimatePartitionedSizeExactSparsity(long rlen, long clen, long blen, long nnz) {
        double sp = OptimizerUtils.getSparsity(rlen, clen, nnz);
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, blen, sp);
    }

    public static long estimatePartitionedSizeExactSparsity(long rlen, long clen, long blen, long nnz, boolean outputEmptyBlocks) {
        double sp = OptimizerUtils.getSparsity(rlen, clen, nnz);
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, blen, sp, outputEmptyBlocks);
    }

    public static long estimatePartitionedSizeExactSparsity(Hop hop) {
        long rlen = hop.getDim1();
        long clen = hop.getDim2();
        int blen = hop.getBlocksize();
        long nnz = hop.getNnz();
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, (long)blen, nnz);
    }

    public static long estimatePartitionedSizeExactSparsity(long rlen, long clen, long blen, double sp) {
        return OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, blen, sp, true);
    }

    public static long estimatePartitionedSizeExactSparsity(long rlen, long clen, long blen, double sp, boolean outputEmptyBlocks) {
        long ret = 0L;
        long tnrblks = (long)Math.ceil((double)rlen / (double)blen);
        long tncblks = (long)Math.ceil((double)clen / (double)blen);
        long nnz = (long)Math.ceil(sp * (double)rlen * (double)clen);
        if (nnz <= tnrblks * tncblks) {
            long lrlen = Math.min(rlen, blen);
            long lclen = Math.min(clen, blen);
            return nnz * MatrixBlock.estimateSizeSparseInMemory(lrlen, lclen, 1.0 / (double)lrlen / (double)lclen, SparseBlock.Type.COO) + (outputEmptyBlocks ? (tnrblks * tncblks - nnz) * OptimizerUtils.estimateSizeEmptyBlock(lrlen, lclen) : 0L);
        }
        long nrblks = rlen / blen;
        long ncblks = clen / blen;
        if (nrblks * ncblks > 0L) {
            ret += nrblks * ncblks * OptimizerUtils.estimateSizeExactSparsity(blen, blen, sp);
        }
        long lrlen = rlen % blen;
        if (ncblks > 0L && lrlen >= 0L) {
            ret += ncblks * OptimizerUtils.estimateSizeExactSparsity(lrlen, blen, sp);
        }
        long lclen = clen % blen;
        if (nrblks > 0L && lclen >= 0L) {
            ret += nrblks * OptimizerUtils.estimateSizeExactSparsity(blen, lclen, sp);
        }
        if (lrlen >= 0L && lclen >= 0L) {
            ret += OptimizerUtils.estimateSizeExactSparsity(lrlen, lclen, sp);
        }
        return ret;
    }

    public static long estimateSize(long nrows, long ncols) {
        return OptimizerUtils.estimateSizeExactSparsity(nrows, ncols, 1.0);
    }

    public static long estimateSizeEmptyBlock(long nrows, long ncols) {
        return OptimizerUtils.estimateSizeExactSparsity(0L, 0L, 0.0);
    }

    public static long estimateSizeTextOutput(long rows, long cols, long nnz, Types.FileFormat fmt) {
        long bsize = MatrixBlock.estimateSizeOnDisk(rows, cols, nnz);
        if (fmt.isIJV()) {
            return bsize * 3L;
        }
        if (fmt == Types.FileFormat.LIBSVM) {
            return Math.round((double)bsize * 2.5);
        }
        if (fmt == Types.FileFormat.CSV) {
            return bsize * 2L;
        }
        return bsize;
    }

    public static long estimateSizeTextOutput(int[] dims, long nnz, Types.FileFormat fmt) {
        if (fmt == Types.FileFormat.TEXT) {
            return nnz * (long)(8 + dims.length * 4);
        }
        throw new DMLRuntimeException("Tensor output format not implemented.");
    }

    public static double getTotalMemEstimate(Hop[] in, Hop out) {
        return OptimizerUtils.getTotalMemEstimate(in, out, false);
    }

    public static double getTotalMemEstimate(Hop[] in, Hop out, boolean denseOut) {
        return Arrays.stream(in).mapToDouble(h -> h.getOutputMemEstimate()).sum() + (!denseOut ? out.getOutputMemEstimate() : (double)OptimizerUtils.estimateSize(out.getDim1(), out.getDim2()));
    }

    public static boolean isIndexingRangeBlockAligned(IndexRange ixrange, DataCharacteristics mc) {
        long rl = ixrange.rowStart;
        long ru = ixrange.rowEnd;
        long cl = ixrange.colStart;
        long cu = ixrange.colEnd;
        long blen = mc.getBlocksize();
        return OptimizerUtils.isIndexingRangeBlockAligned(rl, ru, cl, cu, blen);
    }

    public static boolean isIndexingRangeBlockAligned(long rl, long ru, long cl, long cu, long blen) {
        return rl != -1L && ru != -1L && cl != -1L && cu != -1L && ((rl - 1L) % blen == 0L && (cl - 1L) % blen == 0L || (rl - 1L) / blen == (ru - 1L) / blen && (cl - 1L) % blen == 0L || (rl - 1L) % blen == 0L && (cl - 1L) / blen == (cu - 1L) / blen);
    }

    public static boolean isValidCPDimensions(DataCharacteristics mc) {
        return OptimizerUtils.isValidCPDimensions(mc.getRows(), mc.getCols());
    }

    public static boolean isValidCPDimensions(long rows, long cols) {
        return rows <= Integer.MAX_VALUE && cols <= Integer.MAX_VALUE;
    }

    public static boolean isValidCPDimensions(Types.ValueType[] schema, String[] names) {
        return schema != null && names != null && schema.length > 0 && schema.length == names.length;
    }

    public static boolean isValidCPMatrixSize(long rows, long cols, double sparsity) {
        boolean ret = true;
        long nnz = (long)(sparsity * (double)rows * (double)cols);
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rows, cols, nnz);
        ret = sparse ? nnz <= MAX_NNZ_CP_SPARSE : rows * cols <= Integer.MAX_VALUE;
        return ret;
    }

    public static boolean exceedsCachingThreshold(long dim2, double outMem) {
        return !(dim2 > 1L && outMem < OptimizerUtils.getLocalMemBudget() / 2.0 || dim2 == 1L && outMem < OptimizerUtils.getLocalMemBudget() / 3.0);
    }

    public static String getUniqueTempFileName() {
        return ConfigurationManager.getScratchSpace() + "/" + "_p" + DMLScript.getUUID() + "/" + "_t0" + "/" + Dag.getNextUniqueFilenameSuffix();
    }

    public static boolean allowsToFilterEmptyBlockOutputs(Hop hop) {
        boolean ret = true;
        for (Hop p : hop.getParent()) {
            p.optFindExecType();
            ret &= (p.getExecType() == Types.ExecType.CP || p instanceof AggBinaryOp && OptimizerUtils.allowsToFilterEmptyBlockOutputs(p) || HopRewriteUtils.isReorg(p, Types.ReOrgOp.RESHAPE, Types.ReOrgOp.TRANS) && OptimizerUtils.allowsToFilterEmptyBlockOutputs(p) || HopRewriteUtils.isData(p, Types.OpOpData.PERSISTENTWRITE) && ((DataOp)p).getFileFormat() == Types.FileFormat.TEXT) && !(p instanceof FunctionOp) && (!(p instanceof DataOp) || ((DataOp)p).getFileFormat() == Types.FileFormat.TEXT);
        }
        return ret;
    }

    public static int getConstrainedNumThreads(int maxNumThreads) {
        int ret = InfrastructureAnalyzer.getLocalParallelism();
        if (maxNumThreads > 0) {
            ret = Math.min(ret, maxNumThreads);
        }
        if (!ConfigurationManager.isParallelMatrixOperations()) {
            ret = 1;
        }
        return ret;
    }

    public static int getTransformNumThreads(int maxNumThreads) {
        int ret = InfrastructureAnalyzer.getLocalParallelism();
        if (maxNumThreads > 0) {
            ret = Math.min(ret, maxNumThreads);
        }
        if (!ConfigurationManager.isParallelTransform()) {
            ret = 1;
        }
        return ret;
    }

    public static Level getDefaultLogLevel() {
        Level log = Logger.getRootLogger().getLevel();
        return log != null ? log : Level.INFO;
    }

    public static long getMatMultNnz(double sp1, double sp2, long m, long k, long n, boolean worstcase) {
        return OptimizerUtils.getNnz(m, n, OptimizerUtils.getMatMultSparsity(sp1, sp2, m, k, n, worstcase));
    }

    public static double getMatMultSparsity(double sp1, double sp2, long m, long k, long n, boolean worstcase) {
        if (worstcase) {
            double nnz1 = sp1 * (double)m * (double)k;
            double nnz2 = sp2 * (double)k * (double)n;
            return Math.min(1.0, nnz1 / (double)m) * Math.min(1.0, nnz2 / (double)n);
        }
        return 1.0 - Math.pow(1.0 - sp1 * sp2, k);
    }

    public static double getLeftIndexingSparsity(long rlen1, long clen1, long nnz1, long rlen2, long clen2, long nnz2) {
        boolean scalarRhs = rlen2 == 0L && clen2 == 0L;
        long lnnz = -1L;
        if (nnz1 >= 0L && scalarRhs) {
            lnnz = nnz1 + 1L;
        } else if (nnz1 >= 0L && nnz2 >= 0L) {
            lnnz = nnz1 + nnz2;
        } else if (nnz1 >= 0L && rlen2 > 0L && clen2 > 0L) {
            lnnz = nnz1 + rlen2 * clen2;
        }
        lnnz = Math.min(lnnz, rlen1 * clen1);
        return OptimizerUtils.getSparsity(rlen1, clen1, lnnz >= 0L ? lnnz : rlen1 * clen1);
    }

    public static boolean isBinaryOpConditionalSparseSafe(Types.OpOp2 op) {
        return op == Types.OpOp2.GREATER || op == Types.OpOp2.LESS || op == Types.OpOp2.NOTEQUAL || op == Types.OpOp2.EQUAL || op == Types.OpOp2.MINUS;
    }

    public static boolean isBinaryOpConditionalSparseSafeExact(Types.OpOp2 op, LiteralOp lit) {
        double val = HopRewriteUtils.getDoubleValueSafe(lit);
        return op == Types.OpOp2.NOTEQUAL && val == 0.0;
    }

    public static boolean isBinaryOpSparsityConditionalSparseSafe(Types.OpOp2 op, LiteralOp lit) {
        double val = HopRewriteUtils.getDoubleValueSafe(lit);
        return op == Types.OpOp2.GREATER && val == 0.0 || op == Types.OpOp2.LESS && val == 0.0 || op == Types.OpOp2.NOTEQUAL && val == 0.0 || op == Types.OpOp2.EQUAL && val != 0.0 || op == Types.OpOp2.MINUS && val == 0.0 || op == Types.OpOp2.PLUS && val == 0.0 || op == Types.OpOp2.POW && val != 0.0 || op == Types.OpOp2.MAX && val <= 0.0 || op == Types.OpOp2.MIN && val >= 0.0;
    }

    public static double getBinaryOpSparsityConditionalSparseSafe(double sp1, Types.OpOp2 op, LiteralOp lit) {
        return OptimizerUtils.isBinaryOpSparsityConditionalSparseSafe(op, lit) ? sp1 : 1.0;
    }

    public static double getBinaryOpSparsity(double sp1, double sp2, Types.OpOp2 op, boolean worstcase) {
        double ret = 1.0;
        if (op == null) {
            return ret;
        }
        if (worstcase) {
            switch (op) {
                case PLUS: 
                case MINUS: 
                case LESS: 
                case GREATER: 
                case NOTEQUAL: 
                case MIN: 
                case MAX: 
                case OR: {
                    ret = worstcase ? Math.min(1.0, sp1 + sp2) : sp1 + sp2 - sp1 * sp2;
                    break;
                }
                case MULT: 
                case AND: {
                    ret = worstcase ? Math.min(sp1, sp2) : sp1 * sp2;
                    break;
                }
                case DIV: {
                    ret = Math.min(1.0, sp1 + (1.0 - sp2));
                    break;
                }
                case MODULUS: 
                case POW: 
                case MINUS_NZ: 
                case LOG_NZ: {
                    ret = sp1;
                    break;
                }
                default: {
                    ret = 1.0;
                    break;
                }
            }
        } else {
            switch (op) {
                case PLUS: 
                case MINUS: {
                    ret = 1.0 - (1.0 - sp1) * (1.0 - sp2);
                    break;
                }
                case MULT: {
                    ret = sp1 * sp2;
                    break;
                }
                case DIV: {
                    ret = 1.0;
                    break;
                }
                case LESS: 
                case GREATER: 
                case NOTEQUAL: 
                case LESSEQUAL: 
                case GREATEREQUAL: 
                case EQUAL: {
                    ret = 1.0;
                    break;
                }
                default: {
                    ret = 1.0;
                }
            }
        }
        return ret;
    }

    public static long getOuterNonZeros(long n1, long n2, long nnz1, long nnz2, Types.OpOp2 op) {
        if (nnz1 < 0L || nnz2 < 0L || op == null) {
            return n1 * n2;
        }
        switch (op) {
            case PLUS: 
            case MINUS: 
            case LESS: 
            case GREATER: 
            case NOTEQUAL: 
            case MIN: 
            case MAX: 
            case OR: {
                return n1 * n2 - (n1 - nnz1) * (n2 - nnz2);
            }
            case MULT: 
            case AND: {
                return nnz1 * nnz2;
            }
        }
        return n1 * n2;
    }

    public static long getNnz(long dim1, long dim2, double sp) {
        return Math.round(sp * (double)dim1 * (double)dim2);
    }

    public static double getSparsity(DataCharacteristics dc) {
        return OptimizerUtils.getSparsity(dc.getRows(), dc.getCols(), dc.getNonZeros());
    }

    public static double getSparsity(long dim1, long dim2, long nnz) {
        return dim1 <= 0L || dim2 <= 0L || nnz < 0L ? 1.0 : Math.min((double)nnz / (double)dim1 / (double)dim2, 1.0);
    }

    public static double getSparsity(Hop hop) {
        long dim1 = hop.getDim1();
        long dim2 = hop.getDim2();
        long nnz = hop.getNnz();
        return OptimizerUtils.getSparsity(dim1, dim2, nnz);
    }

    public static double getSparsity(long[] dims, long nnz) {
        double sparsity = nnz;
        for (long dim : dims) {
            if (dim <= 0L) {
                return 1.0;
            }
            sparsity /= (double)dim;
        }
        return Math.min(sparsity, 1.0);
    }

    public static String toMB(double inB) {
        if (inB < 0.0) {
            return "-";
        }
        return String.format("%.0f", inB / 1048576.0);
    }

    public static long getNumIterations(ForProgramBlock fpb, long defaultValue) {
        if (fpb.getStatementBlock() == null) {
            return defaultValue;
        }
        ForStatementBlock fsb = (ForStatementBlock)fpb.getStatementBlock();
        try {
            long increment;
            HashMap<Long, Long> memo = new HashMap<Long, Long>();
            long from = OptimizerUtils.rEvalSimpleLongExpression(fsb.getFromHops().getInput().get(0), memo);
            long to = OptimizerUtils.rEvalSimpleLongExpression(fsb.getToHops().getInput().get(0), memo);
            long l = fsb.getIncrementHops() == null ? (from < to ? 1L : -1L) : (increment = OptimizerUtils.rEvalSimpleLongExpression(fsb.getIncrementHops().getInput().get(0), memo));
            if (from != Long.MAX_VALUE && to != Long.MAX_VALUE && increment != Long.MAX_VALUE) {
                return (int)Math.ceil((double)(to - from + 1L) / (double)increment);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static long getNumIterations(ForProgramBlock fpb, LocalVariableMap vars, long defaultValue) {
        if (fpb.getStatementBlock() == null) {
            return defaultValue;
        }
        ForStatementBlock fsb = (ForStatementBlock)fpb.getStatementBlock();
        try {
            long increment;
            HashMap<Long, Long> memo = new HashMap<Long, Long>();
            long from = OptimizerUtils.rEvalSimpleLongExpression(fsb.getFromHops().getInput().get(0), memo, vars);
            long to = OptimizerUtils.rEvalSimpleLongExpression(fsb.getToHops().getInput().get(0), memo, vars);
            long l = fsb.getIncrementHops() == null ? (from < to ? 1L : -1L) : (increment = OptimizerUtils.rEvalSimpleLongExpression(fsb.getIncrementHops().getInput().get(0), memo));
            if (from != Long.MAX_VALUE && to != Long.MAX_VALUE && increment != Long.MAX_VALUE) {
                return (int)Math.ceil((double)(to - from + 1L) / (double)increment);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static long rEvalSimpleLongExpression(Hop root, HashMap<Long, Long> valMemo) {
        long ret = Long.MAX_VALUE;
        HashMap<Long, Double> dvalMemo = new HashMap<Long, Double>();
        double tmp = OptimizerUtils.rEvalSimpleDoubleExpression(root, dvalMemo);
        if (tmp != Double.MAX_VALUE) {
            ret = UtilFunctions.toLong(tmp);
        }
        return ret;
    }

    public static long rEvalSimpleLongExpression(Hop root, HashMap<Long, Long> valMemo, LocalVariableMap vars) {
        long ret = Long.MAX_VALUE;
        HashMap<Long, Double> dvalMemo = new HashMap<Long, Double>();
        double tmp = OptimizerUtils.rEvalSimpleDoubleExpression(root, dvalMemo, vars);
        if (tmp != Double.MAX_VALUE) {
            ret = UtilFunctions.toLong(tmp);
        }
        return ret;
    }

    public static double rEvalSimpleDoubleExpression(Hop root, HashMap<Long, Double> valMemo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        if (root instanceof LiteralOp) {
            ret = HopRewriteUtils.getDoubleValue((LiteralOp)root);
        }
        if (ALLOW_SIZE_EXPRESSION_EVALUATION) {
            if (root instanceof UnaryOp) {
                ret = OptimizerUtils.rEvalSimpleUnaryDoubleExpression(root, valMemo);
            } else if (root instanceof BinaryOp) {
                ret = OptimizerUtils.rEvalSimpleBinaryDoubleExpression(root, valMemo);
            } else if (root instanceof TernaryOp) {
                ret = OptimizerUtils.rEvalSimpleTernaryDoubleExpression(root, valMemo);
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    public static double rEvalSimpleDoubleExpression(Hop root, HashMap<Long, Double> valMemo, LocalVariableMap vars) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        if (ALLOW_SIZE_EXPRESSION_EVALUATION) {
            String name;
            Data dat;
            if (root instanceof LiteralOp) {
                ret = HopRewriteUtils.getDoubleValue((LiteralOp)root);
            } else if (root instanceof UnaryOp) {
                ret = OptimizerUtils.rEvalSimpleUnaryDoubleExpression(root, valMemo, vars);
            } else if (root instanceof BinaryOp) {
                ret = OptimizerUtils.rEvalSimpleBinaryDoubleExpression(root, valMemo, vars);
            } else if (root instanceof DataOp && (dat = vars.get(name = root.getName())) != null && dat instanceof ScalarObject) {
                ret = ((ScalarObject)dat).getDoubleValue();
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleUnaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        UnaryOp uroot = (UnaryOp)root;
        Hop input = uroot.getInput().get(0);
        if (uroot.getOp() == Types.OpOp1.NROW) {
            ret = input.rowsKnown() ? (double)input.getDim1() : Double.MAX_VALUE;
        } else if (uroot.getOp() == Types.OpOp1.NCOL) {
            ret = input.colsKnown() ? (double)input.getDim2() : Double.MAX_VALUE;
        } else {
            double lval = OptimizerUtils.rEvalSimpleDoubleExpression(uroot.getInput().get(0), valMemo);
            if (lval != Double.MAX_VALUE) {
                switch (uroot.getOp()) {
                    case SQRT: {
                        ret = Math.sqrt(lval);
                        break;
                    }
                    case ROUND: {
                        ret = Math.round(lval);
                        break;
                    }
                    case CEIL: {
                        ret = Math.ceil(lval);
                        break;
                    }
                    case FLOOR: {
                        ret = Math.floor(lval);
                        break;
                    }
                    case CAST_AS_BOOLEAN: {
                        ret = lval != 0.0 ? 1.0 : 0.0;
                        break;
                    }
                    case CAST_AS_INT: {
                        ret = UtilFunctions.toLong(lval);
                        break;
                    }
                    case CAST_AS_DOUBLE: {
                        ret = lval;
                        break;
                    }
                    default: {
                        ret = Double.MAX_VALUE;
                    }
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleUnaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo, LocalVariableMap vars) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        UnaryOp uroot = (UnaryOp)root;
        Hop input = uroot.getInput().get(0);
        if (uroot.getOp() == Types.OpOp1.NROW) {
            ret = input.rowsKnown() ? (double)input.getDim1() : Double.MAX_VALUE;
        } else if (uroot.getOp() == Types.OpOp1.NCOL) {
            ret = input.colsKnown() ? (double)input.getDim2() : Double.MAX_VALUE;
        } else {
            double lval = OptimizerUtils.rEvalSimpleDoubleExpression(uroot.getInput().get(0), valMemo, vars);
            if (lval != Double.MAX_VALUE) {
                switch (uroot.getOp()) {
                    case SQRT: {
                        ret = Math.sqrt(lval);
                        break;
                    }
                    case ROUND: {
                        ret = Math.round(lval);
                        break;
                    }
                    case CEIL: {
                        ret = Math.ceil(lval);
                        break;
                    }
                    case FLOOR: {
                        ret = Math.floor(lval);
                        break;
                    }
                    case CAST_AS_BOOLEAN: {
                        ret = lval != 0.0 ? 1.0 : 0.0;
                        break;
                    }
                    case CAST_AS_INT: {
                        ret = UtilFunctions.toLong(lval);
                        break;
                    }
                    case CAST_AS_DOUBLE: {
                        ret = lval;
                        break;
                    }
                    default: {
                        ret = Double.MAX_VALUE;
                    }
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleBinaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        BinaryOp broot = (BinaryOp)root;
        double lret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(0), valMemo);
        double rret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(1), valMemo);
        if (lret != Double.MAX_VALUE && rret != Double.MAX_VALUE) {
            switch (broot.getOp()) {
                case PLUS: {
                    ret = lret + rret;
                    break;
                }
                case MINUS: {
                    ret = lret - rret;
                    break;
                }
                case MULT: {
                    ret = lret * rret;
                    break;
                }
                case DIV: {
                    ret = lret / rret;
                    break;
                }
                case MIN: {
                    ret = Math.min(lret, rret);
                    break;
                }
                case MAX: {
                    ret = Math.max(lret, rret);
                    break;
                }
                case POW: {
                    ret = Math.pow(lret, rret);
                    break;
                }
                case MODULUS: {
                    ret = Modulus.getFnObject().execute(lret, rret);
                    break;
                }
                case INTDIV: {
                    ret = IntegerDivide.getFnObject().execute(lret, rret);
                    break;
                }
                default: {
                    ret = Double.MAX_VALUE;
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleTernaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        TernaryOp troot = (TernaryOp)root;
        if (troot.getOp() == Types.OpOp3.IFELSE) {
            if (HopRewriteUtils.isLiteralOfValue(troot.getInput(0), true)) {
                ret = OptimizerUtils.rEvalSimpleDoubleExpression(troot.getInput().get(1), valMemo);
            } else if (HopRewriteUtils.isLiteralOfValue(troot.getInput(0), false)) {
                ret = OptimizerUtils.rEvalSimpleDoubleExpression(troot.getInput().get(2), valMemo);
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected static double rEvalSimpleBinaryDoubleExpression(Hop root, HashMap<Long, Double> valMemo, LocalVariableMap vars) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        double ret = Double.MAX_VALUE;
        BinaryOp broot = (BinaryOp)root;
        double lret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(0), valMemo, vars);
        double rret = OptimizerUtils.rEvalSimpleDoubleExpression(broot.getInput().get(1), valMemo, vars);
        if (lret != Double.MAX_VALUE && rret != Double.MAX_VALUE) {
            switch (broot.getOp()) {
                case PLUS: {
                    ret = lret + rret;
                    break;
                }
                case MINUS: {
                    ret = lret - rret;
                    break;
                }
                case MULT: {
                    ret = lret * rret;
                    break;
                }
                case DIV: {
                    ret = lret / rret;
                    break;
                }
                case MIN: {
                    ret = Math.min(lret, rret);
                    break;
                }
                case MAX: {
                    ret = Math.max(lret, rret);
                    break;
                }
                case POW: {
                    ret = Math.pow(lret, rret);
                    break;
                }
                case MODULUS: {
                    ret = Modulus.getFnObject().execute(lret, rret);
                    break;
                }
                case INTDIV: {
                    ret = IntegerDivide.getFnObject().execute(lret, rret);
                    break;
                }
                default: {
                    ret = Double.MAX_VALUE;
                }
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    static {
        MAX_NNZ_CP_SPARSE = MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? Long.MAX_VALUE : Integer.MAX_VALUE;
        ALLOW_COMMON_SUBEXPRESSION_ELIMINATION = true;
        ALLOW_CONSTANT_FOLDING = true;
        ALLOW_ALGEBRAIC_SIMPLIFICATION = true;
        ALLOW_OPERATOR_FUSION = true;
        ALLOW_BRANCH_REMOVAL = true;
        ALLOW_FOR_LOOP_REMOVAL = true;
        ALLOW_AUTO_VECTORIZATION = true;
        ALLOW_SIZE_EXPRESSION_EVALUATION = true;
        ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION = true;
        ALLOW_RAND_JOB_RECOMPILE = true;
        ALLOW_RUNTIME_PIGGYBACKING = true;
        ALLOW_INTER_PROCEDURAL_ANALYSIS = true;
        IPA_NUM_REPETITIONS = 5;
        ALLOW_SUM_PRODUCT_REWRITES = true;
        ALLOW_SPLIT_HOP_DAGS = true;
        ALLOW_LOOP_UPDATE_IN_PLACE = true;
        ALLOW_EVAL_FCALL_REPLACEMENT = true;
        ALLOW_CODE_MOTION = false;
        FEDERATED_COMPILATION = false;
        ALLOW_COMPRESSION_REWRITE = true;
        ALLOW_TRANSITIVE_SPARK_EXEC_TYPE = true;
        ASYNC_TRIGGER_RDD_OPERATIONS = false;
    }

    public static enum OptimizationLevel {
        O0_LOCAL_STATIC,
        O1_LOCAL_MEMORY_MIN,
        O2_LOCAL_MEMORY_DEFAULT,
        O3_LOCAL_RESOURCE_TIME_MEMORY,
        O4_GLOBAL_TIME_MEMORY,
        O5_DEBUG_MODE;

    }
}

