/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class UnaryCP
extends Lop {
    public static final String CAST_AS_SCALAR_OPCODE = "castdts";
    public static final String CAST_AS_MATRIX_OPCODE = "castdtm";
    public static final String CAST_AS_FRAME_OPCODE = "castdtf";
    public static final String CAST_AS_DOUBLE_OPCODE = "castvtd";
    public static final String CAST_AS_INT_OPCODE = "castvti";
    public static final String CAST_AS_BOOLEAN_OPCODE = "castvtb";
    private Types.OpOp1 operation;

    public UnaryCP(Lop input, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.UnaryCP, dt, vt);
        this.operation = op;
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    public UnaryCP(Lop input, Types.OpOp1 op, Types.DataType dt, Types.ValueType vt) {
        this(input, op, dt, vt, Types.ExecType.CP);
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    private String getOpCode() {
        return this.operation.toString();
    }

    @Override
    public String getInstructions(String input, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpCode(), this.getInputs().get(0).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output));
    }
}

