# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/hospitalResidencyMatch.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def hospitalResidencyMatch(R: Matrix,
                           H: Matrix,
                           capacity: Matrix,
                           **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
    :param R: Residents matrix R.
    :param It: an ORDERED  matrix.
    :param H: Hospitals matrix H.
    :param It: an UNORDRED matrix.
    :param capacity: capacity of Hospitals matrix C.
    :param It: a [n*1] matrix with non zero values.
    :param with: and vice-versa (higher is better).
    :return: 'OperationNode' containing result matrix & result matrix & an ordered  matrix, this means that resident 1 (row 1) likes hospital 2 the most, followed by hospital 1 and hospital 3. & unordered, this would mean that resident 1 (row 1) likes hospital 3 the most (since the value at [1,3] is the row max), & 1 (2.0 preference value) and hospital 2 (1.0 preference value). & an unordered matrix this means that hospital 1 (row 1) likes resident 1 the most (since the value at [1,1] is the row max). & matched with hospital 3 (since [1,3] is non-zero) at a preference level of 2.0. & matched with hospital 1 (since [2,1] is non-zero) at a preference level of 1.0. & matched with hospital 2 (since [3,2] is non-zero) at a preference level of 2.0. 
    """
    params_dict = {'R': R, 'H': H, 'capacity': capacity}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(R.sds_context, '')
    vX_1 = Matrix(R.sds_context, '')
    output_nodes = [vX_0, vX_1, ]

    op = MultiReturn(R.sds_context, 'hospitalResidencyMatch', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]

    return op
