/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.util.NoSuchElementException;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3Qa\u0003\u0007\u0001!YA\u0001\"\b\u0001\u0003\u0006\u0004%\u0019a\b\u0005\t_\u0001\u0011\t\u0011)A\u0005A!)\u0001\u0007\u0001C\u0001c!1a\u0007\u0001Q\u0001\n]BaA\u0010\u0001!\u0002\u00139\u0004\"B \u0001\t\u0003\u0001\u0005\"\u0002#\u0001\t\u0003)\u0005\"B%\u0001\t\u0003Q\u0005B\u0002)\u0001A\u0013%\u0011\u000bC\u0003S\u0001\u0011\u00051K\u0001\u0006NK\u0012L\u0017M\u001c%fCBT!!\u0004\b\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002\u0010!\u0005!Q\u000f^5m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006\u0019qN\u001d3\u0004\u0001U\t\u0001\u0005E\u0002\"S1r!AI\u0014\u000f\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015r\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tA\u0013$A\u0004qC\u000e\\\u0017mZ3\n\u0005)Z#\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005!J\u0002C\u0001\r.\u0013\tq\u0013D\u0001\u0004E_V\u0014G.Z\u0001\u0005_J$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0002eQ\u00111'\u000e\t\u0003i\u0001i\u0011\u0001\u0004\u0005\u0006;\r\u0001\u001d\u0001I\u0001\fg6\fG\u000e\\3s\u0011\u0006dg\rE\u00029y1j\u0011!\u000f\u0006\u0003um\nq!\\;uC\ndWM\u0003\u0002\u000e3%\u0011Q(\u000f\u0002\u000e!JLwN]5usF+X-^3\u0002\u00151\f'oZ3s\u0011\u0006dg-A\u0004jg\u0016k\u0007\u000f^=\u0015\u0003\u0005\u0003\"\u0001\u0007\"\n\u0005\rK\"a\u0002\"p_2,\u0017M\\\u0001\u0005g&TX\rF\u0001G!\tAr)\u0003\u0002I3\t\u0019\u0011J\u001c;\u0002\r%t7/\u001a:u)\tYe\n\u0005\u0002\u0019\u0019&\u0011Q*\u0007\u0002\u0005+:LG\u000fC\u0003P\u0011\u0001\u0007A&A\u0001y\u0003%\u0011XMY1mC:\u001cW\rF\u0001L\u0003\u0019iW\rZ5b]V\tA\u0006")
public class MedianHeap {
    private final Ordering<Object> ord;
    private final PriorityQueue<Object> smallerHalf;
    private final PriorityQueue<Object> largerHalf;

    public Ordering<Object> ord() {
        return this.ord;
    }

    public boolean isEmpty() {
        return this.smallerHalf.isEmpty() && this.largerHalf.isEmpty();
    }

    public int size() {
        return this.smallerHalf.size() + this.largerHalf.size();
    }

    public void insert(double x) {
        if (this.isEmpty()) {
            this.largerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
        } else if (x > this.median()) {
            this.largerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
        } else {
            this.smallerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
        }
        this.rebalance();
    }

    private void rebalance() {
        block1: {
            if (this.largerHalf.size() - this.smallerHalf.size() > 1) {
                this.smallerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.largerHalf.dequeue())}));
            }
            if (this.smallerHalf.size() - this.largerHalf.size() <= 1) break block1;
            this.largerHalf.enqueue((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.smallerHalf.dequeue())}));
        }
    }

    public double median() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("MedianHeap is empty.");
        }
        return this.largerHalf.size() == this.smallerHalf.size() ? (BoxesRunTime.unboxToDouble((Object)this.largerHalf.head()) + BoxesRunTime.unboxToDouble((Object)this.smallerHalf.head())) / 2.0 : (this.largerHalf.size() > this.smallerHalf.size() ? BoxesRunTime.unboxToDouble((Object)this.largerHalf.head()) : BoxesRunTime.unboxToDouble((Object)this.smallerHalf.head()));
    }

    public MedianHeap(Ordering<Object> ord) {
        this.ord = ord;
        this.smallerHalf = (PriorityQueue)PriorityQueue$.MODULE$.empty(ord);
        this.largerHalf = (PriorityQueue)PriorityQueue$.MODULE$.empty(ord.reverse());
    }
}

