/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram;

import java.util.ArrayList;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.utils.stats.RecompileStatistics;

public class BasicProgramBlock
extends ProgramBlock {
    protected ArrayList<Instruction> _inst = new ArrayList();

    public BasicProgramBlock(Program prog) {
        super(prog);
    }

    public ArrayList<Instruction> getInstructions() {
        return this._inst;
    }

    public Instruction getInstruction(int i) {
        return this._inst.get(i);
    }

    public void setInstructions(ArrayList<Instruction> inst) {
        this._inst = inst;
    }

    public void addInstruction(Instruction inst) {
        this._inst.add(inst);
    }

    public void addInstructions(ArrayList<Instruction> inst) {
        this._inst.addAll(inst);
    }

    public int getNumInstructions() {
        return this._inst.size();
    }

    @Override
    public ArrayList<ProgramBlock> getChildBlocks() {
        return null;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public void execute(ExecutionContext ec) {
        ArrayList<Instruction> tmp = this._inst;
        try {
            long t0;
            long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            if (ConfigurationManager.isDynamicRecompilation() && this._sb != null && this._sb.requiresRecompilation()) {
                tmp = Recompiler.recompileHopsDag(this._sb, this._sb.getHops(), ec, null, false, true, this._tid);
            }
            if (DMLScript.STATISTICS) {
                long t1 = System.nanoTime();
                RecompileStatistics.incrementRecompileTime(t1 - t0);
                if (tmp != this._inst) {
                    RecompileStatistics.incrementRecompileSB();
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to recompile program block.", ex);
        }
        LineageItem[] liInputs = null;
        long t0 = 0L;
        if (this._sb != null && LineageCacheConfig.isMultiLevelReuse() && !this._sb.isNondeterministic()) {
            liInputs = LineageItemUtils.getLineageItemInputstoSB(this._sb.getInputstoSB(), ec);
            ArrayList<String> outNames = this._sb.getOutputNamesofSB();
            if (liInputs != null && LineageCache.reuse(outNames, this._sb.getOutputsofSB(), outNames.size(), liInputs, this._sb.getName(), ec)) {
                if (DMLScript.STATISTICS) {
                    LineageCacheStatistics.incrementSBHits();
                }
                return;
            }
            t0 = System.nanoTime();
        }
        this.executeInstructions(tmp, ec);
        if (this._sb != null && liInputs != null && !this._sb.isNondeterministic()) {
            LineageCache.putValue(this._sb.getOutputsofSB(), liInputs, this._sb.getName(), ec, System.nanoTime() - t0);
        }
    }
}

