/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.Adler32;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheDataOutput;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.functionobjects.ParameterizedBuiltin;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.ComputationFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.MultiReturnParameterizedBuiltinFEDInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.SimpleOperator;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.transform.decode.DecoderFactory;
import org.apache.sysds.runtime.transform.encode.EncoderFactory;
import org.apache.sysds.runtime.transform.encode.EncoderOmit;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ParameterizedBuiltinFEDInstruction
extends ComputationFEDInstruction {
    protected final LinkedHashMap<String, String> params;

    protected ParameterizedBuiltinFEDInstruction(Operator op, LinkedHashMap<String, String> paramsMap, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.ParameterizedBuiltin, op, null, null, out, opcode, istr);
        this.params = paramsMap;
    }

    public HashMap<String, String> getParameterMap() {
        return this.params;
    }

    public String getParam(String key) {
        return this.getParameterMap().get(key);
    }

    public static LinkedHashMap<String, String> constructParameterMap(String[] params) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        for (int i = 1; i <= params.length - 2; ++i) {
            String[] parts = params[i].split("=");
            paramMap.put(parts[0], parts[1]);
        }
        return paramMap;
    }

    public static ParameterizedBuiltinFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand out = new CPOperand(parts[parts.length - 1]);
        LinkedHashMap<String, String> paramsMap = ParameterizedBuiltinFEDInstruction.constructParameterMap(parts);
        if (opcode.equalsIgnoreCase("replace") || opcode.equalsIgnoreCase("rmempty") || opcode.equalsIgnoreCase("lowertri") || opcode.equalsIgnoreCase("uppertri")) {
            ParameterizedBuiltin func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode);
            return new ParameterizedBuiltinFEDInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equals("transformapply") || opcode.equals("transformdecode") || opcode.equals("tokenize")) {
            return new ParameterizedBuiltinFEDInstruction(null, paramsMap, out, opcode, str);
        }
        throw new DMLRuntimeException("Unsupported opcode (" + opcode + ") for ParameterizedBuiltinFEDInstruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        if (opcode.equalsIgnoreCase("replace")) {
            CacheableData<?> mo = this.getTarget(ec);
            FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand()}, new long[]{mo.getFedMapping().getID()});
            mo.getFedMapping().execute(this.getTID(), true, fr1);
            CacheableData<?> out = ec.getCacheableData(this.output);
            if (mo instanceof FrameObject) {
                ((FrameObject)out).setSchema(((FrameObject)mo).getSchema());
            }
            out.getDataCharacteristics().set(mo.getDataCharacteristics());
            out.setFedMapping(mo.getFedMapping().copyWithNewID(fr1.getID()));
        } else if (opcode.equals("rmempty")) {
            if (this.getTarget(ec) instanceof FrameObject) {
                this.rmemptyFrame(ec);
            } else {
                this.rmemptyMatrix(ec);
            }
        } else if (opcode.equals("lowertri") || opcode.equals("uppertri")) {
            this.triangle(ec, opcode);
        } else if (opcode.equalsIgnoreCase("transformdecode")) {
            this.transformDecode(ec);
        } else if (opcode.equalsIgnoreCase("transformapply")) {
            this.transformApply(ec);
        } else if (opcode.equals("tokenize")) {
            this.tokenize(ec);
        } else {
            throw new DMLRuntimeException("Unknown opcode : " + opcode);
        }
    }

    private void tokenize(ExecutionContext ec) {
        FrameObject in = ec.getFrameObject(this.getTargetOperand());
        FederationMap fedMap = in.getFedMapping();
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand()}, new long[]{fedMap.getID()});
        fedMap.execute(this.getTID(), true, fr1);
        FrameObject out = ec.getFrameObject(this.output);
        out.setFedMapping(fedMap.copyWithNewID(fr1.getID()));
        long ncolId = FederationUtils.getNextFedDataID();
        CPOperand ncolOp = new CPOperand(String.valueOf(ncolId), Types.ValueType.INT64, Types.DataType.SCALAR);
        String unaryString = InstructionUtils.constructUnaryInstString(this.instString, "ncol", this.output, ncolOp);
        FederatedRequest fr2 = FederationUtils.callInstruction(unaryString, ncolOp, new CPOperand[]{this.output}, new long[]{out.getFedMapping().getID()});
        FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr2.getID());
        Future<FederatedResponse>[] ffr = out.getFedMapping().execute(this.getTID(), true, fr2, fr3);
        long cols = 0L;
        for (int i = 0; i < ffr.length; ++i) {
            try {
                if (in.isFederated(FTypes.FType.COL)) {
                    out.getFedMapping().getFederatedRanges()[i + 1].setBeginDim(1, cols);
                    cols += ((ScalarObject)ffr[i].get().getData()[0]).getLongValue();
                } else if (in.isFederated(FTypes.FType.ROW)) {
                    cols = ((ScalarObject)ffr[i].get().getData()[0]).getLongValue();
                }
                out.getFedMapping().getFederatedRanges()[i].setEndDim(1, cols);
                continue;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        }
        Types.ValueType[] schema = new Types.ValueType[(int)cols];
        Arrays.fill((Object[])schema, (Object)Types.ValueType.STRING);
        out.setSchema(schema);
        out.getDataCharacteristics().setDimension(in.getNumRows(), cols);
    }

    private void triangle(ExecutionContext ec, String opcode) {
        boolean lower = opcode.equals("lowertri");
        boolean diag = Boolean.parseBoolean(this.params.get("diag"));
        boolean values = Boolean.parseBoolean(this.params.get("values"));
        MatrixObject mo = (MatrixObject)this.getTarget(ec);
        FederationMap fedMap = mo.getFedMapping();
        boolean rowFed = mo.isFederated(FTypes.FType.ROW);
        long varID = FederationUtils.getNextFedDataID();
        FederationMap diagFedMap = fedMap.mapParallel(varID, (range, data) -> {
            try {
                int[] nArray;
                FederatedRequest[] federatedRequestArray = new FederatedRequest[1];
                Object[] objectArray = new Object[1];
                long l = data.getVarID();
                if (rowFed) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = range.getBeginDimsInt()[0];
                    nArray = nArray2;
                    nArray2[1] = range.getEndDimsInt()[0];
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = range.getBeginDimsInt()[1];
                    nArray = nArray3;
                    nArray3[1] = range.getEndDimsInt()[1];
                }
                objectArray[0] = new Tri(l, varID, nArray, rowFed, lower, diag, values);
                federatedRequestArray[0] = new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, objectArray);
                FederatedResponse response = data.executeFederatedOperation(federatedRequestArray).get();
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                return null;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        });
        MatrixObject out = ec.getMatrixObject(this.output);
        out.setFedMapping(diagFedMap);
    }

    private void rmemptyFrame(ExecutionContext ec) {
        HashMap dcs;
        FederatedRequest fr2;
        Object fr1;
        String margin = this.params.get("margin");
        if (!margin.equals("rows") && !margin.equals("cols")) {
            throw new DMLRuntimeException("Unsupported margin identifier '" + margin + "'.");
        }
        FrameObject mo = (FrameObject)this.getTarget(ec);
        MatrixLineagePair select = this.params.containsKey("select") ? ec.getMatrixLineagePair(this.params.get("select")) : null;
        FrameObject out = ec.getFrameObject(this.output);
        boolean marginRow = this.params.get("margin").equals("rows");
        boolean isNotAligned = marginRow && mo.getFedMapping().getType().isColPartitioned() || !marginRow && mo.getFedMapping().getType().isRowPartitioned();
        MatrixBlock s = new MatrixBlock();
        if (select == null && isNotAligned) {
            ArrayList colSums = new ArrayList();
            mo.getFedMapping().forEachParallel((range, data) -> {
                try {
                    FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetFrameVector(data.getVarID(), margin.equals("rows")))).get();
                    if (!response.isSuccessful()) {
                        response.throwExceptionFromResponse();
                    }
                    MatrixBlock vector = (MatrixBlock)response.getData()[0];
                    List list = colSums;
                    synchronized (list) {
                        colSums.add(vector);
                    }
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
                return null;
            });
            BinaryOperator plus = InstructionUtils.parseBinaryOperator("+");
            BinaryOperator greater = InstructionUtils.parseBinaryOperator(">");
            s = (MatrixBlock)colSums.get(0);
            for (int i = 1; i < colSums.size(); ++i) {
                s = s.binaryOperationsInPlace(plus, (MatrixValue)colSums.get(i));
            }
            s = s.binaryOperationsInPlace(greater, new MatrixBlock(s.getNumRows(), s.getNumColumns(), 0.0));
            select = MatrixLineagePair.of(ExecutionContext.createMatrixObject(s), null);
            long varID = FederationUtils.getNextFedDataID();
            ec.setVariable(String.valueOf(varID), select.getMO());
            this.params.put("select", String.valueOf(varID));
            String[] oldString = InstructionUtils.getInstructionParts(this.instString);
            String[] newString = new String[oldString.length + 1];
            newString[2] = "select=" + varID;
            System.arraycopy(oldString, 0, newString, 0, 2);
            System.arraycopy(oldString, 2, newString, 3, newString.length - 3);
            this.instString = this.instString.replace(InstructionUtils.concatOperands(oldString), InstructionUtils.concatOperands(newString));
        }
        if (select == null) {
            fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand()}, new long[]{mo.getFedMapping().getID()});
            mo.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1});
            out.setFedMapping(mo.getFedMapping().copyWithNewID(((FederatedRequest)fr1).getID()));
        } else if (!isNotAligned) {
            fr1 = mo.getFedMapping().broadcastSliced(select, !marginRow);
            fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand(), new CPOperand(this.params.get("select"), Types.ValueType.FP64, Types.DataType.MATRIX)}, new long[]{mo.getFedMapping().getID(), ((FederatedRequest)fr1[0]).getID()});
            mo.getFedMapping().execute(this.getTID(), true, (FederatedRequest[])fr1, new FederatedRequest[]{fr2});
            out.setFedMapping(mo.getFedMapping().copyWithNewID(fr2.getID()));
        } else {
            fr1 = mo.getFedMapping().broadcast(select);
            fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand(), new CPOperand(this.params.get("select"), Types.ValueType.FP64, Types.DataType.MATRIX)}, new long[]{mo.getFedMapping().getID(), ((FederatedRequest)fr1).getID()});
            mo.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1, fr2});
            out.setFedMapping(mo.getFedMapping().copyWithNewID(fr2.getID()));
        }
        HashMap finalDcs1 = dcs = new HashMap();
        HashMap finalSchema = new HashMap();
        out.getFedMapping().forEachParallel((range, data) -> {
            try {
                FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetFrameCharacteristics(data.getVarID()))).get();
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                Object[] ret = response.getData();
                int[] subRangeCharacteristics = new int[]{(Integer)ret[0], (Integer)ret[1]};
                Types.ValueType[] schema = (Types.ValueType[])ret[2];
                Map map = finalDcs1;
                synchronized (map) {
                    finalDcs1.put(range, subRangeCharacteristics);
                }
                map = finalSchema;
                synchronized (map) {
                    finalSchema.put(range, schema);
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        dcs = finalDcs1;
        out.getDataCharacteristics().set(mo.getDataCharacteristics());
        int len = marginRow ? mo.getSchema().length : (int)(mo.isFederated(FTypes.FType.ROW) ? s.getNonZeros() : (long)finalSchema.values().stream().mapToInt(e -> ((Types.ValueType[])e).length).sum());
        Types.ValueType[] schema = new Types.ValueType[len];
        int pos = 0;
        for (int i = 0; i < mo.getFedMapping().getFederatedRanges().length; ++i) {
            FederatedRange federatedRange = new FederatedRange(out.getFedMapping().getFederatedRanges()[i]);
            if (marginRow) {
                schema = mo.getSchema();
            } else if (mo.isFederated(FTypes.FType.ROW)) {
                schema = (Types.ValueType[])finalSchema.get(federatedRange);
            } else {
                Types.ValueType[] tmp = (Types.ValueType[])finalSchema.get(federatedRange);
                System.arraycopy(tmp, 0, schema, pos, tmp.length);
                pos += tmp.length;
            }
            int[] newRange = (int[])dcs.get(federatedRange);
            out.getFedMapping().getFederatedRanges()[i].setBeginDim(0, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[0] == 0L || i == 0 ? 0L : out.getFedMapping().getFederatedRanges()[i - 1].getEndDims()[0]);
            out.getFedMapping().getFederatedRanges()[i].setEndDim(0, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[0] + (long)newRange[0]);
            out.getFedMapping().getFederatedRanges()[i].setBeginDim(1, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[1] == 0L || i == 0 ? 0L : out.getFedMapping().getFederatedRanges()[i - 1].getEndDims()[1]);
            out.getFedMapping().getFederatedRanges()[i].setEndDim(1, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[1] + (long)newRange[1]);
        }
        out.setSchema(schema);
        out.getDataCharacteristics().set(out.getFedMapping().getMaxIndexInRange(0), out.getFedMapping().getMaxIndexInRange(1), (int)mo.getBlocksize());
    }

    private void rmemptyMatrix(ExecutionContext ec) {
        HashMap dcs;
        FederatedRequest fr2;
        Object fr1;
        String margin = this.params.get("margin");
        if (!margin.equals("rows") && !margin.equals("cols")) {
            throw new DMLRuntimeException("Unsupported margin identifier '" + margin + "'.");
        }
        MatrixObject mo = (MatrixObject)this.getTarget(ec);
        MatrixLineagePair select = this.params.containsKey("select") ? ec.getMatrixLineagePair(this.params.get("select")) : null;
        MatrixObject out = ec.getMatrixObject(this.output);
        boolean marginRow = this.params.get("margin").equals("rows");
        boolean isNotAligned = marginRow && mo.getFedMapping().getType().isColPartitioned() || !marginRow && mo.getFedMapping().getType().isRowPartitioned();
        MatrixBlock s = new MatrixBlock();
        if (select == null && isNotAligned) {
            ArrayList colSums = new ArrayList();
            mo.getFedMapping().forEachParallel((range, data) -> {
                try {
                    FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetVector(data.getVarID(), margin.equals("rows")))).get();
                    if (!response.isSuccessful()) {
                        response.throwExceptionFromResponse();
                    }
                    MatrixBlock vector = (MatrixBlock)response.getData()[0];
                    List list = colSums;
                    synchronized (list) {
                        colSums.add(vector);
                    }
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
                return null;
            });
            BinaryOperator plus = InstructionUtils.parseBinaryOperator("+");
            BinaryOperator greater = InstructionUtils.parseBinaryOperator(">");
            s = (MatrixBlock)colSums.get(0);
            for (int i = 1; i < colSums.size(); ++i) {
                s = s.binaryOperationsInPlace(plus, (MatrixValue)colSums.get(i));
            }
            s = s.binaryOperationsInPlace(greater, new MatrixBlock(s.getNumRows(), s.getNumColumns(), 0.0));
            select = MatrixLineagePair.of(ExecutionContext.createMatrixObject(s), null);
            long varID = FederationUtils.getNextFedDataID();
            ec.setVariable(String.valueOf(varID), select.getMO());
            this.params.put("select", String.valueOf(varID));
            String[] oldString = InstructionUtils.getInstructionParts(this.instString);
            String[] newString = new String[oldString.length + 1];
            newString[2] = "select=" + varID;
            System.arraycopy(oldString, 0, newString, 0, 2);
            System.arraycopy(oldString, 2, newString, 3, newString.length - 3);
            this.instString = this.instString.replace(InstructionUtils.concatOperands(oldString), InstructionUtils.concatOperands(newString));
        }
        if (select == null) {
            fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand()}, new long[]{mo.getFedMapping().getID()});
            mo.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1});
            out.setFedMapping(mo.getFedMapping().copyWithNewID(((FederatedRequest)fr1).getID()));
        } else if (!isNotAligned) {
            fr1 = mo.getFedMapping().broadcastSliced(select, !marginRow);
            fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand(), new CPOperand(this.params.get("select"), Types.ValueType.FP64, Types.DataType.MATRIX)}, new long[]{mo.getFedMapping().getID(), ((FederatedRequest)fr1[0]).getID()});
            mo.getFedMapping().execute(this.getTID(), true, (FederatedRequest[])fr1, new FederatedRequest[]{fr2});
            out.setFedMapping(mo.getFedMapping().copyWithNewID(fr2.getID()));
        } else {
            fr1 = mo.getFedMapping().broadcast(select);
            fr2 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.getTargetOperand(), new CPOperand(this.params.get("select"), Types.ValueType.FP64, Types.DataType.MATRIX)}, new long[]{mo.getFedMapping().getID(), ((FederatedRequest)fr1).getID()});
            mo.getFedMapping().execute(this.getTID(), true, new FederatedRequest[]{fr1, fr2});
            out.setFedMapping(mo.getFedMapping().copyWithNewID(fr2.getID()));
        }
        HashMap finalDcs1 = dcs = new HashMap();
        out.getFedMapping().forEachParallel((range, data) -> {
            try {
                FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetMatrixCharacteristics(data.getVarID()))).get();
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                int[] subRangeCharacteristics = (int[])response.getData()[0];
                Map map = finalDcs1;
                synchronized (map) {
                    finalDcs1.put(range, subRangeCharacteristics);
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        dcs = finalDcs1;
        out.getDataCharacteristics().set(mo.getDataCharacteristics());
        for (int i = 0; i < mo.getFedMapping().getFederatedRanges().length; ++i) {
            int[] newRange = (int[])dcs.get(out.getFedMapping().getFederatedRanges()[i]);
            out.getFedMapping().getFederatedRanges()[i].setBeginDim(0, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[0] == 0L || i == 0 ? 0L : out.getFedMapping().getFederatedRanges()[i - 1].getEndDims()[0]);
            out.getFedMapping().getFederatedRanges()[i].setEndDim(0, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[0] + (long)newRange[0]);
            out.getFedMapping().getFederatedRanges()[i].setBeginDim(1, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[1] == 0L || i == 0 ? 0L : out.getFedMapping().getFederatedRanges()[i - 1].getEndDims()[1]);
            out.getFedMapping().getFederatedRanges()[i].setEndDim(1, out.getFedMapping().getFederatedRanges()[i].getBeginDims()[1] + (long)newRange[1]);
        }
        out.getDataCharacteristics().set(out.getFedMapping().getMaxIndexInRange(0), out.getFedMapping().getMaxIndexInRange(1), (int)mo.getBlocksize());
    }

    private void transformDecode(ExecutionContext ec) {
        MatrixObject mo = ec.getMatrixObject(this.params.get("target"));
        FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
        String spec = this.params.get("spec");
        Decoder globalDecoder = DecoderFactory.createDecoder(spec, meta.getColumnNames(), null, meta, (int)mo.getNumColumns());
        FederationMap fedMapping = mo.getFedMapping();
        Types.ValueType[] schema = new Types.ValueType[(int)mo.getNumColumns()];
        long varID = FederationUtils.getNextFedDataID();
        FederationMap decodedMapping = fedMapping.mapParallel(varID, (range, data) -> {
            long[] beginDims = range.getBeginDims();
            long[] endDims = range.getEndDims();
            int colStartBefore = (int)beginDims[1];
            globalDecoder.updateIndexRanges(beginDims, endDims);
            Decoder decoder = globalDecoder.subRangeDecoder((int)beginDims[1] + 1, (int)endDims[1] + 1, colStartBefore);
            FrameBlock metaSlice = new FrameBlock();
            FrameBlock frameBlock = meta;
            synchronized (frameBlock) {
                meta.slice(0, meta.getNumRows() - 1, (int)beginDims[1], (int)endDims[1] - 1, metaSlice);
            }
            try {
                FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new DecodeMatrix(data.getVarID(), varID, metaSlice, decoder))).get();
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                Types.ValueType[] subSchema = (Types.ValueType[])response.getData()[0];
                Types.ValueType[] valueTypeArray = schema;
                synchronized (schema) {
                    System.arraycopy(subSchema, 0, schema, colStartBefore, subSchema.length);
                    // ** MonitorExit[var14_15] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            {
                return null;
            }
        });
        FrameObject decodedFrame = ec.getFrameObject(this.output);
        decodedFrame.setSchema(globalDecoder.getSchema());
        decodedFrame.getDataCharacteristics().set(mo.getDataCharacteristics());
        decodedFrame.getDataCharacteristics().setCols(globalDecoder.getSchema().length);
        decodedFrame.setFedMapping(decodedMapping);
        ec.releaseFrameInput(this.params.get("meta"));
    }

    private void transformApply(ExecutionContext ec) {
        FrameObject fo = ec.getFrameObject(this.params.get("target"));
        FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
        String spec = this.params.get("spec");
        FederationMap fedMapping = fo.getFedMapping();
        Object[] colNames = new String[(int)fo.getNumColumns()];
        Arrays.fill(colNames, "");
        fedMapping.forEachParallel((arg_0, arg_1) -> ParameterizedBuiltinFEDInstruction.lambda$transformApply$7((String[])colNames, arg_0, arg_1));
        MultiColumnEncoder globalEncoder = EncoderFactory.createEncoder(spec, (String[])colNames, colNames.length, meta);
        if (globalEncoder.hasLegacyEncoder(EncoderOmit.class)) {
            globalEncoder.addReplaceLegacyEncoder(ParameterizedBuiltinFEDInstruction.buildOmitEncoder(fedMapping, globalEncoder.getLegacyEncoder(EncoderOmit.class)));
        }
        MultiReturnParameterizedBuiltinFEDInstruction.encodeFederatedFrames(fedMapping, globalEncoder, ec.getMatrixObject(this.getOutputVariableName()));
        ec.releaseFrameInput(this.params.get("meta"));
    }

    private static EncoderOmit buildOmitEncoder(FederationMap fedMapping, EncoderOmit omitEncoder) {
        EncoderOmit newOmit = new EncoderOmit(true);
        fedMapping.forEachParallel((range, data) -> {
            try {
                int colOffset = (int)range.getBeginDims()[1];
                EncoderOmit subRangeEncoder = omitEncoder.subRangeEncoder(range.asIndexRange().add(1));
                FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new InitRowsToRemoveOmit(data.getVarID(), subRangeEncoder, colOffset))).get();
                EncoderOmit builtEncoder = (EncoderOmit)response.getData()[0];
                newOmit.mergeAt(builtEncoder, (int)(range.getBeginDims()[0] + 1L), (int)(range.getBeginDims()[1] + 1L));
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        return newOmit;
    }

    public CacheableData<?> getTarget(ExecutionContext ec) {
        return ec.getCacheableData(this.params.get("target"));
    }

    private CPOperand getTargetOperand() {
        return new CPOperand(this.params.get("target"), Types.ValueType.FP64, Types.DataType.MATRIX);
    }

    private static /* synthetic */ Void lambda$transformApply$7(String[] colNames, FederatedRange range, FederatedData data) {
        try {
            FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetColumnNames(data.getVarID()))).get();
            String[] subRangeColNames = (String[])response.getData()[0];
            System.arraycopy(subRangeColNames, 0, colNames, (int)range.getBeginDims()[1], subRangeColNames.length);
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        return null;
    }

    private static class GetFrameVector
    extends FederatedUDF {
        private static final long serialVersionUID = -1003061862215703768L;
        private final boolean _marginRow;

        public GetFrameVector(long varID, boolean marginRow) {
            super(new long[]{varID});
            this._marginRow = marginRow;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock ret;
            FrameBlock fb = (FrameBlock)((FrameObject)data[0]).acquireReadAndRelease();
            MatrixBlock matrixBlock = ret = this._marginRow ? new MatrixBlock(fb.getNumRows(), 1, 0.0) : new MatrixBlock(1, fb.getNumColumns(), 0.0);
            if (this._marginRow) {
                for (int i = 0; i < fb.getNumRows(); ++i) {
                    boolean isEmpty = true;
                    for (int j2 = 0; j2 < fb.getNumColumns(); ++j2) {
                        Types.ValueType type = fb.getSchema()[j2];
                        isEmpty = isEmpty && ArrayUtils.contains((double[])new double[]{0.0, Double.NaN}, (double)UtilFunctions.objectToDoubleSafe(type, fb.get(i, j2)));
                    }
                    if (isEmpty) continue;
                    ret.setValue(i, 0, 1.0);
                }
            } else {
                for (int i = 0; i < fb.getNumColumns(); ++i) {
                    int finalI = i;
                    Types.ValueType type = fb.getSchema()[i];
                    boolean isEmpty = IntStream.range(0, fb.getNumRows()).mapToObj(j -> fb.get(j, finalI)).allMatch(e -> ArrayUtils.contains((double[])new double[]{0.0, Double.NaN}, (double)UtilFunctions.objectToDoubleSafe(type, e)));
                    if (isEmpty) continue;
                    ret.setValue(0, i, 1.0);
                }
            }
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, ret);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class GetVector
    extends FederatedUDF {
        private static final long serialVersionUID = -1003061862215703768L;
        private final boolean _marginRow;

        public GetVector(long varID, boolean marginRow) {
            super(new long[]{varID});
            this._marginRow = marginRow;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            BinaryOperator plus = InstructionUtils.parseBinaryOperator("+");
            BinaryOperator greater = InstructionUtils.parseBinaryOperator(">");
            int len = this._marginRow ? mb.getNumColumns() : mb.getNumRows();
            MatrixBlock tmp1 = this._marginRow ? mb.slice(0, mb.getNumRows() - 1, 0, 0, new MatrixBlock()) : mb.slice(0, 0, 0, mb.getNumColumns() - 1, new MatrixBlock());
            for (int i = 1; i < len; ++i) {
                MatrixBlock tmp2 = this._marginRow ? mb.slice(0, mb.getNumRows() - 1, i, i, new MatrixBlock()) : mb.slice(i, i, 0, mb.getNumColumns() - 1, new MatrixBlock());
                tmp1 = tmp1.binaryOperationsInPlace(plus, tmp2);
            }
            tmp1 = tmp1.binaryOperationsInPlace(greater, new MatrixBlock(tmp1.getNumRows(), tmp1.getNumColumns(), 0.0));
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, tmp1);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class GetFrameCharacteristics
    extends FederatedUDF {
        private static final long serialVersionUID = 578461386177730925L;

        public GetFrameCharacteristics(long varID) {
            super(new long[]{varID});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            FrameBlock fb = (FrameBlock)((FrameObject)data[0]).acquireReadAndRelease();
            int r = fb.getNumRows() != 0 || fb.getNumRows() != -1 ? fb.getNumRows() : 0;
            int c = fb.getNumColumns() != 0 || fb.getNumColumns() != -1 ? fb.getNumColumns() : 0;
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{r, c, fb.getSchema()});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class GetMatrixCharacteristics
    extends FederatedUDF {
        private static final long serialVersionUID = 578461386177730925L;

        public GetMatrixCharacteristics(long varID) {
            super(new long[]{varID});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            int[] nArray;
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            if (mb.isEmpty()) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 0;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = mb.getNumRows();
                nArray = nArray3;
                nArray3[1] = mb.getNumColumns();
            }
            int[] dims = nArray;
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, (Object)dims);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class InitRowsToRemoveOmit
    extends FederatedUDF {
        private static final long serialVersionUID = -8196730717390438411L;
        EncoderOmit _encoder;
        int _offset;

        public InitRowsToRemoveOmit(long varID, EncoderOmit encoder, int offset) {
            super(new long[]{varID});
            this._encoder = encoder;
            this._offset = offset;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            FrameBlock fb = (FrameBlock)((FrameObject)data[0]).acquireReadAndRelease();
            this._encoder.shiftCols(-this._offset);
            this._encoder.build(fb);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{this._encoder});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class GetColumnNames
    extends FederatedUDF {
        private static final long serialVersionUID = -7831469841164270004L;

        public GetColumnNames(long varID) {
            super(new long[]{varID});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            FrameBlock fb = (FrameBlock)((FrameObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{fb.getColumnNames()});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    public static class DecodeMatrix
    extends FederatedUDF {
        private static final long serialVersionUID = 2376756757742169692L;
        private final long _outputID;
        private final FrameBlock _meta;
        private final Decoder _decoder;

        public DecodeMatrix(long input, long outputID, FrameBlock meta, Decoder decoder) {
            super(new long[]{input});
            this._outputID = outputID;
            this._meta = meta;
            this._decoder = decoder;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixObject mo = (MatrixObject)data[0];
            MatrixBlock mb = (MatrixBlock)mo.acquireRead();
            String[] colNames = this._meta.getColumnNames();
            FrameBlock fbout = this._decoder.decode(mb, new FrameBlock(this._decoder.getSchema()));
            fbout.setColumnNames(Arrays.copyOfRange(colNames, 0, fbout.getNumColumns()));
            MatrixCharacteristics mc = new MatrixCharacteristics(mo.getDataCharacteristics());
            FrameObject fo = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(mc, Types.FileFormat.BINARY));
            fo.acquireModify(fbout);
            fo.release();
            mo.release();
            ec.setVariable(String.valueOf(this._outputID), fo);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{fo.getSchema()});
        }

        @Override
        public List<Long> getOutputIds() {
            return new ArrayList<Long>(Arrays.asList(this._outputID));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            LineageItem[] liUdfInputs = (LineageItem[])Arrays.stream(this.getInputIDs()).mapToObj(id -> ec.getLineage().get(String.valueOf(id))).toArray(LineageItem[]::new);
            Adler32 checksum = new Adler32();
            try {
                long cbsize = LazyWriteBuffer.getCacheBlockSize(this._meta);
                CacheDataOutput fout = new CacheDataOutput(new byte[(int)cbsize]);
                this._meta.write(fout);
                byte[] bytes = fout.getBytes();
                checksum.update(bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new DMLRuntimeException("Failed to serialize cache block.");
            }
            CPOperand meta = new CPOperand(String.valueOf(checksum.getValue()), Types.ValueType.INT64, Types.DataType.SCALAR, true);
            checksum.reset();
            byte[] bytes = SerializationUtils.serialize((Serializable)this._decoder);
            checksum.update(bytes, 0, bytes.length);
            CPOperand decoder = new CPOperand(String.valueOf(checksum.getValue()), Types.ValueType.INT64, Types.DataType.SCALAR, true);
            LineageItem[] otherInputs = LineageItemUtils.getLineage(ec, meta, decoder);
            LineageItem[] liInputs = (LineageItem[])Stream.concat(Arrays.stream(liUdfInputs), Arrays.stream(otherInputs)).toArray(LineageItem[]::new);
            return Pair.of((Object)String.valueOf(this._outputID), (Object)new LineageItem(this.getClass().getSimpleName(), liInputs));
        }
    }

    private static class Tri
    extends FederatedUDF {
        private static final long serialVersionUID = 6254009025304038215L;
        private final long _outputID;
        private final int[] _slice;
        private final boolean _rowFed;
        private final boolean _lower;
        private final boolean _diag;
        private final boolean _values;

        private Tri(long input, long outputID, int[] slice, boolean rowFed, boolean lower, boolean diag, boolean values) {
            super(new long[]{input});
            this._outputID = outputID;
            this._slice = slice;
            this._rowFed = rowFed;
            this._lower = lower;
            this._diag = diag;
            this._values = values;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock ret;
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            MatrixBlock soresBlock = this._rowFed ? mb.slice(0, mb.getNumRows() - 1, this._slice[0], this._slice[1] - 1, new MatrixBlock()) : mb.slice(this._slice[0], this._slice[1] - 1);
            MatrixBlock tri = soresBlock.extractTriangular(new MatrixBlock(), this._lower, this._diag, this._values);
            if (this._rowFed) {
                ret = new MatrixBlock(mb.getNumRows(), mb.getNumColumns(), 0.0);
                ret.copy(0, ret.getNumRows() - 1, this._slice[0], this._slice[1] - 1, tri, false);
                if (this._slice[1] <= mb.getNumColumns() - 1 && !this._lower) {
                    MatrixBlock addBlock = mb.slice(0, mb.getNumRows() - 1, this._slice[1], mb.getNumColumns() - 1, new MatrixBlock());
                    ret.copy(0, ret.getNumRows() - 1, this._slice[1], ret.getNumColumns() - 1, addBlock, false);
                } else if (this._slice[0] > 0 && this._lower) {
                    MatrixBlock addBlock = mb.slice(0, mb.getNumRows() - 1, 0, this._slice[0] - 1, new MatrixBlock());
                    ret.copy(0, ret.getNumRows() - 1, 0, this._slice[0] - 1, addBlock, false);
                }
            } else {
                ret = new MatrixBlock(mb.getNumRows(), mb.getNumColumns(), 0.0);
                ret.copy(this._slice[0], this._slice[1] - 1, 0, mb.getNumColumns() - 1, tri, false);
                if (this._slice[0] > 0 && !this._lower) {
                    MatrixBlock addBlock = mb.slice(0, this._slice[0] - 1, 0, mb.getNumColumns() - 1, new MatrixBlock());
                    ret.copy(0, ret.getNumRows() - 1, this._slice[1], ret.getNumColumns() - 1, addBlock, false);
                } else if (this._slice[1] <= mb.getNumRows() && this._lower) {
                    MatrixBlock addBlock = mb.slice(this._slice[1], ret.getNumRows() - 1, 0, mb.getNumColumns() - 1, new MatrixBlock());
                    ret.copy(this._slice[1], ret.getNumRows() - 1, 0, mb.getNumColumns() - 1, addBlock, false);
                }
            }
            MatrixObject mout = ExecutionContext.createMatrixObject(ret);
            ec.setVariable(String.valueOf(this._outputID), mout);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
        }

        @Override
        public List<Long> getOutputIds() {
            return new ArrayList<Long>(Arrays.asList(this._outputID));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            LineageItem[] liUdfInputs = (LineageItem[])Arrays.stream(this.getInputIDs()).mapToObj(id -> ec.getLineage().get(String.valueOf(id))).toArray(LineageItem[]::new);
            CPOperand slice = new CPOperand(Arrays.toString(this._slice), Types.ValueType.STRING, Types.DataType.SCALAR, true);
            CPOperand rowFed = new CPOperand(String.valueOf(this._rowFed), Types.ValueType.BOOLEAN, Types.DataType.SCALAR, true);
            CPOperand lower = new CPOperand(String.valueOf(this._lower), Types.ValueType.BOOLEAN, Types.DataType.SCALAR, true);
            CPOperand diag = new CPOperand(String.valueOf(this._diag), Types.ValueType.BOOLEAN, Types.DataType.SCALAR, true);
            CPOperand values = new CPOperand(String.valueOf(this._values), Types.ValueType.BOOLEAN, Types.DataType.SCALAR, true);
            LineageItem[] otherInputs = LineageItemUtils.getLineage(ec, slice, rowFed, lower, diag, values);
            LineageItem[] liInputs = (LineageItem[])Stream.concat(Arrays.stream(liUdfInputs), Arrays.stream(otherInputs)).toArray(LineageItem[]::new);
            return Pair.of((Object)String.valueOf(this._outputID), (Object)new LineageItem(this.getClass().getSimpleName(), liInputs));
        }
    }
}

