/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.DDCArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.compress.ArrayCompressionStatistics;
import org.apache.sysds.runtime.matrix.data.Pair;

public abstract class Array<T>
implements Writable {
    protected static final Log LOG = LogFactory.getLog((String)Array.class.getName());
    protected SoftReference<Map<T, Long>> _rcdMapCache = null;
    protected int _size;

    protected Array(int size) {
        this._size = size;
        if (size <= 0) {
            throw new DMLRuntimeException("Invalid zero/negative size of Array");
        }
    }

    protected int newSize() {
        return Math.max(this._size * 2, 4);
    }

    public final SoftReference<Map<T, Long>> getCache() {
        return this._rcdMapCache;
    }

    public final void setCache(SoftReference<Map<T, Long>> m) {
        this._rcdMapCache = m;
    }

    public final synchronized Map<T, Long> getRecodeMap() {
        Map<T, Long> map;
        SoftReference<Map<T, Long>> tmp = this.getCache();
        Map<T, Long> map2 = map = tmp != null ? tmp.get() : null;
        if (map != null) {
            return map;
        }
        map = this.createRecodeMap();
        this.setCache(new SoftReference<Map<T, Long>>(map));
        return map;
    }

    protected Map<T, Long> createRecodeMap() {
        HashMap<T, Long> map = new HashMap<T, Long>();
        long id = 1L;
        for (int i = 0; i < this.size(); ++i) {
            Long v;
            T val = this.get(i);
            if (val == null || (v = map.putIfAbsent(val, id)) != null) continue;
            ++id;
        }
        return map;
    }

    protected Map<T, Integer> getDictionary() {
        HashMap<T, Integer> dict = new HashMap<T, Integer>();
        Integer id = 0;
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            T val = this.get(i);
            Integer v = (Integer)dict.get(val);
            if (v != null) continue;
            Integer n = id;
            Integer n2 = id = Integer.valueOf(id + 1);
            dict.put(val, n);
        }
        return dict;
    }

    protected Map<T, Integer> tryGetDictionary(int threshold) {
        HashMap<T, Integer> dict = new HashMap<T, Integer>();
        Integer id = 0;
        int s = this.size();
        for (int i = 0; i < s && id < threshold; ++i) {
            T val = this.get(i);
            Integer v = (Integer)dict.get(val);
            if (v != null) continue;
            Integer n = id;
            Integer n2 = id = Integer.valueOf(id + 1);
            dict.put(val, n);
        }
        if (id >= threshold) {
            return null;
        }
        return dict;
    }

    public final int size() {
        return this._size;
    }

    public abstract T get(int var1);

    public abstract Object get();

    public abstract double getAsDouble(int var1);

    public double getAsNaNDouble(int i) {
        return this.getAsDouble(i);
    }

    public abstract void set(int var1, T var2);

    public abstract void set(int var1, double var2);

    public abstract void set(int var1, String var2);

    public abstract void setFromOtherType(int var1, int var2, Array<?> var3);

    public void set(int rl, int ru, Array<T> value) {
        for (int i = rl; i <= ru; ++i) {
            this.set(i, value.get(i));
        }
    }

    public void set(int rl, int ru, Array<T> value, int rlSrc) {
        int i = rl;
        int off = rlSrc;
        while (i <= ru) {
            this.set(i, value.get(off));
            ++i;
            ++off;
        }
    }

    public final void setNz(Array<T> value) {
        this.setNz(0, value.size() - 1, value);
    }

    public abstract void setNz(int var1, int var2, Array<T> var3);

    public final void setFromOtherTypeNz(Array<?> value) {
        this.setFromOtherTypeNz(0, value.size() - 1, value);
    }

    public abstract void setFromOtherTypeNz(int var1, int var2, Array<?> var3);

    public abstract void append(String var1);

    public abstract void append(T var1);

    public abstract Array<T> append(Array<T> var1);

    public abstract Array<T> slice(int var1, int var2);

    public abstract void reset(int var1);

    public abstract byte[] getAsByteArray();

    public abstract Types.ValueType getValueType();

    public final Pair<Types.ValueType, Boolean> analyzeValueType() {
        return this.analyzeValueType(this.size());
    }

    public abstract Pair<Types.ValueType, Boolean> analyzeValueType(int var1);

    public abstract ArrayFactory.FrameArrayType getFrameArrayType();

    public long getInMemorySize() {
        return Array.baseMemoryCost();
    }

    public static long baseMemoryCost() {
        return 32L;
    }

    public abstract long getExactSerializedSize();

    public ABooleanArray getNulls() {
        return null;
    }

    public boolean containsNull() {
        return false;
    }

    public abstract boolean possiblyContainsNaN();

    public Array<?> safeChangeType(Types.ValueType t, boolean containsNull) {
        try {
            return this.changeType(t, containsNull);
        }
        catch (Exception e) {
            Pair<Types.ValueType, Boolean> ct = this.analyzeValueType();
            return this.changeType(ct.getKey(), ct.getValue());
        }
    }

    public Array<?> changeType(Types.ValueType t, boolean containsNull) {
        return containsNull ? this.changeTypeWithNulls(t) : this.changeType(t);
    }

    public Array<?> changeTypeWithNulls(Types.ValueType t) {
        ABooleanArray nulls = this.getNulls();
        if (nulls == null) {
            return this.changeType(t);
        }
        switch (t) {
            case BOOLEAN: {
                if (this.size() > 64) {
                    return new OptionalArray<Boolean>(this.changeTypeBitSet(), nulls);
                }
                return new OptionalArray<Boolean>(this.changeTypeBoolean(), nulls);
            }
            case FP32: {
                return new OptionalArray<Float>(this.changeTypeFloat(), nulls);
            }
            case FP64: {
                return new OptionalArray<Double>(this.changeTypeDouble(), nulls);
            }
            case UINT4: 
            case UINT8: {
                throw new NotImplementedException();
            }
            case HASH64: {
                return new OptionalArray<Object>(this.changeTypeHash64(), nulls);
            }
            case INT32: {
                return new OptionalArray<Integer>(this.changeTypeInteger(), nulls);
            }
            case INT64: {
                return new OptionalArray<Long>(this.changeTypeLong(), nulls);
            }
            case CHARACTER: {
                return new OptionalArray<Character>(this.changeTypeCharacter(), nulls);
            }
        }
        return this.changeTypeString();
    }

    public final Array<?> changeType(Types.ValueType t) {
        switch (t) {
            case BOOLEAN: {
                if (this.size() > 64) {
                    return this.changeTypeBitSet();
                }
                return this.changeTypeBoolean();
            }
            case FP32: {
                return this.changeTypeFloat();
            }
            case FP64: {
                return this.changeTypeDouble();
            }
            case UINT4: 
            case UINT8: {
                throw new NotImplementedException();
            }
            case HASH64: {
                return this.changeTypeHash64();
            }
            case INT32: {
                return this.changeTypeInteger();
            }
            case INT64: {
                return this.changeTypeLong();
            }
            case STRING: {
                return this.changeTypeString();
            }
            case CHARACTER: {
                return this.changeTypeCharacter();
            }
        }
        return this.changeTypeString();
    }

    protected abstract Array<Boolean> changeTypeBitSet();

    protected abstract Array<Boolean> changeTypeBoolean();

    protected abstract Array<Double> changeTypeDouble();

    protected abstract Array<Float> changeTypeFloat();

    protected abstract Array<Integer> changeTypeInteger();

    protected abstract Array<Long> changeTypeLong();

    protected abstract Array<Object> changeTypeHash64();

    protected abstract Array<String> changeTypeString();

    protected abstract Array<Character> changeTypeCharacter();

    public Pair<Integer, Integer> getMinMaxLength() {
        throw new DMLRuntimeException("Length is only relevant if case is String");
    }

    public abstract void fill(String var1);

    public abstract void fill(T var1);

    public abstract boolean isShallowSerialize();

    public abstract boolean isEmpty();

    public abstract Array<T> select(int[] var1);

    public abstract Array<T> select(boolean[] var1, int var2);

    public final void findEmpty(boolean[] select) {
        for (int i = 0; i < select.length; ++i) {
            if (!this.isNotEmpty(i)) continue;
            select[i] = true;
        }
    }

    public abstract boolean isNotEmpty(int var1);

    public void findEmptyInverse(boolean[] select) {
        for (int i = 0; i < select.length; ++i) {
            if (this.isNotEmpty(i)) continue;
            select[i] = true;
        }
    }

    public abstract Array<T> clone();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public abstract double hashDouble(int var1);

    public ArrayIterator getIterator() {
        return new ArrayIterator();
    }

    public boolean equals(Object other) {
        return other instanceof Array && ((Array)other).getValueType() == this.getValueType() && this.equals((Array)other);
    }

    public double[] extractDouble(double[] ret, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            ret[i - rl] = this.getAsDouble(i);
        }
        return ret;
    }

    public abstract boolean equals(Array<T> var1);

    public ArrayCompressionStatistics statistics(int nSamples) {
        int memSizePerElement;
        HashMap<T, Integer> d = new HashMap<T, Integer>();
        for (int i = 0; i < nSamples; ++i) {
            T key = this.get(i);
            if (d.containsKey(key)) {
                d.put(key, (Integer)d.get(key) + 1);
                continue;
            }
            d.put(key, 1);
        }
        Pair<Types.ValueType, Boolean> vt = this.analyzeValueType(nSamples);
        if (vt.getKey() == Types.ValueType.UNKNOWN) {
            vt = this.analyzeValueType();
        }
        if (vt.getKey() == Types.ValueType.UNKNOWN) {
            vt = new Pair<Types.ValueType, Boolean>(Types.ValueType.STRING, false);
        }
        int[] freq = new int[d.size()];
        int id = 0;
        for (Map.Entry e : d.entrySet()) {
            freq[id++] = (Integer)e.getValue();
        }
        int estDistinct = SampleEstimatorFactory.distinctCount(freq, this.size(), nSamples);
        long memSize = vt.getKey() != this.getValueType() ? ArrayFactory.getInMemorySize(vt.getKey(), this.size(), this.containsNull()) : this.getInMemorySize();
        switch (vt.getKey()) {
            case FP32: 
            case UINT4: 
            case UINT8: 
            case INT32: {
                memSizePerElement = 4;
                break;
            }
            case FP64: 
            case HASH64: 
            case INT64: {
                memSizePerElement = 8;
                break;
            }
            case CHARACTER: {
                memSizePerElement = 2;
                break;
            }
            case BOOLEAN: {
                memSizePerElement = 1;
            }
            default: {
                memSizePerElement = (int)(memSize / (long)this.size());
            }
        }
        long ddcSize = DDCArray.estimateInMemorySize(memSizePerElement, estDistinct, this.size());
        if (ddcSize < memSize) {
            return new ArrayCompressionStatistics(memSizePerElement, estDistinct, true, vt.getKey(), vt.getValue(), ArrayFactory.FrameArrayType.DDC, this.getInMemorySize(), ddcSize);
        }
        if (vt.getKey() != this.getValueType()) {
            return new ArrayCompressionStatistics(memSizePerElement, estDistinct, true, vt.getKey(), vt.getValue(), null, this.getInMemorySize(), memSize);
        }
        return null;
    }

    public AMapToData createMapping(Map<T, Integer> d) {
        int s = this.size();
        AMapToData m = MapToFactory.create(s, d.size());
        for (int i = 0; i < s; ++i) {
            m.set(i, d.get(this.get(i)));
        }
        return m;
    }

    public class ArrayIterator
    implements Iterator<T> {
        int index = -1;

        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean hasNext() {
            return this.index < Array.this.size() - 1;
        }

        @Override
        public T next() {
            return Array.this.get(++this.index);
        }
    }
}

