/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class MMTSJ
extends Lop {
    private MMTSJType _type = null;
    private boolean _multiPass = false;
    private int _numThreads = 1;

    public MMTSJ(Lop input1, Types.DataType dt, Types.ValueType vt, Types.ExecType et, MMTSJType type) {
        this(input1, dt, vt, et, type, false, -1);
    }

    public MMTSJ(Lop input1, Types.DataType dt, Types.ValueType vt, Types.ExecType et, MMTSJType type, boolean multiPass) {
        this(input1, dt, vt, et, type, multiPass, -1);
    }

    public MMTSJ(Lop input1, Types.DataType dt, Types.ValueType vt, Types.ExecType et, MMTSJType type, boolean multiPass, int k) {
        super(Lop.Type.MMTSJ, dt, vt);
        this.addInput(input1);
        input1.addOutput(this);
        this._type = type;
        this._multiPass = multiPass;
        this._numThreads = k;
        if (multiPass && et != Types.ExecType.SPARK) {
            throw new RuntimeException("Multipass tsmm only supported for exec type SPARK.");
        }
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation = MMTSJ";
    }

    @Override
    public String getInstructions(String input_index1, String output_index) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this._multiPass ? Opcodes.TSMM2.toString() : Opcodes.TSMM.toString());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        sb.append("\u00b0");
        sb.append((Object)this._type);
        if (this.getExecType() == Types.ExecType.CP || this.getExecType() == Types.ExecType.FED) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
            if (this.getExecType() == Types.ExecType.FED) {
                sb.append("\u00b0");
                sb.append(this._fedOutput.name());
            }
        }
        return sb.toString();
    }

    public static enum MMTSJType {
        NONE,
        LEFT,
        RIGHT;


        public boolean isLeft() {
            return this == LEFT;
        }

        public boolean isRight() {
            return this == RIGHT;
        }
    }
}

