/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.util.ArrayList;
import jcuda.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.runtime.codegen.SpoofCUDAOperator;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.codegen.SpoofRowwise;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;

public class SpoofCUDARowwise
extends SpoofRowwise
implements SpoofCUDAOperator {
    private static final long serialVersionUID = 3080001135814944399L;
    private static final Log LOG = LogFactory.getLog((String)SpoofCUDARowwise.class.getName());
    private final int ID;
    private final SpoofCUDAOperator.PrecisionProxy call;
    private final long ctx;

    public SpoofCUDARowwise(SpoofRowwise.RowType type, long constDim2, boolean tB1, int reqVectMem, int id, SpoofCUDAOperator.PrecisionProxy ep) {
        super(type, constDim2, tB1, reqVectMem);
        this.ID = id;
        this.call = ep;
        this.ctx = SpoofCompiler.native_contexts.get((Object)SpoofCompiler.GeneratorAPI.CUDA);
    }

    @Override
    public String getName() {
        return this.getSpoofType();
    }

    @Override
    public ScalarObject execute(ExecutionContext ec, ArrayList<MatrixObject> inputs, ArrayList<ScalarObject> scalarObjects) {
        double[] result = new double[1];
        Pointer[] ptr = new Pointer[1];
        this.packDataForTransfer(ec, inputs, scalarObjects, null, 1, this.ID, 0L, this._tB1, ptr);
        if (this.call.exec(this) != 0) {
            LOG.error((Object)("SpoofCUDA " + this.getSpoofType() + " operator " + this.ID + " failed to execute!\n"));
        }
        LibMatrixCUDA.cudaSupportFunctions.deviceToHost(ec.getGPUContext(0), ptr[0], result, this.getName(), false);
        ec.getGPUContext(0).cudaFreeHelper(this.getSpoofType(), ptr[0], DMLScript.EAGER_CUDA_FREE);
        return new DoubleObject(result[0]);
    }

    @Override
    public MatrixObject execute(ExecutionContext ec, ArrayList<MatrixObject> inputs, ArrayList<ScalarObject> scalarObjects, String outputName) {
        int m = (int)inputs.get(0).getNumRows();
        int n = (int)inputs.get(0).getNumColumns();
        int n2 = this._type.isConstDim2(this._constDim2) ? (int)this._constDim2 : (this._type.isRowTypeB1() || SpoofCUDARowwise.hasMatrixObjectSideInput(inputs) ? SpoofCUDARowwise.getMinColsMatrixObjectSideInputs(inputs) : -1);
        SpoofRowwise.OutputDimensions out_dims = new SpoofRowwise.OutputDimensions(this, m, n, n2);
        ec.setMetaData(outputName, out_dims.rows, out_dims.cols);
        MatrixObject out_obj = ec.getDenseMatrixOutputForGPUInstruction(outputName, out_dims.rows, out_dims.cols, false).getKey();
        this.packDataForTransfer(ec, inputs, scalarObjects, out_obj, 1, this.ID, 0L, this._tB1, null);
        if (this.call.exec(this) != 0) {
            LOG.error((Object)("SpoofCUDA " + this.getSpoofType() + " operator " + this.ID + " failed to execute!\n"));
        }
        return out_obj;
    }

    @Override
    protected void genexec(double[] a, int ai, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int ci, int len, long grix, int rix) {
    }

    @Override
    protected void genexec(double[] avals, int[] aix, int ai, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int ci, int alen, int n, long grix, int rix) {
    }

    @Override
    public int execute_dp(long ctx) {
        return SpoofCUDARowwise.execute_d(ctx);
    }

    @Override
    public int execute_sp(long ctx) {
        return SpoofCUDARowwise.execute_f(ctx);
    }

    @Override
    public long getContext() {
        return this.ctx;
    }

    public static native int execute_d(long var0);

    public static native int execute_f(long var0);
}

