/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sysds.runtime.io.hdf5.H5BTree;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5DoubleDataType;
import org.apache.sysds.runtime.io.hdf5.H5GroupSymbolTableNode;
import org.apache.sysds.runtime.io.hdf5.H5LocalHeap;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.H5SymbolTableEntry;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5DataLayoutMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5DataSpaceMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5DataTypeMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5FillValueMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5Message;
import org.apache.sysds.runtime.io.hdf5.message.H5NilMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5ObjectModificationTimeMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5SymbolTableMessage;

public class H5ObjectHeader {
    private final H5RootObject rootObject;
    private final List<H5Message> messages = new ArrayList<H5Message>();
    private int referenceCount = 1;
    private String datasetName;

    public H5ObjectHeader(H5RootObject rootObject, long address) {
        this.rootObject = rootObject;
        try {
            ByteBuffer header = rootObject.readBufferFromAddress(address, 12);
            rootObject.setObjectHeaderVersion(header.get());
            if (rootObject.getObjectHeaderVersion() != 1) {
                throw new H5RuntimeException("Invalid version detected. Version is = " + rootObject.getObjectHeaderVersion());
            }
            header.position(header.position() + 1);
            int numberOfMessages = Utils.readBytesAsUnsignedInt(header, 2);
            this.referenceCount = Utils.readBytesAsUnsignedInt(header, 4);
            int headerSize = Utils.readBytesAsUnsignedInt(header, 4);
            header = rootObject.readBufferFromAddress(address += 16L, headerSize);
            this.readMessages(header, numberOfMessages);
        }
        catch (Exception e) {
            throw new H5RuntimeException("Failed to read object header at address: " + address, e);
        }
    }

    public <T extends H5Message> List<T> getMessagesOfType(Class<T> type) {
        return this.getMessages().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public <T extends H5Message> boolean hasMessageOfType(Class<T> type) {
        return !this.getMessagesOfType(type).isEmpty();
    }

    public <T extends H5Message> T getMessageOfType(Class<T> type) {
        List<T> messagesOfType = this.getMessagesOfType(type);
        if (messagesOfType.isEmpty()) {
            throw new H5RuntimeException("Requested message type '" + type.getSimpleName() + "' not present");
        }
        if (messagesOfType.size() > 1) {
            throw new H5RuntimeException("Requested message type '" + type.getSimpleName() + "' is not unique");
        }
        return (T)((H5Message)messagesOfType.get(0));
    }

    private void readMessages(ByteBuffer bb, int numberOfMessages) {
        while (bb.remaining() > 4 && this.messages.size() < numberOfMessages) {
            H5Message m = H5Message.readObjectHeaderMessage(this.rootObject, bb);
            this.messages.add(m);
        }
    }

    public H5ObjectHeader(H5RootObject rootObject, String datasetName) {
        this.rootObject = rootObject;
        this.datasetName = datasetName;
    }

    private void writeObjectHeader(H5BufferBuilder bb, short numberOfMessages, int headerSize) {
        bb.writeByte(this.rootObject.objectHeaderVersion);
        bb.writeByte(0);
        bb.writeShort(numberOfMessages);
        bb.writeInt(this.referenceCount);
        bb.writeInt(headerSize);
        bb.writeInt(0);
    }

    public H5BufferBuilder toBuffer() {
        H5BufferBuilder bb = new H5BufferBuilder();
        this.toBuffer(bb);
        return bb;
    }

    public void toBuffer(H5BufferBuilder bb) {
        this.writeObjectHeader(bb, (short)1, 24);
        BitSet flags = new BitSet();
        long localHeapAddress = 680L;
        H5SymbolTableMessage symbolTableMessage = new H5SymbolTableMessage(this.rootObject, flags, 136L, localHeapAddress);
        symbolTableMessage.toBuffer(bb);
        ArrayList<Long> childAddresses = new ArrayList<Long>();
        childAddresses.add(1072L);
        H5BTree bTree = new H5BTree(this.rootObject, 0, 0, 1, -1L, -1L, childAddresses);
        bTree.toBuffer(bb);
        bb.writeShort((short)8);
        bb.goToPositionWithWriteZero(localHeapAddress);
        H5LocalHeap localHeap = new H5LocalHeap(this.rootObject, this.datasetName, 88L, 16L, 712L);
        localHeap.toBuffer(bb);
        this.writeObjectHeader(bb, (short)6, 256);
        flags = new BitSet(8);
        H5DataSpaceMessage dataSpaceMessage = new H5DataSpaceMessage(this.rootObject, flags);
        dataSpaceMessage.toBuffer(bb);
        flags.set(0);
        H5DoubleDataType doubleDataType = new H5DoubleDataType();
        H5DataTypeMessage dataTypeMessage = new H5DataTypeMessage(this.rootObject, flags, doubleDataType);
        dataTypeMessage.toBuffer(bb);
        H5FillValueMessage fillValueMessage = new H5FillValueMessage(this.rootObject, flags, 2, 2, true);
        fillValueMessage.toBuffer(bb);
        flags = new BitSet();
        H5DataLayoutMessage dataLayoutMessage = new H5DataLayoutMessage(this.rootObject, flags, 2048L, this.rootObject.row * this.rootObject.col * (long)this.rootObject.superblock.sizeOfLengths);
        dataLayoutMessage.toBuffer(bb);
        long time = Instant.now().getEpochSecond();
        H5ObjectModificationTimeMessage objectModificationTimeMessage = new H5ObjectModificationTimeMessage(this.rootObject, flags, time);
        objectModificationTimeMessage.toBuffer(bb);
        H5NilMessage nilMessage = new H5NilMessage(this.rootObject, flags);
        nilMessage.toBuffer(bb);
        int i = 0;
        Iterator iterator = childAddresses.iterator();
        while (iterator.hasNext()) {
            long child = (Long)iterator.next();
            bb.goToPositionWithWriteZero(child);
            H5SymbolTableEntry[] symbolTableEntries = new H5SymbolTableEntry[1];
            symbolTableEntries[i++] = new H5SymbolTableEntry(8, 800L, 0, -1L, -1L);
            H5GroupSymbolTableNode groupSTE = new H5GroupSymbolTableNode(this.rootObject, 1, symbolTableEntries);
            groupSTE.toBuffer(bb);
        }
    }

    public List<H5Message> getMessages() {
        return this.messages;
    }
}

