/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DNSRecordClass {
    CLASS_UNKNOWN("?", 0),
    CLASS_IN("in", 1),
    CLASS_CS("cs", 2),
    CLASS_CH("ch", 3),
    CLASS_HS("hs", 4),
    CLASS_NONE("none", 254),
    CLASS_ANY("any", 255);

    public static final int CLASS_MASK = Short.MAX_VALUE;
    public static final int CLASS_UNIQUE = 32768;
    public static final boolean UNIQUE = true;
    public static final boolean NOT_UNIQUE = false;
    private final String externalName;
    private final int indexValue;

    private DNSRecordClass(String name, int index) {
        this.externalName = name;
        this.indexValue = index;
    }

    public String externalName() {
        return this.externalName;
    }

    public int indexValue() {
        return this.indexValue;
    }

    public boolean isUnique(int index) {
        return this != CLASS_UNKNOWN && (index & 0x8000) != 0;
    }

    public static DNSRecordClass classForName(String name) {
        if (name != null) {
            String lowerCaseName = name.toLowerCase();
            for (DNSRecordClass recordClass : DNSRecordClass.values()) {
                if (!recordClass.externalName.equals(lowerCaseName)) continue;
                return recordClass;
            }
        }
        Logger logger = LoggerFactory.getLogger(DNSRecordClass.class);
        logger.warn("Could not find record class for name: {}", (Object)name);
        return CLASS_UNKNOWN;
    }

    public static DNSRecordClass classForIndex(int index) {
        int maskedIndex = index & Short.MAX_VALUE;
        for (DNSRecordClass recordClass : DNSRecordClass.values()) {
            if (recordClass.indexValue != maskedIndex) continue;
            return recordClass;
        }
        Logger logger = LoggerFactory.getLogger(DNSRecordClass.class);
        logger.debug("Could not find record class for index: {}", (Object)index);
        return CLASS_UNKNOWN;
    }

    public String toString() {
        return this.name() + " index " + this.indexValue();
    }
}

