/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Deque;
import javax.management.AttributeNotFoundException;
import org.jolokia.service.serializer.json.DateFormatConfiguration;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.Converter;

public class JavaTimeTemporalAccessor
implements ObjectAccessor {
    private final DateFormatConfiguration configuration;

    public JavaTimeTemporalAccessor(DateFormatConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<?> getType() {
        return Temporal.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pTemporal, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        if (!pJsonify || pTemporal == null) {
            return pTemporal;
        }
        Temporal temporal = (Temporal)pTemporal;
        if (this.configuration.usesUnixTime(temporal)) {
            return this.configuration.toUnixTime(temporal);
        }
        return this.extractString(pTemporal);
    }

    @Override
    public boolean supportsStringConversion() {
        return true;
    }

    @Override
    public String extractString(Object pTemporal) {
        Temporal temporal = (Temporal)pTemporal;
        if (this.configuration.usesUnixTime(temporal)) {
            return Long.toString(this.configuration.toUnixTime(temporal));
        }
        if (temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
            return this.configuration.format(temporal);
        }
        if (temporal instanceof LocalDateTime) {
            ZoneOffset offset = this.configuration.getZoneRules().getOffset((LocalDateTime)temporal);
            return this.configuration.format(((LocalDateTime)temporal).atOffset(offset));
        }
        if (temporal instanceof OffsetTime) {
            return DateTimeFormatter.ISO_OFFSET_TIME.format(temporal);
        }
        if (temporal instanceof LocalDate) {
            return DateTimeFormatter.ISO_LOCAL_DATE.format(temporal);
        }
        if (temporal instanceof LocalTime) {
            return DateTimeFormatter.ISO_LOCAL_TIME.format(temporal);
        }
        if (temporal instanceof Year) {
            return Integer.toString(((Year)temporal).getValue());
        }
        if (temporal instanceof YearMonth) {
            YearMonth ym = (YearMonth)temporal;
            int month = ym.getMonthValue();
            return ym.getYear() + "-" + String.valueOf(month < 10 ? "0" + month : Integer.valueOf(month));
        }
        throw new IllegalArgumentException("Can't convert " + String.valueOf(temporal.getClass()) + " value");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pObject, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        throw new IllegalArgumentException("java.time.Temporal instance is immutable and cannot change its value");
    }
}

