/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityDispatchPolicy
extends SimpleDispatchPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PriorityDispatchPolicy.class);
    private final Comparator<? super Subscription> orderedCompare = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription o1, Subscription o2) {
            return o2.getConsumerInfo().getPriority() - o1.getConsumerInfo().getPriority();
        }
    };

    @Override
    public boolean dispatch(MessageReference node, MessageEvaluationContext msgContext, List<Subscription> consumers) throws Exception {
        ArrayList<Subscription> ordered = new ArrayList<Subscription>(consumers);
        Collections.sort(ordered, this.orderedCompare);
        if (LOG.isTraceEnabled() && !ordered.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(",");
            for (Subscription sub : ordered) {
                stringJoiner.add(String.valueOf(sub.getConsumerInfo().getPriority()));
            }
            LOG.trace("Ordered priorities: {}", (Object)stringJoiner);
        }
        return super.dispatch(node, msgContext, ordered);
    }
}

