/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LFUCache<Key, Value>
implements Map<Key, Value> {
    private final Map<Key, CacheNode<Key, Value>> cache;
    private final LinkedHashSet[] frequencyList;
    private int lowestFrequency;
    private int maxFrequency;
    private final int maxCacheSize;
    private final float evictionFactor;

    public LFUCache(int maxCacheSize, float evictionFactor) {
        if (evictionFactor <= 0.0f || evictionFactor >= 1.0f) {
            throw new IllegalArgumentException("Eviction factor must be greater than 0 and lesser than or equal to 1");
        }
        this.cache = new HashMap<Key, CacheNode<Key, Value>>(maxCacheSize);
        this.frequencyList = new LinkedHashSet[maxCacheSize];
        this.lowestFrequency = 0;
        this.maxFrequency = maxCacheSize - 1;
        this.maxCacheSize = maxCacheSize;
        this.evictionFactor = evictionFactor;
        this.initFrequencyList();
    }

    @Override
    public Value put(Key k, Value v) {
        Value oldValue = null;
        CacheNode<Key, Value> currentNode = this.cache.get(k);
        if (currentNode == null) {
            if (this.cache.size() == this.maxCacheSize) {
                this.doEviction();
            }
            LinkedHashSet nodes = this.frequencyList[0];
            currentNode = new CacheNode<Key, Value>(k, v, 0);
            nodes.add(currentNode);
            this.cache.put(k, currentNode);
            this.lowestFrequency = 0;
        } else {
            oldValue = currentNode.v;
            currentNode.v = v;
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> map) {
        for (Map.Entry<Key, Value> me : map.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public Value get(Object k) {
        CacheNode<Key, Value> currentNode = this.cache.get(k);
        if (currentNode != null) {
            int currentFrequency = currentNode.frequency;
            if (currentFrequency < this.maxFrequency) {
                int nextFrequency = currentFrequency + 1;
                LinkedHashSet currentNodes = this.frequencyList[currentFrequency];
                LinkedHashSet newNodes = this.frequencyList[nextFrequency];
                this.moveToNextFrequency(currentNode, nextFrequency, currentNodes, newNodes);
                this.cache.put(k, currentNode);
                if (this.lowestFrequency == currentFrequency && currentNodes.isEmpty()) {
                    this.lowestFrequency = nextFrequency;
                }
            } else {
                LinkedHashSet nodes = this.frequencyList[currentFrequency];
                nodes.remove(currentNode);
                nodes.add(currentNode);
            }
            return currentNode.v;
        }
        return null;
    }

    @Override
    public Value remove(Object k) {
        CacheNode<Key, Value> currentNode = this.cache.remove(k);
        if (currentNode != null) {
            LinkedHashSet nodes = this.frequencyList[currentNode.frequency];
            nodes.remove(currentNode);
            if (this.lowestFrequency == currentNode.frequency) {
                this.findNextLowestFrequency();
            }
            return currentNode.v;
        }
        return null;
    }

    public int frequencyOf(Key k) {
        CacheNode<Key, Value> node = this.cache.get(k);
        if (node != null) {
            return node.frequency + 1;
        }
        return 0;
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 <= this.maxFrequency; ++i2) {
            this.frequencyList[i2].clear();
        }
        this.cache.clear();
        this.lowestFrequency = 0;
    }

    @Override
    public Set<Key> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Collection<Value> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return null;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.cache.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return false;
    }

    private void initFrequencyList() {
        for (int i2 = 0; i2 <= this.maxFrequency; ++i2) {
            this.frequencyList[i2] = new LinkedHashSet();
        }
    }

    private void doEviction() {
        int currentlyDeleted = 0;
        float target = (float)this.maxCacheSize * this.evictionFactor;
        while ((float)currentlyDeleted < target) {
            LinkedHashSet nodes = this.frequencyList[this.lowestFrequency];
            if (nodes.isEmpty()) {
                throw new IllegalStateException("Lowest frequency constraint violated!");
            }
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                int n = currentlyDeleted++;
                if (!((float)n < target)) break;
                CacheNode node = (CacheNode)it.next();
                it.remove();
                this.cache.remove(node.k);
            }
            if (it.hasNext()) continue;
            this.findNextLowestFrequency();
        }
    }

    private void moveToNextFrequency(CacheNode<Key, Value> currentNode, int nextFrequency, LinkedHashSet<CacheNode<Key, Value>> currentNodes, LinkedHashSet<CacheNode<Key, Value>> newNodes) {
        currentNodes.remove(currentNode);
        newNodes.add(currentNode);
        currentNode.frequency = nextFrequency;
    }

    private void findNextLowestFrequency() {
        while (this.lowestFrequency <= this.maxFrequency && this.frequencyList[this.lowestFrequency].isEmpty()) {
            ++this.lowestFrequency;
        }
        if (this.lowestFrequency > this.maxFrequency) {
            this.lowestFrequency = 0;
        }
    }

    private static class CacheNode<Key, Value> {
        public final Key k;
        public Value v;
        public int frequency;

        public CacheNode(Key k, Value v, int frequency) {
            this.k = k;
            this.v = v;
            this.frequency = frequency;
        }
    }
}

