/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.core.io.support.PropertySourceProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertySourceRegistry {
    private final PropertySourceProcessor propertySourceProcessor;
    private final List<PropertySourceDescriptor> descriptors;

    public PropertySourceRegistry(PropertySourceProcessor propertySourceProcessor) {
        this.propertySourceProcessor = propertySourceProcessor;
        this.descriptors = new ArrayList<PropertySourceDescriptor>();
    }

    void processPropertySource(AnnotationAttributes propertySource) throws IOException {
        String[] locations;
        String encoding;
        String name = propertySource.getString("name");
        if (!StringUtils.hasLength(name)) {
            name = null;
        }
        if (!StringUtils.hasLength(encoding = propertySource.getString("encoding"))) {
            encoding = null;
        }
        Assert.isTrue((locations = propertySource.getStringArray("value")).length > 0, "At least one @PropertySource(value) location is required");
        boolean ignoreResourceNotFound = propertySource.getBoolean("ignoreResourceNotFound");
        Class factoryClass = propertySource.getClass("factory");
        Class factoryClassToUse = factoryClass != PropertySourceFactory.class ? factoryClass : null;
        PropertySourceDescriptor descriptor = new PropertySourceDescriptor(Arrays.asList(locations), ignoreResourceNotFound, name, factoryClassToUse, encoding);
        this.propertySourceProcessor.processPropertySource(descriptor);
        this.descriptors.add(descriptor);
    }

    public List<PropertySourceDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }
}

