/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.listener.adapter.JmsResponse;
import org.springframework.jms.listener.adapter.ReplyFailureException;
import org.springframework.jms.support.JmsHeaderMapper;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.QosSettings;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessagingMessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.converter.SmartMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;

public abstract class AbstractAdaptableMessageListener
implements MessageListener,
SessionAwareMessageListener<Message> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private Object defaultResponseDestination;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    @Nullable
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private final MessagingMessageConverterAdapter messagingMessageConverter = new MessagingMessageConverterAdapter();
    @Nullable
    private QosSettings responseQosSettings;

    public void setDefaultResponseDestination(Destination destination) {
        this.defaultResponseDestination = destination;
    }

    public void setDefaultResponseQueueName(String destinationName) {
        this.defaultResponseDestination = new DestinationNameHolder(destinationName, false);
    }

    public void setDefaultResponseTopicName(String destinationName) {
        this.defaultResponseDestination = new DestinationNameHolder(destinationName, true);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull((Object)destinationResolver, (String)"DestinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    protected DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Nullable
    protected MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    public void setResponseQosSettings(@Nullable QosSettings responseQosSettings) {
        this.responseQosSettings = responseQosSettings;
    }

    @Nullable
    protected QosSettings getResponseQosSettings() {
        return this.responseQosSettings;
    }

    public void onMessage(Message message) {
        try {
            this.onMessage(message, (Session)null);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    @Override
    public abstract void onMessage(Message var1, @Nullable Session var2) throws JMSException;

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) {
        try {
            MessageConverter converter = this.getMessageConverter();
            if (converter != null) {
                return converter.fromMessage(message);
            }
            return message;
        }
        catch (JMSException ex) {
            throw new MessageConversionException("Could not convert JMS message", ex);
        }
    }

    protected void handleResult(Object result, Message request, @Nullable Session session) {
        if (session != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Listener method returned result [" + String.valueOf(result) + "] - generating response message for it"));
            }
            try {
                Message response = this.buildMessage(session, result);
                this.postProcessResponse(request, response);
                Destination destination = this.getResponseDestination(request, response, session, result);
                this.sendResponse(session, destination, response);
            }
            catch (Exception ex) {
                throw new ReplyFailureException("Failed to send reply with payload [" + String.valueOf(result) + "]", ex);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Listener method returned result [" + String.valueOf(result) + "]: not generating response message for it because of no JMS Session given"));
        }
    }

    protected Message buildMessage(Session session, Object result) throws JMSException {
        Object object;
        if (result instanceof JmsResponse) {
            JmsResponse jmsResponse = (JmsResponse)result;
            object = jmsResponse.getResponse();
        } else {
            object = result;
        }
        Object content = this.preProcessResponse(object);
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            if (content instanceof org.springframework.messaging.Message) {
                return this.messagingMessageConverter.toMessage(content, session);
            }
            return converter.toMessage(content, session);
        }
        if (!(content instanceof Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + String.valueOf(content) + "]");
        }
        Message message = (Message)content;
        return message;
    }

    protected Object preProcessResponse(Object result) {
        return result;
    }

    protected void postProcessResponse(Message request, Message response) throws JMSException {
        String correlation = request.getJMSCorrelationID();
        if (correlation == null) {
            correlation = request.getJMSMessageID();
        }
        response.setJMSCorrelationID(correlation);
    }

    private Destination getResponseDestination(Message request, Message response, Session session, Object result) throws JMSException {
        JmsResponse jmsResponse;
        Destination destination;
        if (result instanceof JmsResponse && (destination = (jmsResponse = (JmsResponse)result).resolveDestination(this.getDestinationResolver(), session)) != null) {
            return destination;
        }
        return this.getResponseDestination(request, response, session);
    }

    protected Destination getResponseDestination(Message request, Message response, Session session) throws JMSException {
        Destination replyTo = request.getJMSReplyTo();
        if (replyTo == null && (replyTo = this.resolveDefaultResponseDestination(session)) == null) {
            throw new InvalidDestinationException("Cannot determine response destination: Request message does not contain reply-to destination, and no default response destination set.");
        }
        return replyTo;
    }

    @Nullable
    protected Destination resolveDefaultResponseDestination(Session session) throws JMSException {
        Object object = this.defaultResponseDestination;
        if (object instanceof Destination) {
            Destination destination = (Destination)object;
            return destination;
        }
        object = this.defaultResponseDestination;
        if (object instanceof DestinationNameHolder) {
            DestinationNameHolder nameHolder = (DestinationNameHolder)object;
            return this.getDestinationResolver().resolveDestinationName(session, nameHolder.name, nameHolder.isTopic);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Session session, Destination destination, Message response) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        try {
            this.postProcessProducer(producer, response);
            QosSettings settings = this.getResponseQosSettings();
            if (settings != null) {
                producer.send(response, settings.getDeliveryMode(), settings.getPriority(), settings.getTimeToLive());
            } else {
                producer.send(response);
            }
        }
        finally {
            JmsUtils.closeMessageProducer(producer);
        }
    }

    protected void postProcessProducer(MessageProducer producer, Message response) throws JMSException {
    }

    private class MessagingMessageConverterAdapter
    extends MessagingMessageConverter {
        private MessagingMessageConverterAdapter() {
        }

        @Override
        public Object fromMessage(Message message) throws JMSException, MessageConversionException {
            return new LazyResolutionMessage(message);
        }

        @Override
        protected Object extractPayload(Message message) throws JMSException {
            Object payload = AbstractAdaptableMessageListener.this.extractMessage(message);
            if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                try {
                    bytesMessage.reset();
                }
                catch (JMSException ex) {
                    AbstractAdaptableMessageListener.this.logger.debug((Object)"Failed to reset BytesMessage after payload extraction", (Throwable)ex);
                }
            }
            return payload;
        }

        @Override
        protected Message createMessageForPayload(Object payload, Session session, @Nullable Object conversionHint) throws JMSException {
            MessageConverter converter = AbstractAdaptableMessageListener.this.getMessageConverter();
            if (converter == null) {
                throw new IllegalStateException("No message converter, cannot handle '" + String.valueOf(payload) + "'");
            }
            if (converter instanceof SmartMessageConverter) {
                SmartMessageConverter smartMessageConverter = (SmartMessageConverter)converter;
                return smartMessageConverter.toMessage(payload, session, conversionHint);
            }
            return converter.toMessage(payload, session);
        }

        protected class LazyResolutionMessage
        implements org.springframework.messaging.Message<Object> {
            private final Message message;
            @Nullable
            private Object payload;
            @Nullable
            private MessageHeaders headers;

            public LazyResolutionMessage(Message message) {
                this.message = message;
            }

            public Object getPayload() {
                if (this.payload == null) {
                    try {
                        this.payload = this.unwrapPayload();
                    }
                    catch (JMSException ex) {
                        throw new MessageConversionException("Failed to extract payload from [" + String.valueOf(this.message) + "]", ex);
                    }
                }
                return this.payload;
            }

            private Object unwrapPayload() throws JMSException {
                Object payload = MessagingMessageConverterAdapter.this.extractPayload(this.message);
                if (payload instanceof org.springframework.messaging.Message) {
                    org.springframework.messaging.Message springMessage = (org.springframework.messaging.Message)payload;
                    return springMessage.getPayload();
                }
                return payload;
            }

            public MessageHeaders getHeaders() {
                if (this.headers == null) {
                    this.headers = MessagingMessageConverterAdapter.this.extractHeaders(this.message);
                }
                return this.headers;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
                if (this.payload == null) {
                    sb.append(" [rawMessage=").append(this.message);
                } else {
                    sb.append(" [payload=");
                    Object object = this.payload;
                    if (object instanceof byte[]) {
                        byte[] bytes = (byte[])object;
                        sb.append("byte[").append(bytes.length).append(']');
                    } else {
                        sb.append(this.payload);
                    }
                }
                if (this.headers != null) {
                    sb.append(", headers=").append(this.headers);
                }
                sb.append(']');
                return sb.toString();
            }
        }
    }

    private static class DestinationNameHolder {
        public final String name;
        public final boolean isTopic;

        public DestinationNameHolder(String name, boolean isTopic) {
            this.name = name;
            this.isTopic = isTopic;
        }
    }
}

