/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import org.apache.camel.ValueHolder;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.StringHelper;

public final class TransformerKey
extends ValueHolder<String> {
    private final DataType from;
    private final DataType to;

    public TransformerKey(String toType) {
        this(DataType.ANY, new DataType(toType));
        StringHelper.notEmpty((String)toType, (String)"toType");
    }

    public TransformerKey(DataType to) {
        this(DataType.ANY, to);
    }

    public TransformerKey(DataType from, DataType to) {
        super(TransformerKey.createKeyString(from, to));
        this.from = from;
        this.to = to;
    }

    private static String createKeyString(DataType from, DataType to) {
        if (DataType.isAnyType(from)) {
            return to.getFullName();
        }
        return from.getFullName() + "/" + to.getFullName();
    }

    public static TransformerKey createFrom(Transformer answer) {
        if (!DataType.isAnyType(answer.getFrom()) && !DataType.isAnyType(answer.getTo())) {
            return new TransformerKey(answer.getFrom(), answer.getTo());
        }
        return new TransformerKey(answer.getName());
    }

    public DataType getFrom() {
        return this.from;
    }

    public DataType getTo() {
        return this.to;
    }

    public String toString() {
        return (String)this.get();
    }
}

