/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.task.AbstractTask;
import org.apache.camel.support.task.AbstractTaskBuilder;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.Task;
import org.apache.camel.support.task.TaskManagerRegistry;
import org.apache.camel.support.task.TaskRunFailureException;
import org.apache.camel.support.task.budget.IterationBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForegroundTask
extends AbstractTask
implements BlockingTask {
    private static final Logger LOG = LoggerFactory.getLogger(ForegroundTask.class);
    private final IterationBudget budget;
    private Duration elapsed = Duration.ZERO;
    private final AtomicBoolean running = new AtomicBoolean();

    ForegroundTask(IterationBudget budget, String name) {
        super(name);
        this.budget = budget;
    }

    @Override
    public boolean run(CamelContext camelContext, BooleanSupplier supplier) {
        this.running.set(true);
        boolean completed = false;
        TaskManagerRegistry registry = null;
        if (camelContext != null) {
            registry = PluginHelper.getTaskManagerRegistry(camelContext.getCamelContextExtension());
        }
        if (registry != null) {
            registry.addTask(this);
        }
        try {
            if (this.budget.initialDelay() > 0L) {
                Thread.sleep(this.budget.initialDelay());
            }
            while (this.budget.next()) {
                this.lastAttemptTime = System.currentTimeMillis();
                if (this.firstAttemptTime < 0L) {
                    this.firstAttemptTime = this.lastAttemptTime;
                }
                this.nextAttemptTime = this.lastAttemptTime + this.budget.interval();
                if (this.doRun(supplier)) {
                    LOG.debug("Task {} is complete after {} iterations and it is ready to continue", (Object)this.getName(), (Object)this.budget.iteration());
                    this.status = Task.Status.Completed;
                    completed = true;
                    break;
                }
                if (this.budget.canContinue()) {
                    Thread.sleep(this.budget.interval());
                    continue;
                }
                this.status = Task.Status.Exhausted;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted {} while waiting for the repeatable task to finish", (Object)this.getName());
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.status = Task.Status.Failed;
            this.cause = e;
            throw e;
        }
        finally {
            this.elapsed = this.budget.elapsed();
            this.running.set(false);
            if (registry != null) {
                registry.removeTask(this);
            }
        }
        return completed;
    }

    protected boolean doRun(BooleanSupplier supplier) {
        try {
            this.cause = null;
            return supplier.getAsBoolean();
        }
        catch (TaskRunFailureException e) {
            LOG.debug("Task {} failed at {} iterations and will attempt again on next interval: {}", new Object[]{this.getName(), this.budget.iteration(), e.getMessage()});
            this.cause = e;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Optional<T> run(CamelContext camelContext, Supplier<T> supplier, Predicate<T> predicate) {
        this.running.set(true);
        TaskManagerRegistry registry = null;
        if (camelContext != null) {
            registry = PluginHelper.getTaskManagerRegistry(camelContext.getCamelContextExtension());
        }
        if (registry != null) {
            registry.addTask(this);
        }
        try {
            if (this.budget.initialDelay() > 0L) {
                Thread.sleep(this.budget.initialDelay());
            }
            while (this.budget.next()) {
                T ret;
                this.lastAttemptTime = System.currentTimeMillis();
                if (this.firstAttemptTime < 0L) {
                    this.firstAttemptTime = this.lastAttemptTime;
                }
                if (predicate.test(ret = supplier.get())) {
                    LOG.debug("Task {} is complete after {} iterations and it is ready to continue", (Object)this.getName(), (Object)this.budget.iteration());
                    this.status = Task.Status.Completed;
                    Optional<T> optional = Optional.ofNullable(ret);
                    return optional;
                }
                this.nextAttemptTime = this.lastAttemptTime + this.budget.interval();
                if (this.budget.canContinue()) {
                    Thread.sleep(this.budget.interval());
                    continue;
                }
                this.status = Task.Status.Exhausted;
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted {} while waiting for the repeatable task to finish", (Object)this.getName());
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.status = Task.Status.Failed;
            this.cause = e;
        }
        finally {
            this.elapsed = this.budget.elapsed();
            this.running.set(false);
            if (registry != null) {
                registry.removeTask(this);
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public Duration elapsed() {
        return this.elapsed;
    }

    @Override
    public int iteration() {
        return this.budget.iteration();
    }

    @Override
    public long getCurrentDelay() {
        return this.budget.interval();
    }

    public static class ForegroundTaskBuilder
    extends AbstractTaskBuilder<ForegroundTask> {
        private String name;
        private IterationBudget budget;

        public ForegroundTaskBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ForegroundTaskBuilder withBudget(IterationBudget budget) {
            this.budget = budget;
            return this;
        }

        @Override
        public ForegroundTask build() {
            return new ForegroundTask(this.budget, this.name != null ? this.name : this.getName());
        }
    }
}

