/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;

public class JmsTemporaryTopicEndpoint
extends JmsEndpoint
implements DestinationEndpoint {
    private Destination jmsDestination;

    public JmsTemporaryTopicEndpoint(String uri, JmsComponent component, String destination, JmsConfiguration configuration) {
        super(uri, component, destination, true, configuration);
    }

    public JmsTemporaryTopicEndpoint(String endpointUri, String destination) {
        super(endpointUri, destination);
        this.setDestinationType("temp-topic");
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public Destination getJmsDestination(Session session) throws JMSException {
        this.lock.lock();
        try {
            if (this.jmsDestination == null) {
                this.jmsDestination = this.createJmsDestination(session);
            }
            Destination destination = this.jmsDestination;
            return destination;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Destination createJmsDestination(Session session) throws JMSException {
        return session.createTemporaryTopic();
    }
}

