/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.trustmanager.CertificateChecker;

public class DateValidityChecker
implements CertificateChecker {
    public void invoke(X509Certificate cert, GSIConstants.CertificateType certType) throws CertPathValidatorException {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new CertPathValidatorException("Certificate " + cert.getSubjectDN() + " expired", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new CertPathValidatorException("Certificate " + cert.getSubjectDN() + " not yet valid.", e);
        }
    }
}

