/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.multimap.tx.TxnMultiMapOperation;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.collection.operations.CollectionResponse;
import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnLockAndGetOperation
extends CollectionKeyBasedOperation
implements WaitSupport,
TxnMultiMapOperation {
    long timeout;
    long ttl;
    int threadId;

    public TxnLockAndGetOperation() {
    }

    public TxnLockAndGetOperation(CollectionProxyId proxyId, Data dataKey, long timeout, long ttl, int threadId) {
        super(proxyId, dataKey);
        this.timeout = timeout;
        this.ttl = ttl;
        this.threadId = threadId;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer container = this.getOrCreateContainer();
        if (!container.txnLock(this.dataKey, this.getCallerUuid(), this.threadId, this.ttl)) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        CollectionWrapper wrapper = this.getOrCreateCollectionWrapper();
        this.response = new CollectionResponse(wrapper.getCollection()).setNextRecordId(container.nextId()).setTxVersion(wrapper.incrementAndGetVersion());
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:collectionService", this.proxyId), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        return !this.getOrCreateContainer().canAcquireLock(this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    public long getWaitTimeoutMillis() {
        return this.timeout;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timeout);
        out.writeLong(this.ttl);
        out.writeInt(this.threadId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timeout = in.readLong();
        this.ttl = in.readLong();
        this.threadId = in.readInt();
    }

    @Override
    public int getId() {
        return 30;
    }
}

