/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.transform.ModifyImageAttributeRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyImageAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<ModifyImageAttributeRequest> {
    private String imageId;
    private String attribute;
    private String operationType;
    private ListWithAutoConstructFlag<String> userIds;
    private ListWithAutoConstructFlag<String> userGroups;
    private ListWithAutoConstructFlag<String> productCodes;
    private String value;
    private LaunchPermissionModifications launchPermission;
    private String description;

    public ModifyImageAttributeRequest() {
    }

    public ModifyImageAttributeRequest(String imageId, String attribute) {
        this.setImageId(imageId);
        this.setAttribute(attribute);
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public ModifyImageAttributeRequest withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public ModifyImageAttributeRequest withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public ModifyImageAttributeRequest withOperationType(String operationType) {
        this.operationType = operationType;
        return this;
    }

    public List<String> getUserIds() {
        if (this.userIds == null) {
            this.userIds = new ListWithAutoConstructFlag();
            this.userIds.setAutoConstruct(true);
        }
        return this.userIds;
    }

    public void setUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
            return;
        }
        ListWithAutoConstructFlag userIdsCopy = new ListWithAutoConstructFlag(userIds.size());
        userIdsCopy.addAll(userIds);
        this.userIds = userIdsCopy;
    }

    public ModifyImageAttributeRequest withUserIds(String ... userIds) {
        if (this.getUserIds() == null) {
            this.setUserIds(new ArrayList<String>(userIds.length));
        }
        for (String value : userIds) {
            this.getUserIds().add(value);
        }
        return this;
    }

    public ModifyImageAttributeRequest withUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
        } else {
            ListWithAutoConstructFlag userIdsCopy = new ListWithAutoConstructFlag(userIds.size());
            userIdsCopy.addAll(userIds);
            this.userIds = userIdsCopy;
        }
        return this;
    }

    public List<String> getUserGroups() {
        if (this.userGroups == null) {
            this.userGroups = new ListWithAutoConstructFlag();
            this.userGroups.setAutoConstruct(true);
        }
        return this.userGroups;
    }

    public void setUserGroups(Collection<String> userGroups) {
        if (userGroups == null) {
            this.userGroups = null;
            return;
        }
        ListWithAutoConstructFlag userGroupsCopy = new ListWithAutoConstructFlag(userGroups.size());
        userGroupsCopy.addAll(userGroups);
        this.userGroups = userGroupsCopy;
    }

    public ModifyImageAttributeRequest withUserGroups(String ... userGroups) {
        if (this.getUserGroups() == null) {
            this.setUserGroups(new ArrayList<String>(userGroups.length));
        }
        for (String value : userGroups) {
            this.getUserGroups().add(value);
        }
        return this;
    }

    public ModifyImageAttributeRequest withUserGroups(Collection<String> userGroups) {
        if (userGroups == null) {
            this.userGroups = null;
        } else {
            ListWithAutoConstructFlag userGroupsCopy = new ListWithAutoConstructFlag(userGroups.size());
            userGroupsCopy.addAll(userGroups);
            this.userGroups = userGroupsCopy;
        }
        return this;
    }

    public List<String> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new ListWithAutoConstructFlag();
            this.productCodes.setAutoConstruct(true);
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<String> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        ListWithAutoConstructFlag productCodesCopy = new ListWithAutoConstructFlag(productCodes.size());
        productCodesCopy.addAll(productCodes);
        this.productCodes = productCodesCopy;
    }

    public ModifyImageAttributeRequest withProductCodes(String ... productCodes) {
        if (this.getProductCodes() == null) {
            this.setProductCodes(new ArrayList<String>(productCodes.length));
        }
        for (String value : productCodes) {
            this.getProductCodes().add(value);
        }
        return this;
    }

    public ModifyImageAttributeRequest withProductCodes(Collection<String> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
        } else {
            ListWithAutoConstructFlag productCodesCopy = new ListWithAutoConstructFlag(productCodes.size());
            productCodesCopy.addAll(productCodes);
            this.productCodes = productCodesCopy;
        }
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ModifyImageAttributeRequest withValue(String value) {
        this.value = value;
        return this;
    }

    public LaunchPermissionModifications getLaunchPermission() {
        return this.launchPermission;
    }

    public void setLaunchPermission(LaunchPermissionModifications launchPermission) {
        this.launchPermission = launchPermission;
    }

    public ModifyImageAttributeRequest withLaunchPermission(LaunchPermissionModifications launchPermission) {
        this.launchPermission = launchPermission;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ModifyImageAttributeRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public Request<ModifyImageAttributeRequest> getDryRunRequest() {
        Request<ModifyImageAttributeRequest> request = new ModifyImageAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageId() != null) {
            sb.append("ImageId: " + this.getImageId() + ",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: " + this.getAttribute() + ",");
        }
        if (this.getOperationType() != null) {
            sb.append("OperationType: " + this.getOperationType() + ",");
        }
        if (this.getUserIds() != null) {
            sb.append("UserIds: " + this.getUserIds() + ",");
        }
        if (this.getUserGroups() != null) {
            sb.append("UserGroups: " + this.getUserGroups() + ",");
        }
        if (this.getProductCodes() != null) {
            sb.append("ProductCodes: " + this.getProductCodes() + ",");
        }
        if (this.getValue() != null) {
            sb.append("Value: " + this.getValue() + ",");
        }
        if (this.getLaunchPermission() != null) {
            sb.append("LaunchPermission: " + this.getLaunchPermission() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getOperationType() == null ? 0 : this.getOperationType().hashCode());
        hashCode = 31 * hashCode + (this.getUserIds() == null ? 0 : this.getUserIds().hashCode());
        hashCode = 31 * hashCode + (this.getUserGroups() == null ? 0 : this.getUserGroups().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : this.getProductCodes().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPermission() == null ? 0 : this.getLaunchPermission().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyImageAttributeRequest)) {
            return false;
        }
        ModifyImageAttributeRequest other = (ModifyImageAttributeRequest)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getOperationType() == null ^ this.getOperationType() == null) {
            return false;
        }
        if (other.getOperationType() != null && !other.getOperationType().equals(this.getOperationType())) {
            return false;
        }
        if (other.getUserIds() == null ^ this.getUserIds() == null) {
            return false;
        }
        if (other.getUserIds() != null && !other.getUserIds().equals(this.getUserIds())) {
            return false;
        }
        if (other.getUserGroups() == null ^ this.getUserGroups() == null) {
            return false;
        }
        if (other.getUserGroups() != null && !other.getUserGroups().equals(this.getUserGroups())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !other.getProductCodes().equals(this.getProductCodes())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getLaunchPermission() == null ^ this.getLaunchPermission() == null) {
            return false;
        }
        if (other.getLaunchPermission() != null && !other.getLaunchPermission().equals(this.getLaunchPermission())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }
}

