/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.handlers;

import java.util.List;
import java.util.UUID;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.DBEventManagerConstants;
import org.apache.airavata.common.utils.DBEventService;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.client.CredentialStoreClientFactory;
import org.apache.airavata.credential.store.cpi.CredentialStoreService;
import org.apache.airavata.credential.store.exception.CredentialStoreException;
import org.apache.airavata.model.credential.store.PasswordCredential;
import org.apache.airavata.model.dbevent.CrudType;
import org.apache.airavata.model.dbevent.EntityType;
import org.apache.airavata.model.error.AuthorizationException;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.workspace.Gateway;
import org.apache.airavata.model.workspace.GatewayApprovalStatus;
import org.apache.airavata.service.profile.commons.tenant.entities.GatewayEntity;
import org.apache.airavata.service.profile.tenant.core.repositories.TenantProfileRepository;
import org.apache.airavata.service.profile.tenant.cpi.TenantProfileService;
import org.apache.airavata.service.profile.tenant.cpi.exception.TenantProfileServiceException;
import org.apache.airavata.service.profile.utils.ProfileServiceUtils;
import org.apache.airavata.service.security.interceptor.SecurityCheck;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantProfileServiceHandler
implements TenantProfileService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(TenantProfileServiceHandler.class);
    private TenantProfileRepository tenantProfileRepository;

    public TenantProfileServiceHandler() {
        logger.debug("Initializing TenantProfileServiceHandler");
        this.tenantProfileRepository = new TenantProfileRepository(Gateway.class, GatewayEntity.class);
    }

    @SecurityCheck
    public String getAPIVersion(AuthzToken authzToken) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            return "0.17";
        }
        catch (Exception ex) {
            logger.error("Error getting API version, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error getting API version, reason: " + ex.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public String addGateway(AuthzToken authzToken, Gateway gateway) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            gateway.setAiravataInternalGatewayId(UUID.randomUUID().toString());
            if (!this.checkDuplicateGateway(gateway)) {
                if (gateway.getIdentityServerPasswordToken() != null) {
                    this.copyAdminPasswordToGateway(authzToken, gateway);
                }
                if ((gateway = (Gateway)this.tenantProfileRepository.create((Object)gateway)) != null) {
                    logger.info("Added Airavata Gateway with Id: " + gateway.getGatewayId());
                    if (gateway.getGatewayApprovalStatus().equals((Object)GatewayApprovalStatus.APPROVED)) {
                        logger.info("Gateway with ID: {}, is now APPROVED, replicating to subscribers.", (Object)gateway.getGatewayId());
                        ProfileServiceUtils.getDbEventPublisher().publish(ProfileServiceUtils.getDBEventMessageContext(EntityType.TENANT, CrudType.CREATE, (TBase)gateway), DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
                    }
                    return gateway.getAiravataInternalGatewayId();
                }
                throw new Exception("Gateway object is null.");
            }
            throw new TenantProfileServiceException("An approved Gateway already exists with the same GatewayId, Name or URL");
        }
        catch (Exception ex) {
            logger.error("Error adding gateway-profile, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error adding gateway-profile, reason: " + ex.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateGateway(AuthzToken authzToken, Gateway updatedGateway) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            Gateway existingGateway = this.tenantProfileRepository.getGateway(updatedGateway.getAiravataInternalGatewayId());
            if (!(updatedGateway.getIdentityServerPasswordToken() == null || existingGateway.getIdentityServerPasswordToken() != null && existingGateway.getIdentityServerPasswordToken().equals(updatedGateway.getIdentityServerPasswordToken()))) {
                this.copyAdminPasswordToGateway(authzToken, updatedGateway);
            }
            if (this.tenantProfileRepository.update((Object)updatedGateway) != null) {
                logger.debug("Updated gateway-profile with ID: " + updatedGateway.getGatewayId());
                ProfileServiceUtils.getDbEventPublisher().publish(ProfileServiceUtils.getDBEventMessageContext(EntityType.TENANT, CrudType.UPDATE, (TBase)updatedGateway), DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            logger.error("Error updating gateway-profile, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error updating gateway-profile, reason: " + ex.getMessage());
            return false;
        }
    }

    @SecurityCheck
    public Gateway getGateway(AuthzToken authzToken, String airavataInternalGatewayId) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            Gateway gateway = this.tenantProfileRepository.getGateway(airavataInternalGatewayId);
            if (gateway == null) {
                throw new Exception("Could not find Gateway with internal ID: " + airavataInternalGatewayId);
            }
            return gateway;
        }
        catch (Exception ex) {
            logger.error("Error getting gateway-profile, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error getting gateway-profile, reason: " + ex.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteGateway(AuthzToken authzToken, String airavataInternalGatewayId, String gatewayId) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            logger.debug("Deleting Airavata gateway-profile with ID: " + gatewayId + "Internal ID: " + airavataInternalGatewayId);
            boolean deleteSuccess = this.tenantProfileRepository.delete((Object)airavataInternalGatewayId);
            if (deleteSuccess) {
                ProfileServiceUtils.getDbEventPublisher().publish(ProfileServiceUtils.getDBEventMessageContext(EntityType.TENANT, CrudType.DELETE, (TBase)new Gateway(gatewayId, GatewayApprovalStatus.DEACTIVATED)), DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
            }
            return deleteSuccess;
        }
        catch (Exception ex) {
            logger.error("Error deleting gateway-profile, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error deleting gateway-profile, reason: " + ex.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public List<Gateway> getAllGateways(AuthzToken authzToken) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            return this.tenantProfileRepository.getAllGateways();
        }
        catch (Exception ex) {
            logger.error("Error getting all gateway-profiles, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error getting all gateway-profiles, reason: " + ex.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean isGatewayExist(AuthzToken authzToken, String gatewayId) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            Gateway gateway = this.tenantProfileRepository.getGateway(gatewayId);
            return gateway != null;
        }
        catch (Exception ex) {
            logger.error("Error checking if gateway-profile exists, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error checking if gateway-profile exists, reason: " + ex.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public List<Gateway> getAllGatewaysForUser(AuthzToken authzToken, String requesterUsername) throws TenantProfileServiceException, AuthorizationException, TException {
        try {
            return this.tenantProfileRepository.getAllGatewaysForUser(requesterUsername);
        }
        catch (Exception ex) {
            logger.error("Error getting user's gateway-profiles, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error getting user's gateway-profiles, reason: " + ex.getMessage());
            throw exception;
        }
    }

    private boolean checkDuplicateGateway(Gateway gateway) throws TenantProfileServiceException {
        try {
            Gateway duplicateGateway = this.tenantProfileRepository.getDuplicateGateway(gateway.getGatewayId(), gateway.getGatewayName(), gateway.getGatewayURL());
            return duplicateGateway != null;
        }
        catch (Exception ex) {
            logger.error("Error checking if duplicate gateway-profile exists, reason: " + ex.getMessage(), (Throwable)ex);
            TenantProfileServiceException exception = new TenantProfileServiceException();
            exception.setMessage("Error checking if duplicate gateway-profiles exists, reason: " + ex.getMessage());
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAdminPasswordToGateway(AuthzToken authzToken, Gateway gateway) throws TException, ApplicationSettingsException {
        CredentialStoreService.Client csClient = this.getCredentialStoreServiceClient();
        try {
            String requestGatewayId = (String)authzToken.getClaimsMap().get("gatewayID");
            PasswordCredential adminPasswordCredential = csClient.getPasswordCredential(gateway.getIdentityServerPasswordToken(), requestGatewayId);
            adminPasswordCredential.setGatewayId(gateway.getGatewayId());
            String newAdminPasswordCredentialToken = csClient.addPasswordCredential(adminPasswordCredential);
            gateway.setIdentityServerPasswordToken(newAdminPasswordCredentialToken);
        }
        finally {
            if (csClient.getInputProtocol().getTransport().isOpen()) {
                csClient.getInputProtocol().getTransport().close();
            }
            if (csClient.getOutputProtocol().getTransport().isOpen()) {
                csClient.getOutputProtocol().getTransport().close();
            }
        }
    }

    private CredentialStoreService.Client getCredentialStoreServiceClient() throws TException, ApplicationSettingsException {
        int serverPort = Integer.parseInt(ServerSettings.getCredentialStoreServerPort());
        String serverHost = ServerSettings.getCredentialStoreServerHost();
        try {
            return CredentialStoreClientFactory.createAiravataCSClient((String)serverHost, (int)serverPort);
        }
        catch (CredentialStoreException e) {
            throw new TException("Unable to create credential store client...", (Throwable)e);
        }
    }
}

