/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.indexdeletionpolicy;

import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.indexdeletionpolicy.DirectoryConfigurable;
import org.compass.core.lucene.engine.indexdeletionpolicy.ExpirationTimeDeletionPolicy;
import org.compass.core.lucene.engine.indexdeletionpolicy.KeepAllDeletionPolicy;
import org.compass.core.lucene.engine.indexdeletionpolicy.KeepLastNDeletionPolicy;
import org.compass.core.lucene.engine.indexdeletionpolicy.KeepNoneOnInitDeletionPolicy;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.util.ClassUtils;

public class IndexDeletionPolicyFactory
implements CompassConfigurable {
    private LuceneSearchEngineIndexManager indexManager;
    private CompassSettings settings;
    private IndexDeletionPolicy globalIndexDeletionPolicy;

    public IndexDeletionPolicyFactory(LuceneSearchEngineIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
    }

    public IndexDeletionPolicy createIndexDeletionPolicy(Directory dir) throws SearchEngineException {
        if (this.globalIndexDeletionPolicy != null) {
            return this.globalIndexDeletionPolicy;
        }
        String indexDeletionPolicyType = this.settings.getSetting("compass.engine.store.indexDeletionPolicy.type", this.indexManager.getStore().suggestedIndexDeletionPolicy());
        if (indexDeletionPolicyType == null) {
            indexDeletionPolicyType = "keeplastcommit";
        }
        if ("keeplastcommit".equalsIgnoreCase(indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepOnlyLastCommitDeletionPolicy();
        } else if ("keeplastn".equalsIgnoreCase(indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepLastNDeletionPolicy();
        } else if ("keepall".equalsIgnoreCase(indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepAllDeletionPolicy();
        } else if ("keepnoneoninit".equalsIgnoreCase(indexDeletionPolicyType)) {
            this.globalIndexDeletionPolicy = new KeepNoneOnInitDeletionPolicy();
        }
        if (this.globalIndexDeletionPolicy != null) {
            if (this.globalIndexDeletionPolicy instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)this.globalIndexDeletionPolicy)).configure(this.settings);
            }
            return this.globalIndexDeletionPolicy;
        }
        if ("expirationtime".equalsIgnoreCase(indexDeletionPolicyType)) {
            ExpirationTimeDeletionPolicy indexDeletionPolicy = new ExpirationTimeDeletionPolicy();
            indexDeletionPolicy.setDirectory(dir);
            indexDeletionPolicy.configure(this.settings);
            return indexDeletionPolicy;
        }
        try {
            IndexDeletionPolicy indexDeletionPolicy = (IndexDeletionPolicy)ClassUtils.forName(indexDeletionPolicyType, this.settings.getClassLoader()).newInstance();
            if (indexDeletionPolicy instanceof DirectoryConfigurable) {
                ((DirectoryConfigurable)((Object)indexDeletionPolicy)).setDirectory(dir);
            }
            if (indexDeletionPolicy instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)indexDeletionPolicy)).configure(this.settings);
            }
            return indexDeletionPolicy;
        }
        catch (Exception e) {
            throw new SearchEngineException("Failed to create custom index deletion policy [" + indexDeletionPolicyType + "]", e);
        }
    }
}

