/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizer;
import org.compass.core.transaction.context.TransactionContextCallback;

public abstract class AbstractOptimizer
implements LuceneSearchEngineOptimizer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private LuceneSearchEngineFactory searchEngineFactory;
    private volatile boolean isRunning = false;

    public void start() throws SearchEngineException {
        if (this.isRunning) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Starting Optimizer");
        }
        this.doStart();
        this.isRunning = true;
    }

    protected void doStart() throws SearchEngineException {
    }

    public void stop() throws SearchEngineException {
        if (!this.isRunning) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopping Optimizer");
        }
        this.doStop();
        this.isRunning = false;
    }

    protected void doStop() throws SearchEngineException {
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void optimize() throws SearchEngineException {
        String[] subIndexes;
        LuceneSearchEngineIndexManager indexManager = this.searchEngineFactory.getLuceneIndexManager();
        for (String subIndex : subIndexes = indexManager.getStore().getSubIndexes()) {
            this.optimize(subIndex);
        }
    }

    public void optimize(final String subIndex) throws SearchEngineException {
        if (!this.isRunning()) {
            return;
        }
        this.searchEngineFactory.getTransactionContext().execute(new TransactionContextCallback<Object>(){

            @Override
            public Object doInTransaction() throws CompassException {
                AbstractOptimizer.this.doOptimize(subIndex);
                AbstractOptimizer.this.searchEngineFactory.getIndexManager().refreshCache(subIndex);
                return null;
            }
        });
    }

    protected abstract void doOptimize(String var1) throws SearchEngineException;

    protected LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public void setSearchEngineFactory(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }
}

