/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.compass.core.util.Assert;
import org.compass.gps.CompassGpsException;
import org.compass.gps.PassiveMirrorGpsDevice;
import org.compass.gps.device.jpa.DefaultEntityManagerWrapper;
import org.compass.gps.device.jpa.EntityManagerWrapper;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.NativeJpaExtractor;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocatorDetector;
import org.compass.gps.device.jpa.indexer.JpaIndexEntitiesIndexer;
import org.compass.gps.device.jpa.indexer.JpaIndexEntitiesIndexerDetector;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjectorDetector;
import org.compass.gps.device.jpa.queryprovider.DefaultJpaQueryProvider;
import org.compass.gps.device.jpa.queryprovider.JpaQueryProvider;
import org.compass.gps.device.jpa.support.NativeJpaHelper;
import org.compass.gps.device.support.parallel.AbstractParallelGpsDevice;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaGpsDevice
extends AbstractParallelGpsDevice
implements PassiveMirrorGpsDevice {
    private boolean mirrorDataChanges = true;
    private int fetchCount = 200;
    private EntityManagerFactory entityManagerFactory;
    private EntityManagerWrapper entityManagerWrapper;
    private JpaEntityLifecycleInjector lifecycleInjector;
    private boolean injectEntityLifecycleListener;
    private NativeJpaExtractor nativeJpaExtractor;
    private EntityManagerFactory nativeEntityManagerFactory;
    private JpaEntitiesLocator entitiesLocator;
    private Map<Class<?>, JpaQueryProvider> queryProviderByClass = new HashMap();
    private Map<String, JpaQueryProvider> queryProviderByName = new HashMap<String, JpaQueryProvider>();
    private JpaIndexEntitiesIndexer entitiesIndexer;

    public JpaGpsDevice() {
    }

    public JpaGpsDevice(String name, EntityManagerFactory entityManagerFactory) {
        this.setName(name);
        this.setEntityManagerFactory(entityManagerFactory);
    }

    @Override
    protected void doStart() throws CompassGpsException {
        Assert.notNull(this.entityManagerFactory, this.buildMessage("Must set JPA EntityManagerFactory"));
        if (this.entityManagerWrapper == null) {
            this.entityManagerWrapper = new DefaultEntityManagerWrapper();
        }
        this.entityManagerWrapper.setUp(this.entityManagerFactory);
        this.nativeEntityManagerFactory = this.entityManagerFactory;
        if (this.nativeJpaExtractor != null) {
            this.nativeEntityManagerFactory = this.nativeJpaExtractor.extractNative(this.nativeEntityManagerFactory);
            if (this.nativeEntityManagerFactory == null) {
                throw new JpaGpsDeviceException(this.buildMessage("Native EntityManager extractor returned null"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using native EntityManagerFactory [" + this.nativeEntityManagerFactory.getClass().getName() + "] extracted by [" + this.nativeJpaExtractor.getClass().getName() + "]"));
            }
        } else {
            this.nativeEntityManagerFactory = NativeJpaHelper.extractNativeJpa(this.entityManagerFactory, this.compassGps.getMirrorCompass().getSettings());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using native EntityManagerFactory [" + this.nativeEntityManagerFactory.getClass().getName() + "] using default extractor"));
            }
        }
        if (this.entitiesLocator == null) {
            this.entitiesLocator = JpaEntitiesLocatorDetector.detectLocator(this.nativeEntityManagerFactory, this.compassGps.getMirrorCompass().getSettings());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using index entityLocator [" + this.entitiesLocator.getClass().getName() + "]"));
            }
        }
        if (this.injectEntityLifecycleListener && this.mirrorDataChanges) {
            if (this.lifecycleInjector == null) {
                this.lifecycleInjector = JpaEntityLifecycleInjectorDetector.detectInjector(this.nativeEntityManagerFactory, this.compassGps.getMirrorCompass().getSettings());
            }
            if (this.lifecycleInjector == null) {
                throw new JpaGpsDeviceException(this.buildMessage("Failed to locate lifecycleInjector"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using lifecycleInjector [" + this.lifecycleInjector.getClass().getName() + "]"));
            }
            this.lifecycleInjector.injectLifecycle(this.nativeEntityManagerFactory, this);
        }
        if (this.entitiesIndexer == null) {
            this.entitiesIndexer = JpaIndexEntitiesIndexerDetector.detectEntitiesIndexer(this.nativeEntityManagerFactory, this.compassGps.getMirrorCompass().getSettings());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.buildMessage("Using entities indexer [" + this.entitiesIndexer.getClass().getName() + "]"));
        }
        this.entitiesIndexer.setJpaGpsDevice(this);
    }

    @Override
    protected void doStop() throws CompassGpsException {
        if (this.injectEntityLifecycleListener && this.mirrorDataChanges) {
            this.lifecycleInjector.removeLifecycle(this.nativeEntityManagerFactory, this);
        }
    }

    @Override
    protected IndexEntity[] doGetIndexEntities() throws CompassGpsException {
        IndexEntity[] entitiesInformation;
        for (IndexEntity entityInformation : entitiesInformation = this.entitiesLocator.locate(this.nativeEntityManagerFactory, this)) {
            if (this.queryProviderByClass.get(((EntityInformation)entityInformation).getEntityClass()) != null) {
                ((EntityInformation)entityInformation).setQueryProvider(this.queryProviderByClass.get(((EntityInformation)entityInformation).getEntityClass()));
            }
            if (this.queryProviderByName.get(((EntityInformation)entityInformation).getName()) == null) continue;
            ((EntityInformation)entityInformation).setQueryProvider(this.queryProviderByName.get(((EntityInformation)entityInformation).getName()));
        }
        return entitiesInformation;
    }

    @Override
    protected IndexEntitiesIndexer doGetIndexEntitiesIndexer() {
        return this.entitiesIndexer;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public EntityManagerFactory getNativeEntityManagerFactory() {
        return this.nativeEntityManagerFactory;
    }

    @Override
    public boolean isMirrorDataChanges() {
        return this.mirrorDataChanges;
    }

    @Override
    public void setMirrorDataChanges(boolean mirrorDataChanges) {
        this.mirrorDataChanges = mirrorDataChanges;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setEntityManagerWrapper(EntityManagerWrapper entityManagerWrapper) {
        this.entityManagerWrapper = entityManagerWrapper;
    }

    public EntityManagerWrapper getEntityManagerWrapper() {
        return this.entityManagerWrapper;
    }

    public void setNativeExtractor(NativeJpaExtractor nativeJpaExtractor) {
        this.nativeJpaExtractor = nativeJpaExtractor;
    }

    public NativeJpaExtractor getNativeJpaExtractor() {
        return this.nativeJpaExtractor;
    }

    public void setInjectEntityLifecycleListener(boolean injectEntityLifecycleListener) {
        this.injectEntityLifecycleListener = injectEntityLifecycleListener;
    }

    public void setLifecycleInjector(JpaEntityLifecycleInjector lifecycleInjector) {
        this.lifecycleInjector = lifecycleInjector;
    }

    public void setEntitiesLocator(JpaEntitiesLocator entitiesLocator) {
        this.entitiesLocator = entitiesLocator;
    }

    public void setFetchCount(int fetchCount) {
        this.fetchCount = fetchCount;
    }

    public int getFetchCount() {
        return this.fetchCount;
    }

    public void setIndexSelectQuery(Class<?> entityClass, String selectQuery) {
        this.setIndexQueryProvider(entityClass, (JpaQueryProvider)new DefaultJpaQueryProvider(selectQuery));
    }

    public void setIndexSelectQuery(String entityName, String selectQuery) {
        this.setIndexQueryProvider(entityName, (JpaQueryProvider)new DefaultJpaQueryProvider(selectQuery));
    }

    public void setIndexQueryProvider(Class<?> entityClass, JpaQueryProvider queryProvider) {
        this.queryProviderByClass.put(entityClass, queryProvider);
    }

    public void setIndexQueryProvider(String entityName, JpaQueryProvider queryProvider) {
        this.queryProviderByName.put(entityName, queryProvider);
    }

    public void setEntitiesIndexer(JpaIndexEntitiesIndexer entitiesIndexer) {
        this.entitiesIndexer = entitiesIndexer;
    }
}

