/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SpaceFinder;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectory;

public class GigaSpaceDirectoryStore
extends AbstractDirectoryStore
implements CompassConfigurable {
    public static final String PROTOCOL = "space://";
    public static final String BUCKET_SIZE_PROP = "compass.engine.store.space.bucketSize";
    public static final String FLUSH_RATE_PROP = "compass.engine.store.space.flushRate";
    private String indexName;
    private IJSpace space;
    private int bucketSize;
    private int flushRate;

    public void configure(CompassSettings settings) throws CompassException {
        String connection = settings.getSetting("compass.engine.connection").substring(PROTOCOL.length());
        int index = connection.indexOf(58);
        this.indexName = connection.substring(0, index);
        String spaceUrl = connection.substring(index + 1);
        this.bucketSize = settings.getSettingAsInt(BUCKET_SIZE_PROP, 20480);
        this.flushRate = settings.getSettingAsInt(FLUSH_RATE_PROP, 50);
        try {
            this.space = (IJSpace)SpaceFinder.find((String)spaceUrl, (Properties)settings.getProperties());
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to find Space [" + spaceUrl + "]", e);
        }
    }

    public Directory open(String subContext, String subIndex) throws SearchEngineException {
        return new GigaSpaceDirectory(this.space, this.buildFullIndexName(subContext, subIndex), this.bucketSize, this.flushRate);
    }

    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        this.cleanIndex(dir, subContext, subIndex);
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        try {
            ((GigaSpaceDirectory)dir).deleteContent();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete index for sub context [" + subContext + "] and sub index [" + subIndex + "]", e);
        }
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        try {
            ((GigaSpaceDirectory)dir).deleteContent();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete context before copy from", e);
        }
        return new CopyFromHolder();
    }

    private String buildFullIndexName(String subContext, String subIndex) {
        return this.indexName + "/" + subContext + "/" + subIndex;
    }

    public String suggestedIndexDeletionPolicy() {
        return "expirationtime";
    }
}

