/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dataaccess.DAOManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCCommentsDAO;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataobjects.CommentDO;
import org.wso2.carbon.registry.core.pagination.PaginationConstants;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.DBUtils;

public class JDBCCommentsVersionDAO
extends JDBCCommentsDAO
implements CommentsDAO {
    private static final Log log = LogFactory.getLog(JDBCCommentsVersionDAO.class);
    private ResourceDAO resourceDAO;
    private String enableApiPagination = PaginationConstants.ENABLE_API_PAGINATE;

    public JDBCCommentsVersionDAO(DAOManager daoManager) {
        super(daoManager);
        this.resourceDAO = daoManager.getResourceDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addComment(ResourceImpl resource, String userID, Comment comment) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps1 = null;
        Statement ps2 = null;
        Statement ps3 = null;
        int commentId = -1;
        try {
            ResultSet resultSet1;
            String sql1 = "INSERT INTO REG_COMMENT (REG_COMMENT_TEXT,REG_USER_ID, REG_COMMENTED_TIME, REG_TENANT_ID) VALUES (?, ?, ?, ?)";
            String sql2 = "SELECT MAX(REG_ID) FROM REG_COMMENT";
            String sql3 = "INSERT INTO REG_RESOURCE_COMMENT (REG_COMMENT_ID, REG_VERSION, REG_TENANT_ID) VALUES (?, ?, ?)";
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps1 = returnsGeneratedKeys ? conn.prepareStatement(sql1, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_ID")}) : conn.prepareStatement(sql1);
            ps3 = conn.prepareStatement(sql3);
            ps1.setString(1, comment.getText());
            ps1.setString(2, userID);
            long now = System.currentTimeMillis();
            ps1.setTimestamp(3, new Timestamp(now));
            ps1.setInt(4, CurrentSession.getTenantId());
            if (returnsGeneratedKeys) {
                ps1.executeUpdate();
                resultSet1 = ps1.getGeneratedKeys();
            } else {
                Object object = ADD_COMMENT_LOCK;
                synchronized (object) {
                    ps1.executeUpdate();
                    ps2 = conn.prepareStatement(sql2);
                    resultSet1 = ps2.executeQuery();
                }
            }
            try {
                if (resultSet1.next()) {
                    commentId = resultSet1.getInt(1);
                    ps3.setInt(1, commentId);
                    ps3.setLong(2, resource.getVersionNumber());
                    ps3.setInt(3, CurrentSession.getTenantId());
                    ps3.executeUpdate();
                }
            }
            finally {
                if (resultSet1 != null) {
                    resultSet1.close();
                }
            }
        }
        catch (SQLException e) {
            String msg = "Failed to add comments to the resource " + resource.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
                finally {
                    try {
                        if (ps2 != null) {
                            ps2.close();
                        }
                    }
                    finally {
                        if (ps3 != null) {
                            ps3.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return commentId;
    }

    @Override
    public void copyComments(ResourceImpl sourceResource, ResourceImpl targetResource) throws RegistryException {
        Comment[] comments = this.getComments(sourceResource);
        CommentDO[] commentDOs = new CommentDO[comments.length];
        for (int i = 0; i < comments.length; ++i) {
            CommentDO commentDO = new CommentDO();
            commentDO.setCommentedUser(comments[i].getUser());
            commentDO.setCommentText(comments[i].getText());
            commentDOs[i] = commentDO;
        }
        this.addComments(targetResource, commentDOs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComments(ResourceImpl resource, CommentDO[] commentDOs) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps1 = null;
        Statement ps2 = null;
        Statement ps3 = null;
        try {
            String sql1 = "INSERT INTO REG_COMMENT (REG_COMMENT_TEXT,REG_USER_ID, REG_COMMENTED_TIME, REG_TENANT_ID) VALUES (?, ?, ?, ?)";
            String sql2 = "SELECT MAX(REG_ID) FROM REG_COMMENT";
            String sql3 = "INSERT INTO REG_RESOURCE_COMMENT (REG_COMMENT_ID, REG_VERSION, REG_TENANT_ID) VALUES (?, ?, ?)";
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps1 = returnsGeneratedKeys ? conn.prepareStatement(sql1, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_ID")}) : conn.prepareStatement(sql1);
            ps3 = conn.prepareStatement(sql3);
            for (CommentDO comment : commentDOs) {
                ResultSet resultSet1;
                ps1.setString(1, comment.getCommentText());
                ps1.setString(2, comment.getCommentedUser());
                long now = System.currentTimeMillis();
                ps1.setTimestamp(3, new Timestamp(now));
                ps1.setInt(4, CurrentSession.getTenantId());
                if (returnsGeneratedKeys) {
                    ps1.executeUpdate();
                    resultSet1 = ps1.getGeneratedKeys();
                } else {
                    Object object = ADD_COMMENT_LOCK;
                    synchronized (object) {
                        ps1.executeUpdate();
                        ps2 = conn.prepareStatement(sql2);
                        resultSet1 = ps2.executeQuery();
                    }
                }
                try {
                    if (resultSet1.next()) {
                        int commentId = resultSet1.getInt(1);
                        ps3.setInt(1, commentId);
                        ps3.setLong(2, resource.getVersionNumber());
                        ps3.setInt(3, CurrentSession.getTenantId());
                        ps3.executeUpdate();
                        ps3.clearParameters();
                    }
                }
                finally {
                    if (resultSet1 != null) {
                        resultSet1.close();
                    }
                }
                ps3.clearParameters();
            }
        }
        catch (SQLException e) {
            String msg = "Failed to add comments to the resource " + resource.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
                finally {
                    try {
                        if (ps2 != null) {
                            ps2.close();
                        }
                    }
                    finally {
                        if (ps3 != null) {
                            ps3.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment[] getComments(ResourceImpl resource) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            if (dbName.contains("Microsoft") || dbName.equals("Oracle")) {
                this.enableApiPagination = "false";
            }
        }
        catch (SQLException e) {
            throw new RegistryException("Failed to get Database product name ", e);
        }
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        Statement s = null;
        ResultSet results = null;
        String path = resource.getPath();
        boolean paginated = false;
        int start = 0;
        int count = 0;
        String sortOrder = "";
        String sortBy = "";
        MessageContext messageContext = null;
        if ((this.enableApiPagination == null || this.enableApiPagination.equals("true")) && (messageContext = MessageContext.getCurrentMessageContext()) != null && PaginationUtils.isPaginationHeadersExist(messageContext)) {
            PaginationContext paginationContext = PaginationUtils.initPaginationContext(messageContext);
            start = paginationContext.getStart();
            if (start == 0) {
                start = 1;
            }
            count = paginationContext.getCount();
            sortBy = paginationContext.getSortBy();
            sortOrder = paginationContext.getSortOrder();
            paginated = true;
        }
        try {
            String sql = "SELECT C.REG_ID, C.REG_COMMENT_TEXT, C.REG_USER_ID, C.REG_COMMENTED_TIME FROM REG_COMMENT C, REG_RESOURCE_COMMENT RC WHERE C.REG_ID=RC.REG_COMMENT_ID AND RC.REG_VERSION = ? AND C.REG_TENANT_ID=? AND RC.REG_TENANT_ID=?";
            if (paginated && !"".equals(sortBy) && !"".equals(sortOrder)) {
                sql = sql + " ORDER BY " + sortBy + " " + sortOrder;
            }
            s = this.enableApiPagination == null || this.enableApiPagination.equals("true") ? conn.prepareStatement(sql, 1004, 1008) : conn.prepareStatement(sql);
            s.setLong(1, resource.getVersionNumber());
            s.setInt(2, CurrentSession.getTenantId());
            s.setInt(3, CurrentSession.getTenantId());
            results = s.executeQuery();
            if (paginated) {
                if (results.relative(start)) {
                    results.previous();
                    for (int i = 0; results.next() && i < count; ++i) {
                        commentList.add(this.getComment(results, path));
                    }
                } else {
                    log.debug((Object)"start index doesn't exist in the result set");
                }
                if (results.last()) {
                    log.debug((Object)"cursor move to the last index of result set");
                } else {
                    log.debug((Object)"cursor doesn't move to the last index of result set");
                }
                PaginationUtils.setRowCount(messageContext, Integer.toString(results.getRow()));
            } else {
                while (results.next()) {
                    commentList.add(this.getComment(results, path));
                }
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get comments on resource " + path + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return commentList.toArray(new Comment[commentList.size()]);
    }

    private Comment getComment(ResultSet results, String path) throws SQLException {
        Comment comment = new Comment();
        comment.setText(results.getString("REG_COMMENT_TEXT"));
        comment.setUser(results.getString("REG_USER_ID"));
        comment.setCreatedTime(results.getTimestamp("REG_COMMENTED_TIME"));
        comment.setResourcePath(path);
        String commentPath = path + ";" + "comments:" + results.getInt("REG_ID");
        comment.setPath(commentPath);
        comment.setCommentPath(commentPath);
        comment.setParentPath(path + ";" + "comments");
        comment.setCommentID(results.getLong("REG_ID"));
        return comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getResourcePathsOfComments(Long[] commentIDs, Connection conn) throws RegistryException {
        if (commentIDs.length == 0) {
            return new String[0];
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT DISTINCT RC.REG_COMMENT_ID, RC.REG_VERSION FROM REG_RESOURCE_COMMENT RC WHERE (");
        for (int i = 0; i < commentIDs.length; ++i) {
            if (i > 0) {
                sqlBuf.append(" OR ");
            }
            sqlBuf.append("RC.REG_COMMENT_ID=?");
        }
        sqlBuf.append(") AND RC.REG_TENANT_ID=?");
        ArrayList<String> commentPathList = new ArrayList<String>();
        ResultSet results = null;
        PreparedStatement s = null;
        try {
            int i;
            s = conn.prepareStatement(sqlBuf.toString());
            for (i = 0; i < commentIDs.length; ++i) {
                s.setLong(i + 1, commentIDs[i]);
            }
            s.setInt(i + 1, CurrentSession.getTenantId());
            results = s.executeQuery();
            while (results.next()) {
                String path;
                long commentID = results.getLong("REG_COMMENT_ID");
                long version = results.getLong("REG_VERSION");
                if (version <= 0L || (path = this.resourceDAO.getPath(version)) == null) continue;
                String commentPath = path + ";" + "comments:" + commentID;
                commentPathList.add(commentPath);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get the resource for the set of comment ids." + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return commentPathList.toArray(new String[commentPathList.size()]);
    }

    @Override
    public ResourceImpl getResourceWithMinimumData(String path) throws RegistryException {
        return RegistryUtils.getResourceWithMinimumData(path, this.resourceDAO, true);
    }

    @Override
    public void moveComments(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
    }

    @Override
    public void moveCommentPaths(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
    }
}

