/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryClientUtils {
    private static final Log log = LogFactory.getLog(RegistryClientUtils.class);

    public static void importToRegistry(File file, String path, Registry registry) throws RegistryException {
        try {
            if (file == null || path == null) {
                throw new RegistryException("The values of the mandatory parameters, file and path cannot be null.");
            }
            RegistryClientUtils.processImport(file, path, registry);
        }
        catch (Exception e) {
            log.error((Object)"Failed to import to registry", (Throwable)e);
            throw new RegistryException("Failed to import to registry", e);
        }
    }

    public static void exportFromRegistry(File toFile, String path, Registry registry) throws RegistryException {
        try {
            RegistryClientUtils.processExport(path, toFile, registry, true);
        }
        catch (Exception e) {
            log.error((Object)"Failed to export from registry", (Throwable)e);
            throw new RegistryException("Failed to export from registry", e);
        }
    }

    private static void processImport(File file, String path, Registry registry) throws Exception {
        String filePart = file.getName();
        String resourcePath = path + "/" + filePart;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files.length > 0) {
                for (File childFile : files) {
                    RegistryClientUtils.processImport(childFile, resourcePath, registry);
                }
            } else {
                CollectionImpl resource = new CollectionImpl();
                resource.setPath(resourcePath);
                registry.put(resourcePath, resource);
            }
        } else {
            ResourceImpl resource = new ResourceImpl();
            resource.setContent(new FileInputStream(file));
            resource.setPath(resourcePath);
            registry.put(resourcePath, resource);
        }
    }

    private static void processExport(String fromPath, File toFile, Registry registry, boolean useOriginal) throws RegistryException {
        Resource resource = registry.get(fromPath);
        if (resource != null) {
            File tempFile;
            String resourcePath = resource.getPath();
            int versionIndex = resourcePath.lastIndexOf(";version:");
            if (versionIndex > 0) {
                resourcePath = resourcePath.substring(0, versionIndex);
            }
            int slashIndex = resourcePath.lastIndexOf(47);
            resourcePath = resourcePath.substring(slashIndex, resourcePath.length());
            if (!useOriginal) {
                tempFile = new File(toFile, resourcePath);
                if (!tempFile.exists() && resource instanceof Collection) {
                    boolean ignore = tempFile.mkdirs();
                }
            } else {
                tempFile = toFile;
            }
            if (resource instanceof Collection) {
                String[] childNodes = (String[])resource.getContent();
                ArrayList<String> tobeDeleted = new ArrayList<String>();
                String[] files = tempFile.list();
                if (files != null) {
                    for (String file : files) {
                        tobeDeleted.add("/" + file);
                    }
                }
                for (String childNode : childNodes) {
                    versionIndex = childNode.lastIndexOf(";version:");
                    if (versionIndex > 0) {
                        childNode = childNode.substring(0, versionIndex);
                    }
                    if (!tobeDeleted.contains(childNode = childNode.substring(slashIndex = childNode.lastIndexOf(47), childNode.length()))) continue;
                    slashIndex = childNode.lastIndexOf(47);
                    File deleteFile = new File(tempFile, childNode = childNode.substring(slashIndex, childNode.length()));
                    if (deleteFile.exists() && deleteFile.isDirectory()) {
                        RegistryClientUtils.deleteDir(deleteFile);
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)("Deleting a directory : " + deleteFile.getPath()));
                        continue;
                    }
                    boolean ignore = deleteFile.delete();
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Deleting a file : " + deleteFile.getPath()));
                }
                for (String childNode : childNodes) {
                    RegistryClientUtils.processExport(childNode, tempFile, registry, false);
                }
            } else {
                try {
                    FileOutputStream out = new FileOutputStream(tempFile);
                    out.write((byte[])resource.getContent());
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new RegistryException("An error occurred while creating the file: " + tempFile.getAbsolutePath(), e);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No resource found for : " + fromPath));
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String aChildren : children = dir.list()) {
                boolean success = RegistryClientUtils.deleteDir(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

