/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.lang.reflect.Modifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassStrategy;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.DiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.StrategyInstaller;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneFieldStrategy;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.MetaDataException;

public class RuntimeStrategyInstaller
extends StrategyInstaller {
    private static final Localizer _loc = Localizer.forPackage(RuntimeStrategyInstaller.class);

    public RuntimeStrategyInstaller(MappingRepository repos) {
        super(repos);
    }

    @Override
    public void installStrategy(ClassMapping cls) {
        if ((cls.getSourceMode() & 2) == 0) {
            throw new MetaDataException(_loc.get("no-mapping", cls));
        }
        ClassStrategy strat = this.repos.namedStrategy(cls);
        if (strat == null) {
            strat = this.repos.defaultStrategy(cls, false);
        }
        cls.setStrategy(strat, Boolean.FALSE);
    }

    @Override
    public void installStrategy(FieldMapping field) {
        FieldStrategy strategy = null;
        ClassMapping owner = this.getOutermostDefiningMapping(field);
        if (owner != null && !owner.isEmbeddable() && !owner.isAbstract()) {
            strategy = this.repos.namedStrategy(field, true);
        }
        if (strategy == null) {
            try {
                strategy = this.repos.defaultStrategy(field, true, false);
            }
            catch (MetaDataException mde) {
                Class<?> cls = field.getDefiningMetaData().getDescribedType();
                if (!Modifier.isAbstract(cls.getModifiers()) || field.getMappedBy() != null || field.getMappingInfo().hasSchemaComponents() || field.getValueInfo().hasSchemaComponents() || field.getElementMapping().getValueInfo().hasSchemaComponents() || field.getKeyMapping().getValueInfo().hasSchemaComponents()) {
                    throw mde;
                }
                strategy = NoneFieldStrategy.getInstance();
            }
        }
        field.setStrategy(strategy, Boolean.FALSE);
    }

    private ClassMapping getOutermostDefiningMapping(ValueMetaData vm) {
        if (vm instanceof FieldMapping) {
            ClassMapping owner = ((FieldMapping)vm).getDefiningMapping();
            ValueMetaData val = owner.getEmbeddingMetaData();
            if (val == null) {
                return owner;
            }
            return this.getOutermostDefiningMapping(val);
        }
        if (vm instanceof ValueMappingImpl) {
            FieldMapping owner = ((ValueMappingImpl)vm).getFieldMapping();
            return this.getOutermostDefiningMapping(owner);
        }
        return null;
    }

    @Override
    public void installStrategy(Version version) {
        VersionStrategy strat = this.repos.namedStrategy(version);
        if (strat == null) {
            strat = this.repos.defaultStrategy(version, false);
        }
        version.setStrategy(strat, Boolean.FALSE);
    }

    @Override
    public void installStrategy(Discriminator discrim) {
        DiscriminatorStrategy strat = this.repos.namedStrategy(discrim);
        if (strat == null) {
            strat = this.repos.defaultStrategy(discrim, false);
        }
        discrim.setStrategy(strat, Boolean.FALSE);
    }
}

