/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.AbstractFileTransfer;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.FileTransfer;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;

public class SFTPFileTransfer
extends AbstractFileTransfer
implements FileTransfer {
    private final SFTPEngine engine;
    private volatile LocalFileFilter uploadFilter;
    private volatile RemoteResourceFilter downloadFilter;

    public SFTPFileTransfer(SFTPEngine engine) {
        this.engine = engine;
    }

    @Override
    public void upload(String source, String dest) throws IOException {
        new Uploader().upload(new FileSystemFile(source), dest);
    }

    @Override
    public void download(String source, String dest) throws IOException {
        this.download(source, new FileSystemFile(dest));
    }

    @Override
    public void upload(LocalSourceFile localFile, String remotePath) throws IOException {
        new Uploader().upload(localFile, remotePath);
    }

    @Override
    public void download(String source, LocalDestFile dest) throws IOException {
        PathComponents pathComponents = this.engine.getPathHelper().getComponents(source);
        FileAttributes attributes = this.engine.stat(source);
        new Downloader().download(new RemoteResourceInfo(pathComponents, attributes), dest);
    }

    public void setUploadFilter(LocalFileFilter uploadFilter) {
        this.uploadFilter = uploadFilter;
    }

    public void setDownloadFilter(RemoteResourceFilter downloadFilter) {
        this.downloadFilter = downloadFilter;
    }

    public LocalFileFilter getUploadFilter() {
        return this.uploadFilter;
    }

    public RemoteResourceFilter getDownloadFilter() {
        return this.downloadFilter;
    }

    private class Uploader {
        private final TransferListener listener;

        private Uploader() {
            this.listener = SFTPFileTransfer.this.getTransferListener();
        }

        private void upload(LocalSourceFile local, String remote) throws IOException {
            String adjustedPath;
            if (local.isDirectory()) {
                this.listener.startedDir(local.getName());
                adjustedPath = this.uploadDir(local, remote);
                this.listener.finishedDir();
            } else if (local.isFile()) {
                this.listener.startedFile(local.getName(), local.getLength());
                adjustedPath = this.uploadFile(local, remote);
                this.listener.finishedFile();
            } else {
                throw new IOException(local + " is not a file or directory");
            }
            SFTPFileTransfer.this.engine.setAttributes(adjustedPath, this.getAttributes(local));
        }

        private String uploadDir(LocalSourceFile local, String remote) throws IOException {
            String adjusted = this.prepareDir(local, remote);
            for (LocalSourceFile localSourceFile : local.getChildren(SFTPFileTransfer.this.getUploadFilter())) {
                this.upload(localSourceFile, adjusted);
            }
            return adjusted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String uploadFile(LocalSourceFile local, String remote) throws IOException {
            String adjusted = this.prepareFile(local, remote);
            RemoteFile rf = SFTPFileTransfer.this.engine.open(adjusted, EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC));
            try {
                InputStream fis = local.getInputStream();
                try {
                    new StreamCopier(fis, rf.getOutputStream()).bufSize(SFTPFileTransfer.this.engine.getSubsystem().getRemoteMaxPacketSize() - rf.getOutgoingPacketOverhead()).keepFlushing(false).listener(this.listener).copy();
                }
                finally {
                    fis.close();
                }
            }
            finally {
                rf.close();
            }
            return adjusted;
        }

        private String prepareDir(LocalSourceFile local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.engine.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} does not exist, creating", (Object)remote);
                    SFTPFileTransfer.this.engine.makeDir(remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                if (SFTPFileTransfer.this.engine.getPathHelper().getComponents(remote).getName().equals(local.getName())) {
                    SFTPFileTransfer.this.log.debug("probeDir: {} already exists", (Object)remote);
                    return remote;
                }
                SFTPFileTransfer.this.log.debug("probeDir: {} already exists, path adjusted for {}", (Object)remote, (Object)local.getName());
                return this.prepareDir(local, SFTPFileTransfer.this.engine.getPathHelper().adjustForParent(remote, local.getName()));
            }
            throw new IOException((Object)((Object)attrs.getMode().getType()) + " file already exists at " + remote);
        }

        private String prepareFile(LocalSourceFile local, String remote) throws IOException {
            FileAttributes attrs;
            try {
                attrs = SFTPFileTransfer.this.engine.stat(remote);
            }
            catch (SFTPException e) {
                if (e.getStatusCode() == Response.StatusCode.NO_SUCH_FILE) {
                    SFTPFileTransfer.this.log.debug("probeFile: {} does not exist", (Object)remote);
                    return remote;
                }
                throw e;
            }
            if (attrs.getMode().getType() == FileMode.Type.DIRECTORY) {
                SFTPFileTransfer.this.log.debug("probeFile: {} was directory, path adjusted for {}", (Object)remote, (Object)local.getName());
                remote = SFTPFileTransfer.this.engine.getPathHelper().adjustForParent(remote, local.getName());
                return remote;
            }
            SFTPFileTransfer.this.log.debug("probeFile: {} is a {} file that will be replaced", (Object)remote, (Object)attrs.getMode().getType());
            return remote;
        }

        private FileAttributes getAttributes(LocalSourceFile local) throws IOException {
            FileAttributes.Builder builder = new FileAttributes.Builder().withPermissions(local.getPermissions());
            if (local.providesAtimeMtime()) {
                builder.withAtimeMtime(local.getLastAccessTime(), local.getLastModifiedTime());
            }
            return builder.build();
        }
    }

    private class Downloader {
        private final TransferListener listener;

        private Downloader() {
            this.listener = SFTPFileTransfer.this.getTransferListener();
        }

        private void download(RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjustedFile;
            switch (remote.getAttributes().getType()) {
                case DIRECTORY: {
                    this.listener.startedDir(remote.getName());
                    adjustedFile = this.downloadDir(remote, local);
                    this.listener.finishedDir();
                    break;
                }
                case UNKNOWN: {
                    SFTPFileTransfer.this.log.warn("Server did not supply information about the type of file at `{}` -- assuming it is a regular file!", (Object)remote.getPath());
                }
                case REGULAR: {
                    this.listener.startedFile(remote.getName(), remote.getAttributes().getSize());
                    adjustedFile = this.downloadFile(remote, local);
                    this.listener.finishedFile();
                    break;
                }
                default: {
                    throw new IOException(remote + " is not a regular file or directory");
                }
            }
            this.copyAttributes(remote, adjustedFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDestFile downloadDir(RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjusted = local.getTargetDirectory(remote.getName());
            RemoteDirectory rd = SFTPFileTransfer.this.engine.openDir(remote.getPath());
            try {
                for (RemoteResourceInfo rri : rd.scan(SFTPFileTransfer.this.getDownloadFilter())) {
                    this.download(rri, adjusted.getChild(rri.getName()));
                }
            }
            finally {
                rd.close();
            }
            return adjusted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDestFile downloadFile(RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            LocalDestFile adjusted = local.getTargetFile(remote.getName());
            RemoteFile rf = SFTPFileTransfer.this.engine.open(remote.getPath());
            try {
                OutputStream os = adjusted.getOutputStream();
                try {
                    new StreamCopier(rf.getInputStream(), os).bufSize(SFTPFileTransfer.this.engine.getSubsystem().getLocalMaxPacketSize()).keepFlushing(false).listener(this.listener).copy();
                }
                finally {
                    os.close();
                }
            }
            finally {
                rf.close();
            }
            return adjusted;
        }

        private void copyAttributes(RemoteResourceInfo remote, LocalDestFile local) throws IOException {
            FileAttributes attrs = remote.getAttributes();
            local.setPermissions(attrs.getMode().getPermissionsMask());
            if (attrs.has(FileAttributes.Flag.ACMODTIME)) {
                local.setLastAccessedTime(attrs.getAtime());
                local.setLastModifiedTime(attrs.getMtime());
            }
        }
    }
}

