/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryType;

public class AttributeQuery
extends AbstractRequest<AttributeQueryDocument, AttributeQueryType> {
    public AttributeQuery(NameIDType issuer, SubjectType subject) {
        AttributeQueryDocument xbdoc = AttributeQueryDocument.Factory.newInstance();
        this.init(xbdoc, xbdoc.addNewAttributeQuery(), issuer);
        ((AttributeQueryType)this.getXMLBean()).setSubject(subject);
    }

    public void setAttributes(SAMLAttribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            ((AttributeQueryType)this.getXMLBean()).insertNewAttribute(i);
            ((AttributeQueryType)this.getXMLBean()).setAttributeArray(i, attributes[i].getXBean());
        }
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xmlDocuemnt = AttributeQueryDocument.Factory.parse(doc);
            this.xmlReq = ((AttributeQueryDocument)this.xmlDocuemnt).getAttributeQuery();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }
}

