/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SelfCallChecker;
import eu.unicore.security.TrustDelegationException;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.ValidationResult;
import eu.unicore.security.etd.ETDApi;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.wsutil.AuthInHandler;
import eu.unicore.security.wsutil.CXFUtils;
import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class ETDInHandler
extends AbstractSoapInterceptor {
    public static final String SAML2_NS = "urn:oasis:names:tc:SAML:2.0:assertion";
    private static final Logger logger = Log.getLogger("unicore.security", ETDInHandler.class);
    private final SelfCallChecker selfCallChecker;
    private X509CertChainValidator validator;
    private X509CertChainValidator trustedDelegationIssuers;

    public ETDInHandler(SelfCallChecker selfCallChecker, X509CertChainValidator validator, X509CertChainValidator trustedDelegationIssuers) {
        super("pre-invoke");
        this.getAfter().add(AuthInHandler.class.getName());
        this.selfCallChecker = selfCallChecker;
        this.validator = validator;
        this.trustedDelegationIssuers = trustedDelegationIssuers;
    }

    public void handleMessage(SoapMessage ctx) {
        SecurityTokens securityTokens = (SecurityTokens)ctx.get((Object)SecurityTokens.KEY);
        if (securityTokens == null) {
            logger.error("No security info in headers. Wrong configuration: " + AuthInHandler.class.getCanonicalName() + " handler" + " must be configure before this ETD handler.");
            return;
        }
        if (Boolean.TRUE.equals(securityTokens.getContext().get("reused-unicore-security-session"))) {
            return;
        }
        try {
            this.doCheck(securityTokens);
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
    }

    protected void doCheck(SecurityTokens securityTokens) throws Exception {
        List<TrustDelegation> tdTokens = this.getTrustAssertionsFromHeader(securityTokens.getContext());
        securityTokens.setTrustDelegationTokens(tdTokens);
        securityTokens.setTrustDelegationValidated(false);
        securityTokens.setConsignorTrusted(false);
        String consignor = securityTokens.getConsignorName();
        if (consignor == null) {
            logger.debug("No CONSIGNOR information present (it means that request wasn't authenticated!). Trust Delegations won't be further processed.");
            return;
        }
        String etdIssuerName = this.getIssuerName(tdTokens);
        if (etdIssuerName == null) {
            logger.debug("No ETD tokens are present.");
            if (securityTokens.getUserName() == null || X500NameUtils.equal((String)securityTokens.getUserName(), (String)consignor)) {
                logger.debug("Performing the request with the Consignor's identity.");
                securityTokens.setConsignorTrusted(true);
            } else if (securityTokens.isConsignorUsingProxy() && X500NameUtils.equal((String)securityTokens.getUserName(), (String)securityTokens.getConsignorRealName())) {
                logger.debug("Performing the request with the Consignor's identity (handling proxy which is used by consignor).");
                securityTokens.setConsignorTrusted(true);
                securityTokens.setUserName(consignor);
            } else {
                logger.warn("Got request with User set to " + X500NameUtils.getReadableForm((String)securityTokens.getUserName()) + " without a TD! Consignor is " + X500NameUtils.getReadableForm((String)consignor));
            }
            return;
        }
        boolean etdIssuerIsDn = this.isIssuerDN(tdTokens);
        String etdCustodianName = this.getCustodianName(tdTokens);
        String requestedUser = securityTokens.getUserName();
        if (requestedUser != null) {
            if (!X500NameUtils.equal((String)requestedUser, (String)etdCustodianName)) {
                logger.warn("Trust delegation is present but its custodian differ from the requested user. Trust delegation tokens won't be verified and delegation status is set to invalid. TD Custodian: " + X500NameUtils.getReadableForm((String)etdCustodianName) + " Requested user: " + X500NameUtils.getReadableForm((String)requestedUser));
                return;
            }
        } else {
            logger.debug("No user was requested so TD won't be checked. Performing the request with Consignor's identity.");
            securityTokens.setConsignorTrusted(true);
            return;
        }
        if (logger.isDebugEnabled()) {
            String readableIssuer = etdIssuerIsDn ? X500NameUtils.getReadableForm((String)etdIssuerName) : etdIssuerName;
            logger.debug("ETD initial issuer: " + readableIssuer + "\nConsignor: " + X500NameUtils.getReadableForm((String)consignor) + "\nETD custodian: " + X500NameUtils.getReadableForm((String)etdCustodianName));
            if (X500NameUtils.equal((String)consignor, (String)etdCustodianName)) {
                logger.debug("ETD custodian and consignor are equal");
            } else if (etdIssuerIsDn && securityTokens.isConsignorUsingProxy() && X500NameUtils.equal((String)securityTokens.getConsignorRealName(), (String)etdIssuerName)) {
                logger.debug("ETD issuer and consignor are equal after handling a proxy");
            } else {
                logger.debug("ETD issuer and consignor are different");
            }
        }
        this.checkDelegation(securityTokens, tdTokens);
    }

    protected void checkDelegation(SecurityTokens securityTokens, List<TrustDelegation> tdTokens) throws TrustDelegationException {
        String userName = securityTokens.getUserName();
        if (logger.isDebugEnabled()) {
            logger.debug("Checking trust delegation, expected custodian is <" + X500NameUtils.getReadableForm((String)userName) + ">");
        }
        String consignor = securityTokens.getConsignorName();
        boolean validTD = this.checkSuppliedTD(userName, tdTokens);
        boolean consignorTrusted = this.checkIfConsignorTrusted(validTD, securityTokens.isConsignorUsingProxy(), tdTokens, securityTokens.getConsignorRealName(), consignor, userName);
        securityTokens.setTrustDelegationValidated(validTD);
        securityTokens.setConsignorTrusted(consignorTrusted);
        if (validTD && consignorTrusted) {
            X509Certificate[] etdInitialIssuerCC = this.getIssuer(tdTokens);
            if (securityTokens.isSupportingProxy() && ProxyUtils.isProxy((X509Certificate[])etdInitialIssuerCC)) {
                securityTokens.setUser(new X509Certificate[]{ProxyUtils.getEndUserCertificate((X509Certificate[])etdInitialIssuerCC)});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Final SecurityTokens after ETD processing:\n" + securityTokens.toString());
        }
    }

    protected boolean checkIfConsignorTrusted(boolean tdGenericValidity, boolean consignorIsProxy, List<TrustDelegation> tdTokens, String realConsignor, String consignor, String user) {
        if (X500NameUtils.equal((String)realConsignor, (String)user)) {
            return true;
        }
        if (this.selfCallChecker != null && this.selfCallChecker.isSelfCall(consignor)) {
            logger.debug("Accept message by server as valid trust delegation.");
            return true;
        }
        if (!tdGenericValidity || tdTokens.size() == 0) {
            return false;
        }
        ETDApi etd = UnicoreSecurityFactory.getETDEngine();
        if (etd.isSubjectInChain(tdTokens, realConsignor)) {
            return true;
        }
        return consignorIsProxy && etd.isSubjectInChain(tdTokens, consignor);
    }

    protected boolean checkSuppliedTD(String user, List<TrustDelegation> td) {
        if (td.size() == 0) {
            return false;
        }
        String delegationTarget = td.get(td.size() - 1).getSubjectName();
        if (logger.isDebugEnabled()) {
            logger.debug("Got TD to <" + delegationTarget + ">, dumping the TD chain");
            int i = 0;
            for (TrustDelegation t : td) {
                logger.debug("(Entry " + i++ + ") issuer: " + t.getIssuerName() + " receiver: " + t.getSubjectName() + " custodian: " + t.getCustodianDN());
            }
        }
        ETDApi etd = UnicoreSecurityFactory.getETDEngine();
        HashSet<X509Certificate> trustedIssuers = new HashSet<X509Certificate>();
        if (this.trustedDelegationIssuers != null) {
            Collections.addAll(trustedIssuers, this.trustedDelegationIssuers.getTrustedIssuers());
        }
        ValidationResult res = etd.isTrustDelegated(td, delegationTarget, user, this.validator, trustedIssuers);
        if (logger.isDebugEnabled()) {
            logger.debug("Validation of supplied TD result: " + res.isValid());
        }
        if (res.isValid()) {
            return true;
        }
        logger.warn("Unsuccessful TD validation (" + user + " to " + delegationTarget + "), reason: " + res.getInvalidResaon());
        return false;
    }

    protected List<TrustDelegation> getTrustAssertionsFromHeader(Map<String, Object> secCtx) {
        List assertions;
        ArrayList<TrustDelegation> ret = new ArrayList<TrustDelegation>();
        List list = assertions = secCtx == null ? null : (List)secCtx.get(AuthInHandler.RAW_SAML_ASSERTIONS_KEY);
        if (assertions == null || assertions.size() == 0) {
            return ret;
        }
        for (int i = 0; i < assertions.size(); ++i) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                CXFUtils.writeXml((Node)assertions.get(i), os);
                AssertionDocument aDoc = AssertionDocument.Factory.parse(os.toString());
                TrustDelegation tmp = new TrustDelegation(aDoc);
                ret.add(tmp);
                continue;
            }
            catch (Exception e) {
                logger.trace("Ignoring non-parsable as trust delegation assertion: " + e.getMessage());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TD chain length " + ret.size());
        }
        return ret;
    }

    protected String getIssuerName(List<TrustDelegation> tdTokens) {
        if (tdTokens == null || tdTokens.size() == 0) {
            return null;
        }
        try {
            return tdTokens.get(0).getIssuerName();
        }
        catch (Exception e) {
            logger.warn("Can't parse ETD assertion issuer name: " + e.toString());
            return null;
        }
    }

    protected boolean isIssuerDN(List<TrustDelegation> tdTokens) {
        if (tdTokens == null || tdTokens.size() == 0) {
            return false;
        }
        try {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(tdTokens.get(0).getIssuerNameFormat());
        }
        catch (Exception e) {
            logger.warn("Can't parse ETD assertion issuer name format: " + e.toString());
            return false;
        }
    }

    protected String getCustodianName(List<TrustDelegation> tdTokens) {
        if (tdTokens == null || tdTokens.size() == 0) {
            return null;
        }
        try {
            return tdTokens.get(0).getCustodianDN();
        }
        catch (Exception e) {
            logger.warn("Can't parse ETD assertion custodian name: " + e.toString());
            return null;
        }
    }

    protected X509Certificate[] getIssuer(List<TrustDelegation> tdTokens) {
        if (tdTokens == null || tdTokens.size() == 0) {
            return null;
        }
        try {
            return tdTokens.get(0).getIssuerFromSignature();
        }
        catch (Exception e) {
            return null;
        }
    }
}

