/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.util.Log;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class ConditionalGetInHandler
extends AbstractSoapInterceptor {
    private static final Logger logger = Log.getLogger("unicore.client", ConditionalGetInHandler.class);
    private static final ThreadLocal<String> etag = new ThreadLocal();
    private static final ThreadLocal<String> lastModified = new ThreadLocal();
    private static final ThreadLocal<Boolean> notModified = new ThreadLocal();
    public static final String CG_HEADER_NS = "http://www.unicore.eu/unicore/ws";
    public static final String CG_HEADER = "ConditionalGet";
    private static final String ETAG_HEADER = "Etag";
    private static final String LASTMODIFIED_HEADER = "LastModified";
    private static final String NOTMODIFIED_HEADER = "NotModified";
    private static final QName headerQName = new QName("http://www.unicore.eu/unicore/ws", "ConditionalGet");
    private static final QName inmQName = new QName("http://www.unicore.eu/unicore/ws", "Etag");
    private static final QName imsQName = new QName("http://www.unicore.eu/unicore/ws", "LastModified");
    private static final QName notModifiedQName = new QName("http://www.unicore.eu/unicore/ws", "NotModified");

    public ConditionalGetInHandler() {
        super("pre-invoke");
    }

    public void handleMessage(SoapMessage ctx) {
        notModified.set(Boolean.FALSE);
        Header header = ctx.getHeader(headerQName);
        if (header == null) {
            return;
        }
        etag.remove();
        lastModified.remove();
        Element hdr = (Element)header.getObject();
        Element inmEl = DOMUtils.getFirstChildWithName((Element)hdr, (QName)inmQName);
        String inm = inmEl != null ? inmEl.getTextContent() : null;
        Element imsEl = DOMUtils.getFirstChildWithName((Element)hdr, (QName)imsQName);
        String ims = imsEl != null ? imsEl.getTextContent() : null;
        Element notModEl = DOMUtils.getFirstChildWithName((Element)hdr, (QName)notModifiedQName);
        if (notModEl != null) {
            notModified.set(Boolean.TRUE);
        } else {
            notModified.set(Boolean.FALSE);
        }
        if (logger.isDebugEnabled()) {
            if (notModEl == null) {
                logger.debug("Extracted ETag=" + inm + " LastModidied=" + ims);
            } else {
                logger.debug("Not modified");
            }
        }
        etag.set(inm);
        lastModified.set(ims);
    }

    public static String getEtag() {
        return etag.get();
    }

    public static String getLastModified() {
        return lastModified.get();
    }

    public static boolean isNotModified() {
        return Boolean.TRUE.equals(notModified.get());
    }
}

