/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.user.UserAssertion;
import eu.unicore.security.wsutil.SecuritySessionUtils;
import eu.unicore.security.wsutil.WSSecHeader;
import eu.unicore.security.wsutil.client.DSigOutHandler;
import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class TDOutHandler
extends AbstractSoapInterceptor {
    private static final Logger logger = Log.getLogger("unicore.security", TDOutHandler.class);
    private List<TrustDelegation> assertionList = null;
    private List<Element> assertionListDOM = null;
    private Element userAssertionDOM;
    private static final String phase = "pre-protocol";

    public TDOutHandler(List<TrustDelegation> tdChain) {
        super(phase);
        this.init(tdChain, null, null, null);
    }

    public TDOutHandler(List<TrustDelegation> tdChain, UserAssertion userAssertion) {
        super(phase);
        this.init(tdChain, userAssertion);
    }

    public TDOutHandler(List<TrustDelegation> tdChain, String userDN, String callerDN) {
        super(phase);
        this.init(tdChain, null, userDN, callerDN);
    }

    public TDOutHandler(List<TrustDelegation> tdChain, X509Certificate userCert, String callerDN) {
        super(phase);
        this.init(tdChain, userCert, null, callerDN);
    }

    protected TDOutHandler() {
        super(phase);
        this.initHandler();
    }

    protected void initHandler() {
        this.getBefore().add(DSigOutHandler.class.getName());
        this.getBefore().add(SAAJOutInterceptor.class.getName());
    }

    protected void init(List<TrustDelegation> tdChain, UserAssertion userAssertion) {
        this.initHandler();
        this.initJDOM(tdChain, userAssertion);
    }

    protected void init(List<TrustDelegation> tdChain, X509Certificate userCert, String userDN, String callerDN) {
        this.initHandler();
        UserAssertion userA = this.createUserAssertion(userCert, userDN, callerDN);
        this.initJDOM(tdChain, userA);
    }

    protected UserAssertion createUserAssertion(X509Certificate userCert, String userDN, String callerDN) {
        UserAssertion userA = null;
        if (userCert != null && callerDN != null) {
            X509Certificate[] userCC = new X509Certificate[]{userCert};
            try {
                userA = new UserAssertion(callerDN, userCC);
            }
            catch (Exception e) {
                logger.fatal("Can't create USER assertion: ", e);
            }
        } else if (userDN != null && callerDN != null) {
            userA = new UserAssertion(callerDN, userDN);
        }
        return userA;
    }

    protected void initJDOM(List<TrustDelegation> tdChain, UserAssertion userA) {
        this.assertionListDOM = null;
        ArrayList arrayList = this.assertionList = tdChain != null ? tdChain : new ArrayList();
        if (this.assertionList.size() != 0) {
            this.assertionListDOM = new ArrayList<Element>();
            try {
                for (TrustDelegation td : this.assertionList) {
                    Element el = DOMUtils.readXml((InputStream)td.getXMLBeanDoc().newInputStream()).getDocumentElement();
                    this.assertionListDOM.add(el);
                }
                logger.debug("Initialised TD Outhandler with TD chain of length = " + this.assertionList.size());
            }
            catch (Exception e) {
                logger.warn("Can't create JDOM representation of TD assertion.", e);
                this.assertionListDOM = null;
            }
        }
        this.userAssertionDOM = null;
        if (userA != null) {
            try {
                AssertionDocument user = userA.getXMLBeanDoc();
                this.userAssertionDOM = DOMUtils.readXml((InputStream)user.newInputStream()).getDocumentElement();
            }
            catch (Exception e) {
                logger.fatal("Can't create USER assertion: ", e);
                return;
            }
        }
    }

    public void handleMessage(SoapMessage message) {
        if (!MessageUtils.isOutbound((Message)message)) {
            return;
        }
        if (SecuritySessionUtils.haveSessionID(message)) {
            logger.debug("Skipping TD addition as security session is being used.");
            return;
        }
        if (this.assertionListDOM == null && this.userAssertionDOM == null) {
            logger.debug("Neither TD nor User assertion available.");
            return;
        }
        if (this.assertionListDOM != null && logger.isTraceEnabled()) {
            logger.trace("TD DUMP begin");
            for (TrustDelegation td : this.assertionList) {
                logger.trace(td.getXMLBeanDoc().toString());
            }
            logger.trace("TD DUMP end");
        }
        List h = message.getHeaders();
        Element insertionPoint = null;
        WSSecHeader sec = new WSSecHeader(true);
        insertionPoint = sec.getOrInsertWSSecElement(h);
        if (this.assertionListDOM != null) {
            for (Element e : this.assertionListDOM) {
                Document parent = insertionPoint.getOwnerDocument();
                insertionPoint.appendChild(parent.importNode(e, true));
            }
        }
        if (this.userAssertionDOM != null) {
            Document parent = insertionPoint.getOwnerDocument();
            insertionPoint.appendChild(parent.importNode(this.userAssertionDOM, true));
            if (logger.isTraceEnabled()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DOMUtils.writeXml((Node)this.userAssertionDOM, (OutputStream)bos);
                    logger.trace("User assertion:\n" + bos.toString());
                }
                catch (Exception e) {
                    logger.warn("Can't output user assertion", e);
                }
            }
        }
    }
}

