/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.client;

import eu.unicore.uftp.client.AbstractUFTPClient;
import eu.unicore.uftp.client.ClientFactory;
import eu.unicore.uftp.client.FileInfo;
import eu.unicore.uftp.client.SessionCommands;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.Reply;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.rsync.Master;
import eu.unicore.uftp.rsync.MasterChannel;
import eu.unicore.uftp.rsync.RsyncStats;
import eu.unicore.uftp.rsync.Slave;
import eu.unicore.uftp.rsync.SlaveChannel;
import eu.unicore.uftp.rsync.SocketMasterChannel;
import eu.unicore.uftp.rsync.SocketSlaveChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class UFTPSessionClient
extends AbstractUFTPClient {
    private static final Logger logger = Logger.getLogger(UFTPSessionClient.class);
    private final byte[] buffer = new byte[16384];
    private String commandFile;
    private File baseDirectory;

    public UFTPSessionClient(InetAddress[] servers, int port) {
        super(servers, port);
    }

    public void setCommandFile(String commandFile) {
        if (commandFile == null) {
            throw new IllegalArgumentException("Commandfile is required");
        }
        this.commandFile = commandFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.commandFile == null) {
            throw new IllegalArgumentException("Commandfile is required");
        }
        try {
            logger.info("Connecting...");
            this.connect();
            BufferedReader localReader = new BufferedReader(new FileReader(this.commandFile));
            try {
                String line;
                while ((line = localReader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    List<String> args = Utils.parseLine(line);
                    Runnable cmd = SessionCommands.createCMD(args, this);
                    if (cmd == null) {
                        logger.error("No command for args " + args);
                        continue;
                    }
                    logger.info("Executing " + line);
                    cmd.run();
                }
            }
            finally {
                localReader.close();
            }
            logger.info("Exiting UFTP session.");
        }
        catch (AuthorizationFailureException ex) {
            throw new RuntimeException("Authorization error running session", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error running session", ex);
        }
        this.cleanup();
    }

    public void disconnect() throws IOException {
        this.client.sendControl("BYE\r\n");
        this.client.close();
    }

    public void get(String remoteFile, OutputStream localTarget) throws IOException {
        this.checkConnected();
        this.prepareGet(localTarget);
        long size = this.sendRetrieveCommand(remoteFile);
        this.moveData(size);
    }

    public void get(String remoteFile, long offset, long length, OutputStream localTarget) throws IOException {
        this.checkConnected();
        this.prepareGet(localTarget);
        this.sendRangeCommand(offset, length);
        long size = this.sendRetrieveCommand(remoteFile);
        this.moveData(size);
    }

    public void put(String remoteFile, long size, InputStream localSource) throws IOException {
        this.checkConnected();
        this.preparePut(localSource);
        this.sendStoreCommand(remoteFile, size);
        this.moveData(size);
    }

    public List<String> getFileList(String baseDir) throws IOException {
        this.checkConnected();
        return this.sendListFilesCommand("N", baseDir);
    }

    public List<FileInfo> getFileInfoList(String baseDir) throws IOException {
        ArrayList<FileInfo> res = new ArrayList<FileInfo>();
        for (String ls : this.getFileList(baseDir)) {
            res.add(new FileInfo(ls));
        }
        return res;
    }

    public long getFileSize(String pathName) throws IOException {
        this.checkConnected();
        return this.sendSizeCommand(pathName);
    }

    public void cd(String dir) throws IOException {
        this.checkConnected();
        this.sendCD(dir);
    }

    public void cdUp() throws IOException {
        this.checkConnected();
        this.sendCDUP();
    }

    public void mkdir(String dir) throws IOException {
        this.checkConnected();
        this.sendMKD(dir);
    }

    public void rm(String path) throws IOException {
        this.checkConnected();
        this.sendRM(path);
    }

    public String pwd() throws IOException {
        this.checkConnected();
        return this.sendPWD();
    }

    public RsyncStats syncLocalFile(String remoteMaster, File localSlave) throws Exception {
        this.sendSYNCMaster(remoteMaster);
        Slave slave = new Slave(localSlave, (SlaveChannel)new SocketSlaveChannel(this.socket), localSlave.getAbsolutePath());
        return slave.call();
    }

    public RsyncStats syncRemoteFile(File localMaster, String remoteSlave) throws Exception {
        this.sendSYNCSlave(remoteSlave);
        Master master = new Master(localMaster, (MasterChannel)new SocketMasterChannel(this.socket), localMaster.getAbsolutePath());
        return master.call();
    }

    public void setBaseDirectory(File base) {
        if (!base.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + base.getPath());
        }
        this.baseDirectory = base;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    private void moveData(long maxBytes) throws IOException {
        int n;
        long time = System.currentTimeMillis();
        long total = 0L;
        boolean notify = this.progressListener != null;
        long c = 0L;
        while (total < maxBytes && (n = this.reader.read(this.buffer)) >= 0) {
            total += (long)n;
            this.writer.write(this.buffer, 0, n);
            if (!notify) continue;
            if (c % 1000L == 0L) {
                this.progressListener.notifyTotalBytesTransferred(total);
            }
            ++c;
        }
        this.writer.flush();
        if (notify) {
            this.progressListener.notifyTotalBytesTransferred(total);
        }
        time = System.currentTimeMillis() - time;
        double rate = (double)total / (double)time;
        logger.info("Finished, data rate " + (int)rate + " kB/sec. (" + total + " bytes in " + time + " ms.)");
    }

    private void sendRangeCommand(long offset, long length) throws IOException {
        String message = "RANG " + offset + " " + length + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.getCode() != 350) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private long sendRetrieveCommand(String remoteFile) throws IOException {
        String message = "RETR " + remoteFile + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
        long size = Long.parseLong(reply.getStatusLine().split(" ")[2]);
        return size;
    }

    private List<String> sendListFilesCommand(String options, String baseDir) throws IOException {
        if (baseDir == null) {
            baseDir = ".";
        }
        String message = "STAT " + options + " " + baseDir + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error reading file list: " + reply.getStatusLine());
        }
        return reply.getResults();
    }

    private void sendCD(String dir) throws IOException {
        String message = "CWD " + dir + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private void sendCDUP() throws IOException {
        this.client.sendControl("CDUP");
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private long sendSizeCommand(String remoteFile) throws IOException {
        String message = "SIZE " + remoteFile;
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.getCode() != 213) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
        long size = Long.parseLong(reply.getStatusLine().split(" ")[1]);
        return size;
    }

    private void sendMKD(String pathname) throws IOException {
        String message = "MKD " + pathname + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private void sendRM(String pathname) throws IOException {
        String message = "DELE " + pathname + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private String sendPWD() throws IOException {
        String message = "PWD\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
        return reply.getStatusLine().split(" ", 2)[1];
    }

    private void sendStoreCommand(String remoteFile, long size) throws IOException {
        String message = "ALLO " + size + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
        message = "STOR " + remoteFile + "\r\n";
        this.client.sendControl(message);
        reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private void sendSYNCMaster(String pathname) throws IOException {
        String message = "SYNC-MASTER " + pathname + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private void sendSYNCSlave(String pathname) throws IOException {
        String message = "SYNC-SLAVE " + pathname + "\r\n";
        this.client.sendControl(message);
        Reply reply = Reply.read(this.client);
        if (reply.isError()) {
            throw new IOException("Error: server reply " + reply.getStatusLine());
        }
    }

    private void checkConnected() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Not connected!");
        }
    }

    public static String makeCommandline(String host, int port, String baseDirectory, String secret, int numStreams, String encryptionKey, int bufferSize, boolean compress, String commandFile) {
        StringBuilder sb = new StringBuilder();
        sb.append("-l ").append(host);
        sb.append(" -L ").append(port);
        sb.append(" -f \"").append(baseDirectory).append("\"");
        sb.append(" -x ").append(secret);
        sb.append(" -n ").append(numStreams);
        if (encryptionKey != null) {
            sb.append(" -E ");
            sb.append(encryptionKey);
        }
        if (commandFile != null) {
            sb.append(" -c \"").append(commandFile).append("\"");
        }
        if (bufferSize > 0) {
            sb.append(" -b ").append(bufferSize);
        }
        if (compress) {
            sb.append(" -z");
        }
        return sb.toString();
    }

    public static UFTPSessionClient create(String[] args) throws UnknownHostException, FileNotFoundException {
        Options options = ClientFactory.createOptions();
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.out.println("Unable to parse options: " + pe.getLocalizedMessage());
            ClientFactory.printUsage(options);
            System.exit(1);
        }
        int port = Integer.parseInt(line.getOptionValue('L'));
        InetAddress[] server = ClientFactory.getServers(line, logger);
        UFTPSessionClient client = new UFTPSessionClient(server, port);
        ClientFactory.configureClient(client, line, logger);
        client.setCommandFile(line.getOptionValue('c'));
        String base = line.getOptionValue('f');
        if (base == null) {
            base = ".";
        }
        client.setBaseDirectory(new File(base));
        logger.info("New UFTP session client for server " + Arrays.asList(server) + " at port " + port);
        return client;
    }
}

