/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.rsync;

import eu.unicore.uftp.rsync.Checksum;
import eu.unicore.uftp.rsync.RsyncData;
import eu.unicore.uftp.rsync.RsyncStats;
import eu.unicore.uftp.rsync.SlaveChannel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class Slave
implements Callable<RsyncStats> {
    private final RandomAccessFile file;
    private final String fileName;
    private final SlaveChannel channel;
    private final int blocksize;
    private final List<Long> weakChecksums = new ArrayList<Long>();
    private final List<byte[]> strongChecksums = new ArrayList<byte[]>();
    public static final int DEFAULT_BLOCKSIZE = 512;
    private int bufsize = 4096;
    boolean dryRun = false;

    public Slave(File file, SlaveChannel channel, String name) throws FileNotFoundException {
        this(new RandomAccessFile(file, "r"), channel, name, Slave.reasonableBlockSize(file));
    }

    public Slave(RandomAccessFile file, SlaveChannel channel, String name) {
        this(file, channel, name, 512);
    }

    public Slave(RandomAccessFile file, SlaveChannel channel, String name, int blocksize) {
        this.file = file;
        this.channel = channel;
        this.blocksize = blocksize;
        this.fileName = name;
    }

    @Override
    public RsyncStats call() throws Exception {
        RsyncStats stats = new RsyncStats(this.fileName);
        stats.blocksize = this.blocksize;
        long start = System.currentTimeMillis();
        this.computeChecksums();
        this.channel.sendToMaster(this.weakChecksums, this.strongChecksums, this.blocksize);
        stats.transferred = this.weakChecksums.size() * 20 + 4;
        try {
            if (!this.dryRun) {
                this.reconstructFile();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        stats.duration = System.currentTimeMillis() - start;
        return stats;
    }

    public void reconstructFile() throws Exception {
        if (this.bufsize < this.blocksize) {
            this.bufsize = this.blocksize * 2;
        }
        File myVersion = new File(this.fileName);
        String name = myVersion.getName();
        File tmpfile = this.tmpFile(myVersion);
        FileOutputStream fos = new FileOutputStream(tmpfile);
        FileChannel reconstruct = fos.getChannel();
        RsyncData masterData = null;
        ByteBuffer buf = ByteBuffer.allocate(this.bufsize);
        byte[] buf2 = new byte[this.blocksize];
        while (!(masterData = this.channel.receive()).isShutDown()) {
            long index;
            int len;
            long remaining = masterData.bytes;
            if (remaining > 0L) {
                long expect = remaining;
                while (remaining > 0L) {
                    buf.clear();
                    if (remaining < (long)this.bufsize) {
                        buf.limit((int)remaining);
                    }
                    if ((len = masterData.data.read(buf)) < 0) {
                        throw new IOException("Unexpected end of data : expected " + expect + " missing " + remaining);
                    }
                    remaining -= (long)len;
                    buf.flip();
                    reconstruct.write(buf);
                }
            }
            if ((index = masterData.blockNumber) < 0L) continue;
            this.file.seek(index * (long)this.blocksize);
            len = this.file.read(buf2);
            buf.clear();
            buf.put(buf2, 0, len);
            buf.flip();
            reconstruct.write(buf);
        }
        fos.close();
        File backup = new File(myVersion.getParentFile(), "__" + name + "__rsync__orig");
        myVersion.renameTo(backup);
        tmpfile.renameTo(new File(myVersion.getParentFile(), name));
        backup.delete();
    }

    protected void computeChecksums() throws IOException {
        this.file.seek(0L);
        long size = this.file.length();
        long offset = 0L;
        byte[] buf = new byte[this.blocksize];
        long remaining = size;
        int c = 0;
        int len = this.blocksize;
        while (true) {
            if (remaining < (long)this.blocksize) {
                len = (int)remaining;
            }
            if ((c = this.file.read(buf, 0, len)) < 0) break;
            this.weakChecksums.add(Checksum.checksum(buf, offset, len - 1));
            this.strongChecksums.add(Checksum.md5(buf));
        }
        this.file.seek(0L);
    }

    public SlaveChannel getChannel() {
        return this.channel;
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public List<Long> getWeakChecksums() {
        return this.weakChecksums;
    }

    public List<byte[]> getStrongChecksums() {
        return this.strongChecksums;
    }

    void setDryRun() {
        this.dryRun = true;
    }

    File tmpFile(File file) {
        return new File(file.getParentFile(), "__" + file.getName() + "__rsync__tmp");
    }

    public static int reasonableBlockSize(File file) {
        return Math.max((int)file.length() / 1000, 512);
    }
}

