/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server.unix;

public class UnixUser {
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    private String loginName;
    private int uid;
    private int gid;
    private int euid;
    private int egid;
    private String name;
    private String home;
    private String shell;

    public static native UnixUser whoami();

    public UnixUser(String loginName) throws IllegalArgumentException {
        if (!this.lookupByLoginName(loginName)) {
            throw new IllegalArgumentException("No such user: " + loginName);
        }
    }

    public UnixUser(int uid) throws IllegalArgumentException {
        if (!this.lookupByUid(uid)) {
            throw new IllegalArgumentException("No such user: " + uid);
        }
    }

    public String getHome() {
        return this.home;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getName() {
        return this.name;
    }

    public String getShell() {
        return this.shell;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public int getEUid() {
        return this.euid;
    }

    public int getEGid() {
        return this.egid;
    }

    private synchronized native boolean lookupByLoginName(String var1);

    private synchronized native boolean lookupByUid(int var1);

    public static native int setUid(int var0);

    public static native int setEUid(int var0);

    public static native int setReUid(int var0, int var1);

    public static native int setGid(int var0);

    public static native int setEGid(int var0);

    public static native int setReGid(int var0, int var1);

    public static native int initGroups(String var0, int var1);

    public String toString() {
        return "[name=" + this.getName() + " loginName=" + this.getLoginName() + " uid=" + this.getUid() + " gid=" + this.getGid() + "]";
    }

    public String getEffective() {
        return "[euid=" + this.getEUid() + " egid=" + this.getEGid() + "]";
    }
}

