/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HttpClientProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger("unicore.configuration", HttpClientProperties.class);
    public static final String PREFIX = "http.";
    public static final String CONNECTION_CLOSE = "connection-close";
    public static final String ALLOW_CHUNKING = "allow-chunking";
    public static final String HTTP_MAX_REDIRECTS = "maxRedirects";
    public static final String HTTP_NON_PROXY_HOSTS = "nonProxyHosts";
    public static final String HTTP_PROXY_HOST = "proxyHost";
    public static final String HTTP_PROXY_PORT = "proxyPort";
    public static final String HTTP_PROXY_TYPE = "proxyType";
    public static final String HTTP_PROXY_USER = "proxy.user";
    public static final String HTTP_PROXY_PASS = "proxy.password";
    public static final String MAX_HOST_CONNECTIONS = "maxPerRoute";
    public static final String MAX_TOTAL_CONNECTIONS = "maxTotal";
    public static final String SO_TIMEOUT = "socket.timeout";
    public static final String CONNECT_TIMEOUT = "connection.timeout";
    public static final String ALLOW_CIRCULAR_REDIRECTS = "allowCircularRedirects";
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public HttpClientProperties(String prefix, Properties properties) throws ConfigurationException {
        super(prefix, properties, META, log);
    }

    public HttpClientProperties(Properties properties) throws ConfigurationException {
        super(PREFIX, properties, META, log);
    }

    public void setConnectionTimeout(int millis) {
        this.setProperty(CONNECT_TIMEOUT, Integer.toString(millis));
    }

    public int getConnectionTimeout() {
        return this.getIntValue(CONNECT_TIMEOUT);
    }

    public void setSocketTimeout(int millis) {
        this.setProperty(SO_TIMEOUT, Integer.toString(millis));
    }

    public int getSocketTimeout() {
        return this.getIntValue(SO_TIMEOUT);
    }

    @Override
    public HttpClientProperties clone() {
        HttpClientProperties ret = new HttpClientProperties(this.prefix, this.properties);
        super.cloneTo(ret);
        return ret;
    }

    static {
        PropertyMD.DocumentationCategory proxyCat = new PropertyMD.DocumentationCategory("HTTP proxy settings", "2");
        PropertyMD.DocumentationCategory httpCat = new PropertyMD.DocumentationCategory("HTTP client settings", "1");
        META.put(CONNECTION_CLOSE, new PropertyMD("false").setCategory(httpCat).setDescription("If set to true then the client will send connection close header, so the server will close the socket."));
        META.put(ALLOW_CHUNKING, new PropertyMD("true").setCategory(httpCat).setDescription("If set to false, then the client will not use HTTP 1.1 data chunking."));
        META.put(HTTP_MAX_REDIRECTS, new PropertyMD("3").setCategory(httpCat).setDescription("Maximum number of allowed HTTP redirects."));
        META.put(MAX_HOST_CONNECTIONS, new PropertyMD("6").setCategory(httpCat).setDescription("How many connections per host can be made. Note: this is a limit for a single client object instance."));
        META.put(MAX_TOTAL_CONNECTIONS, new PropertyMD("20").setCategory(httpCat).setDescription("How many connections in total can be made. Note: this is a limit for a single client object instance."));
        META.put(SO_TIMEOUT, new PropertyMD("0").setCategory(httpCat).setDescription("Socket timeout (ms)"));
        META.put(CONNECT_TIMEOUT, new PropertyMD("20000").setCategory(httpCat).setDescription("Timeout for the connection establishing (ms)"));
        META.put(ALLOW_CIRCULAR_REDIRECTS, new PropertyMD("false").setHidden().setCategory(httpCat).setDescription("If true then circular redirects are allowed."));
        META.put(HTTP_NON_PROXY_HOSTS, new PropertyMD().setCategory(proxyCat).setDescription("Space (single) separated list of hosts, for which the HTTP proxy should not be used."));
        META.put(HTTP_PROXY_HOST, new PropertyMD().setCategory(proxyCat).setDescription("If set then the HTTP proxy will be used, with this hostname."));
        META.put(HTTP_PROXY_PORT, new PropertyMD().setCategory(proxyCat).setInt().setDescription("HTTP proxy port. If not defined then system property is consulted, and as a final fallback 80 is used."));
        META.put(HTTP_PROXY_TYPE, new PropertyMD("HTTP").setCategory(proxyCat).setDescription("HTTP proxy type: HTTP or SOCKS."));
        META.put(HTTP_PROXY_USER, new PropertyMD().setCategory(proxyCat).setDescription("Relevant only when using HTTP proxy: defines username for authentication to the proxy."));
        META.put(HTTP_PROXY_PASS, new PropertyMD().setCategory(proxyCat).setDescription("Relevant only when using HTTP proxy: defines password for authentication to the proxy."));
    }
}

