/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.UserResourceProfile;
import org.apache.airavata.registry.core.app.catalog.model.UserResourceProfilePK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResourceProfileResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UserResourceProfileResource.class);
    private String userId;
    private String gatewayID;
    private Timestamp createdTime;
    private Timestamp updatedTime;
    private String credentialStoreToken;
    private String identityServerTenant;
    private String identityServerPwdCredToken;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGatewayID() {
        return this.gatewayID;
    }

    public void setGatewayID(String gatewayID) {
        this.gatewayID = gatewayID;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    public String getCredentialStoreToken() {
        return this.credentialStoreToken;
    }

    public void setCredentialStoreToken(String credentialStoreToken) {
        this.credentialStoreToken = credentialStoreToken;
    }

    public String getIdentityServerTenant() {
        return this.identityServerTenant;
    }

    public void setIdentityServerTenant(String identityServerTenant) {
        this.identityServerTenant = identityServerTenant;
    }

    public String getIdentityServerPwdCredToken() {
        return this.identityServerPwdCredToken;
    }

    public void setIdentityServerPwdCredToken(String identityServerPwdCredToken) {
        this.identityServerPwdCredToken = identityServerPwdCredToken;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserResourceProfile", new Object[0][]);
            generator.setParameter("gatewayID", ids.getSecondLevelIdentifier().toString());
            generator.setParameter("userId", ids.getTopLevelIdentifier().toString());
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserResourceProfile", new Object[0][]);
            generator.setParameter("userId", ids.getTopLevelIdentifier().toString());
            generator.setParameter("gatewayID", ids.getSecondLevelIdentifier().toString());
            Query q = generator.selectQuery(em);
            if (q.getResultList().size() != 0) {
                UserResourceProfile userResourceProfile = (UserResourceProfile)q.getSingleResult();
                UserResourceProfileResource userResourceProfileResource = (UserResourceProfileResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_RESOURCE_PROFILE, userResourceProfile);
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                userResourceProfileResource.setUserId(ids.getTopLevelIdentifier().toString());
                UserResourceProfileResource userResourceProfileResource2 = userResourceProfileResource;
                return userResourceProfileResource2;
            }
            AppCatalogResource appCatalogResource = null;
            return appCatalogResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> userResourceProfileResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        if (!(value instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)value;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserResourceProfile", new Object[0][]);
            if (fieldName.equals("userId")) {
                generator.setParameter("userId", ids.getTopLevelIdentifier().toString());
                generator.setParameter("gatewayID", ids.getSecondLevelIdentifier().toString());
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UserResourceProfile userResourceProfile = (UserResourceProfile)result;
                        UserResourceProfileResource userResourceProfileResource = (UserResourceProfileResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_RESOURCE_PROFILE, userResourceProfile);
                        userResourceProfileResources.add(userResourceProfileResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for User Resource Profile resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for User Resource Profile resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return userResourceProfileResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        ArrayList<AppCatalogResource> resourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserResourceProfile", new Object[0][]);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (results.size() != 0) {
                for (Object result : results) {
                    UserResourceProfile userResourceProfile = (UserResourceProfile)result;
                    UserResourceProfileResource userResourceProfileResource = (UserResourceProfileResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_RESOURCE_PROFILE, userResourceProfile);
                    resourceList.add(userResourceProfileResource);
                }
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String userId, Object value) throws AppCatalogException {
        ArrayList<String> userResourceProfileResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        if (!(value instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)value;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserResourceProfile", new Object[0][]);
            if (userId.equals("userId")) {
                generator.setParameter("userId", ids.get("userId"));
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UserResourceProfile userResourceProfile = (UserResourceProfile)result;
                        userResourceProfileResourceIDs.add(userResourceProfile.getUserID());
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for User Resource Profile resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for User Resource Profile resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return userResourceProfileResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            UserResourceProfile existingUserResourceProfile = (UserResourceProfile)em.find(UserResourceProfile.class, (Object)new UserResourceProfilePK(this.userId, this.gatewayID));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingUserResourceProfile != null) {
                existingUserResourceProfile.setUpdateTime(AiravataUtils.getCurrentTimestamp());
                if (this.credentialStoreToken != null) {
                    existingUserResourceProfile.setCredentialStoreToken(this.credentialStoreToken);
                }
                if (this.identityServerTenant != null) {
                    existingUserResourceProfile.setIdentityServerTenant(this.identityServerTenant);
                }
                if (this.identityServerPwdCredToken != null) {
                    existingUserResourceProfile.setIdentityServerPwdCredToken(this.identityServerPwdCredToken);
                }
                em.merge((Object)existingUserResourceProfile);
            } else {
                UserResourceProfile userResourceProfile = new UserResourceProfile();
                userResourceProfile.setGatewayID(this.gatewayID);
                userResourceProfile.setUserId(this.userId);
                userResourceProfile.setCreationTime(AiravataUtils.getCurrentTimestamp());
                if (this.credentialStoreToken != null) {
                    userResourceProfile.setCredentialStoreToken(this.credentialStoreToken);
                }
                if (this.identityServerTenant != null) {
                    userResourceProfile.setIdentityServerTenant(this.identityServerTenant);
                }
                if (this.identityServerPwdCredToken != null) {
                    userResourceProfile.setIdentityServerPwdCredToken(this.identityServerPwdCredToken);
                }
                em.persist((Object)userResourceProfile);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserResourceProfile", new Object[0][]);
            generator.setParameter("userId", ids.getTopLevelIdentifier().toString());
            generator.setParameter("gatewayID", ids.getSecondLevelIdentifier().toString());
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = results != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

