/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.airavata.model.workspace.Notification;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.resources.NotificationResource;
import org.apache.airavata.registry.core.experiment.catalog.utils.ThriftDataModelConversion;
import org.apache.airavata.registry.cpi.RegistryException;

public class NotificationRegistry {
    public String createNotification(Notification notification) throws RegistryException {
        notification.setNotificationId(this.getNotificationId());
        this.updateNotification(notification);
        return notification.getNotificationId();
    }

    public void updateNotification(Notification notification) throws RegistryException {
        NotificationResource notificationResource = new NotificationResource();
        notificationResource.setNotificationId(notification.getNotificationId());
        notificationResource.setGatewayId(notification.getGatewayId());
        notificationResource.setTitle(notification.getTitle());
        notificationResource.setNotificationMessage(notification.getNotificationMessage());
        notificationResource.setPriority(notification.getPriority().toString());
        if (notification.getPublishedTime() != 0L) {
            notificationResource.setPublishedTime(new Timestamp(notification.getPublishedTime()));
        }
        if (notification.getExpirationTime() != 0L) {
            notificationResource.setExpirationTime(new Timestamp(notification.getExpirationTime()));
        }
        if (notification.getCreationTime() != 0L) {
            notificationResource.setCreationTime(new Timestamp(notification.getCreationTime()));
        } else {
            notificationResource.setCreationTime(new Timestamp(System.currentTimeMillis()));
        }
        notificationResource.save();
    }

    public Notification getNotification(String notificationId) throws RegistryException {
        NotificationResource notificationResource = new NotificationResource();
        NotificationResource resource = (NotificationResource)notificationResource.get(ResourceType.NOTIFICATION, notificationId);
        if (resource != null) {
            return ThriftDataModelConversion.getNotification(resource);
        }
        return null;
    }

    public void deleteNotification(String notificationId) throws RegistryException {
        NotificationResource notificationResource = new NotificationResource();
        notificationResource.remove(ResourceType.NOTIFICATION, notificationId);
    }

    public List<Notification> getAllGatewayNotifications(String gatewayId) throws RegistryException {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        NotificationResource notificationResource = new NotificationResource();
        List<ExperimentCatResource> resources = notificationResource.getAllNotifications(gatewayId);
        if (resources != null && !resources.isEmpty()) {
            for (ExperimentCatResource e : resources) {
                notifications.add(ThriftDataModelConversion.getNotification((NotificationResource)e));
            }
        }
        Collections.sort(notifications, (o1, o2) -> o2.getCreationTime() - o1.getCreationTime() > 0L ? 1 : -1);
        return notifications;
    }

    private String getNotificationId() {
        return UUID.randomUUID().toString();
    }
}

