/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.executor.ExecutorDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.concurrent.Callable;

public final class RunnableAdapter<V>
implements IdentifiedDataSerializable,
Callable<V>,
HazelcastInstanceAware {
    private Runnable task;

    public RunnableAdapter() {
    }

    public RunnableAdapter(Runnable task) {
        this.task = task;
    }

    public Runnable getRunnable() {
        return this.task;
    }

    public void setRunnable(Runnable runnable) {
        this.task = runnable;
    }

    @Override
    public V call() throws Exception {
        this.task.run();
        return null;
    }

    @Override
    public final void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (this.task instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)this.task)).setHazelcastInstance(hazelcastInstance);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.task);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.task = (Runnable)in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RunnableAdapter");
        sb.append("{task=").append(this.task);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int getFactoryId() {
        return ExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }
}

