/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.common.RealmCacheEntry;
import org.wso2.carbon.user.core.common.RealmCacheKey;

public class RealmCache {
    private static Log log = LogFactory.getLog(RealmCache.class);
    public static final String CUSTOM_TENANT_CACHE_MANAGER = "CUSTOM_TENANT_CACHE_MANAER";
    public static final String CUSTOM_TENANT_CACHE = "$__local__$.CUSTOM_TENANT_CACHE";
    private static final RealmCache instance = new RealmCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<RealmCacheKey, RealmCacheEntry> getRealmCache() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(CUSTOM_TENANT_CACHE_MANAGER);
            Cache cache = cacheManager != null ? cacheManager.getCache(CUSTOM_TENANT_CACHE) : Caching.getCacheManager().getCache(CUSTOM_TENANT_CACHE);
            if (log.isDebugEnabled()) {
                log.debug((Object)("created authorization cache : " + cache));
            }
            Cache cache2 = cache;
            return cache2;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public static synchronized RealmCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRealm getUserRealm(int tenantId, String realmName) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            RealmCacheKey key = new RealmCacheKey(tenantId, realmName);
            RealmCacheEntry entry = instance.getValueFromCache(key);
            if (entry != null) {
                UserRealm userRealm = entry.getUserRealm();
                return userRealm;
            }
            UserRealm userRealm = null;
            return userRealm;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void addToCache(int tenantId, String realmName, UserRealm userRealm) {
        instance.addToCache(new RealmCacheKey(tenantId, realmName), new RealmCacheEntry(userRealm));
    }

    public void clearFromCache(int tenantId, String realmName) {
        RealmCacheKey key = new RealmCacheKey(tenantId, realmName);
        RealmCacheEntry entry = instance.getValueFromCache(key);
        if (entry != null) {
            instance.clearCacheEntry(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(RealmCacheKey key, RealmCacheEntry entry) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<RealmCacheKey, RealmCacheEntry> cache = this.getRealmCache();
            if (cache.containsKey((Object)key)) {
                cache.remove((Object)key);
            }
            cache.put((Object)key, (Object)entry);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmCacheEntry getValueFromCache(RealmCacheKey key) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<RealmCacheKey, RealmCacheEntry> cache = this.getRealmCache();
            if (cache.containsKey((Object)key)) {
                RealmCacheEntry realmCacheEntry = (RealmCacheEntry)cache.get((Object)key);
                return realmCacheEntry;
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheEntry(RealmCacheKey key) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<RealmCacheKey, RealmCacheEntry> cache = this.getRealmCache();
            if (cache.containsKey((Object)key)) {
                cache.remove((Object)key);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void clear() {
        Cache<RealmCacheKey, RealmCacheEntry> cache = this.getRealmCache();
        cache.removeAll();
    }
}

