/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PutItemRequestMarshaller
implements Marshaller<Request<PutItemRequest>, PutItemRequest> {
    public Request<PutItemRequest> marshall(PutItemRequest putItemRequest) {
        if (putItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.PutItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (putItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)putItemRequest.getTableName());
            }
            if (putItemRequest.getItem() != null) {
                jsonWriter.key("Item");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : putItemRequest.getItem().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (putItemRequest.getExpected() != null) {
                jsonWriter.key("Expected");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : putItemRequest.getExpected().entrySet()) {
                    ListWithAutoConstructFlag attributeValueListList;
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    AttributeValue value = ((ExpectedAttributeValue)entry.getValue()).getValue();
                    if (value != null) {
                        jsonWriter.key("Value");
                        AttributeValueJsonMarshaller.getInstance().marshall(value, jsonWriter);
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).isExists() != null) {
                        jsonWriter.key("Exists").value((Object)((ExpectedAttributeValue)entry.getValue()).isExists());
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value((Object)((ExpectedAttributeValue)entry.getValue()).getComparisonOperator());
                    }
                    if (!((attributeValueListList = (ListWithAutoConstructFlag)((ExpectedAttributeValue)entry.getValue()).getAttributeValueList()) == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            if (attributeValueListListValue == null) continue;
                            AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (putItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value((Object)putItemRequest.getReturnValues());
            }
            if (putItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value((Object)putItemRequest.getReturnConsumedCapacity());
            }
            if (putItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value((Object)putItemRequest.getReturnItemCollectionMetrics());
            }
            if (putItemRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value((Object)putItemRequest.getConditionalOperator());
            }
            if (putItemRequest.getConditionExpression() != null) {
                jsonWriter.key("ConditionExpression").value((Object)putItemRequest.getConditionExpression());
            }
            if (putItemRequest.getExpressionAttributeNames() != null) {
                jsonWriter.key("ExpressionAttributeNames");
                jsonWriter.object();
                for (Map.Entry<String, Object> entry : putItemRequest.getExpressionAttributeNames().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.value(entry.getValue());
                }
                jsonWriter.endObject();
            }
            if (putItemRequest.getExpressionAttributeValues() != null) {
                jsonWriter.key("ExpressionAttributeValues");
                jsonWriter.object();
                for (Map.Entry<String, Object> entry : putItemRequest.getExpressionAttributeValues().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)entry.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

