/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.xop;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerWriter;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.apache.axiom.util.stax.xop.ContentIDGenerator;
import org.apache.axiom.util.stax.xop.OptimizationPolicy;
import org.apache.axiom.util.stax.xop.XOPEncodingStreamWrapper;
import org.apache.axiom.util.stax.xop.XOPUtils;

public class XOPEncodingStreamWriter
extends XOPEncodingStreamWrapper
implements XMLStreamWriter,
DataHandlerWriter {
    private final XMLStreamWriter parent;

    public XOPEncodingStreamWriter(XMLStreamWriter parent, ContentIDGenerator contentIDGenerator, OptimizationPolicy optimizationPolicy) {
        super(contentIDGenerator, optimizationPolicy);
        this.parent = parent;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (DataHandlerWriter.PROPERTY.equals(name)) {
            return this;
        }
        return this.parent.getProperty(name);
    }

    private void writeXOPInclude(String contentID) throws XMLStreamException {
        String writerPrefix = this.parent.getPrefix("http://www.w3.org/2004/08/xop/include");
        if (writerPrefix != null) {
            this.parent.writeStartElement("http://www.w3.org/2004/08/xop/include", "Include");
        } else {
            this.parent.writeStartElement("xop", "Include", "http://www.w3.org/2004/08/xop/include");
            this.parent.setPrefix("xop", "http://www.w3.org/2004/08/xop/include");
            this.parent.writeNamespace("xop", "http://www.w3.org/2004/08/xop/include");
        }
        this.parent.writeAttribute("href", XOPUtils.getURLForContentID(contentID));
        this.parent.writeEndElement();
    }

    @Override
    public void writeDataHandler(DataHandler dataHandler, String contentID, boolean optimize) throws IOException, XMLStreamException {
        if ((contentID = this.processDataHandler(dataHandler, contentID, optimize)) != null) {
            this.writeXOPInclude(contentID);
        } else {
            XMLStreamWriterUtils.writeBase64(this.parent, dataHandler);
        }
    }

    @Override
    public void writeDataHandler(DataHandlerProvider dataHandlerProvider, String contentID, boolean optimize) throws IOException, XMLStreamException {
        if ((contentID = this.processDataHandler(dataHandlerProvider, contentID, optimize)) != null) {
            this.writeXOPInclude(contentID);
        } else {
            XMLStreamWriterUtils.writeBase64(this.parent, dataHandlerProvider.getDataHandler());
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.parent.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.parent.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.parent.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.parent.getPrefix(uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.parent.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.parent.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.parent.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.parent.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.parent.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.parent.writeAttribute(localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.parent.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.parent.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.parent.writeCharacters(text);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.parent.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.parent.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.parent.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.parent.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.parent.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.parent.writeEmptyElement(localName);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.parent.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.parent.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.parent.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.parent.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.parent.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.parent.writeProcessingInstruction(target);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.parent.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.parent.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.parent.writeStartDocument(version);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.parent.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.parent.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.parent.writeStartElement(localName);
    }
}

