/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.function;

import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Function;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionCallException;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.function.NumberFunction;
import org.xmlpull.v1.builder.xpath.jaxen.function.RoundFunction;
import org.xmlpull.v1.builder.xpath.jaxen.function.StringFunction;

public class SubstringFunction
implements Function {
    @Override
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 2) {
            return SubstringFunction.evaluate(args.get(0), args.get(1), context.getNavigator());
        }
        if (args.size() == 3) {
            return SubstringFunction.evaluate(args.get(0), args.get(1), args.get(2), context.getNavigator());
        }
        throw new FunctionCallException("substring() requires two or three arguments.");
    }

    public static String evaluate(Object strArg, Object startArg, Navigator nav) {
        String str = StringFunction.evaluate(strArg, nav);
        int start = RoundFunction.evaluate(NumberFunction.evaluate(startArg, nav), nav).intValue();
        return str.substring(--start);
    }

    public static String evaluate(Object strArg, Object startArg, Object lenArg, Navigator nav) {
        String str = StringFunction.evaluate(strArg, nav);
        int start = RoundFunction.evaluate(NumberFunction.evaluate(startArg, nav), nav).intValue();
        int len = RoundFunction.evaluate(NumberFunction.evaluate(lenArg, nav), nav).intValue();
        int end = --start + len;
        return str.substring(start, end);
    }
}

